/*
 * Decompiled with CFR 0.152.
 */
package visualra.ra2sql;

import java.util.Iterator;
import java.util.LinkedHashSet;
import visualra.Language;
import visualra.LogManager;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAHtml;
import visualra.ra2sql.RAOperator;

public class RAThetaJoin
extends RAOperator {
    private String[] conditions;
    private String[] tables = new String[]{"", ""};
    private boolean lastOpLeft;
    private boolean lastOpRight;

    public RAThetaJoin(String table1, String table2, String[] conds) {
        this.type = 7;
        this.argSize = 2;
        this.conditions = new String[conds.length];
        try {
            System.arraycopy(conds, 0, this.conditions, 0, conds.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Array con elementi di tipo errato :" + e);
        }
        if (table1 == null && table2 == null) {
            this.lastOpStatus = 3;
        } else if (table1 == null && table2 != null) {
            this.lastOpStatus = 2;
        } else if (table1 != null && table2 == null) {
            this.lastOpStatus = 1;
        } else if (table1 != null && table2 != null) {
            this.lastOpStatus = 0;
        }
        this.tables[0] = table1;
        this.tables[1] = table2;
    }

    public String[] getTables() {
        String[] tabs = new String[2];
        try {
            System.arraycopy(this.tables, 0, tabs, 0, this.tables.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Errore nella restituzione dell'array delle tabelle :" + e);
        }
        return tabs;
    }

    public void setTables(String[] tabNames) {
        this.tables[0] = tabNames[0];
        this.tables[1] = tabNames[1];
        String table1 = tabNames[0];
        String table2 = tabNames[1];
        if (table1 == null && table2 == null) {
            this.lastOpStatus = 3;
        } else if (table1 == null && table2 != null) {
            this.lastOpStatus = 2;
        } else if (table1 != null && table2 == null) {
            this.lastOpStatus = 1;
        } else if (table1 != null && table2 != null) {
            this.lastOpStatus = 0;
        }
    }

    public String[] getConditions() {
        String[] conds = new String[this.conditions.length];
        try {
            System.arraycopy(this.conditions, 0, conds, 0, this.conditions.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Errore nella restituzione dell'array delle condizioni :" + e);
        }
        return conds;
    }

    public String toString() {
        String op = "";
        op = this.isLastOpLeft() ? String.valueOf(op) + "<font face=\"Courier New\" size=3 color=#AA0000><i><b>" + this.tables[0] + "</b></i></font>" + " " + "<font face=\"Courier New\" size=4 color=blue><b>" + "ThetaJoin" + "</b></font>" + "<font face=\"Courier New\" size=2 color=black>" + ":[" + this.conditions[0] + this.conditions[1] + this.conditions[2] : String.valueOf(op) + ") <font face=\"Courier New\" size=4 color=blue><b>ThetaJoin</b></font><font face=\"Courier New\" size=2 color=black>:[" + this.conditions[0] + this.conditions[1] + this.conditions[2];
        if (this.conditions.length > 3) {
            int i = 3;
            while (i < this.conditions.length) {
                op = String.valueOf(op) + " " + this.conditions[i] + " " + this.conditions[i + 1] + this.conditions[i + 2] + this.conditions[i + 3];
                i += 4;
            }
        }
        op = String.valueOf(op) + "] </font>";
        op = this.isLastOpRight() ? String.valueOf(op) + "<font face=\"Courier New\" size=3 color=#AA0000><i><b>" + this.tables[1] + "</b></i></font>" : String.valueOf(op) + "(";
        return RAHtml.change(op);
    }

    public String toPlainString() {
        String op = "";
        op = this.isLastOpLeft() ? String.valueOf(op) + this.tables[0] + " " + "ThetaJoin" + ":[" + this.conditions[0] + this.conditions[1] + this.conditions[2] : String.valueOf(op) + ") ThetaJoin:[" + this.conditions[0] + this.conditions[1] + this.conditions[2];
        if (this.conditions.length > 3) {
            int i = 3;
            while (i < this.conditions.length) {
                op = String.valueOf(op) + " " + this.conditions[i] + " " + this.conditions[i + 1] + this.conditions[i + 2] + this.conditions[i + 3];
                i += 4;
            }
        }
        op = String.valueOf(op) + "] ";
        op = this.isLastOpRight() ? String.valueOf(op) + this.tables[1] : String.valueOf(op) + "(";
        return op;
    }

    public String toSQL(String[] progrId) throws RAException, DBManagerException {
        String tabLeft = this.isLastOpLeft() ? this.tables[0] : String.valueOf(DBManager.getTempTabPrefix()) + progrId[0];
        String tabRight = this.isLastOpRight() ? this.tables[1] : String.valueOf(DBManager.getTempTabPrefix()) + progrId[1];
        TableSchema tsLeft = DBManager.getTableFields(tabLeft);
        TableSchema tsRight = DBManager.getTableFields(tabRight);
        LinkedHashSet fieldsLeft = (LinkedHashSet)tsLeft.getFieldNames();
        LinkedHashSet fieldsRight = (LinkedHashSet)tsRight.getFieldNames();
        LinkedHashSet sharedFields = new LinkedHashSet(fieldsLeft);
        LinkedHashSet allFieldsLeft = new LinkedHashSet(fieldsLeft);
        LinkedHashSet onlyFieldsRight = new LinkedHashSet(fieldsRight);
        sharedFields.retainAll(fieldsRight);
        onlyFieldsRight.removeAll(sharedFields);
        String sqlQuery = "SELECT DISTINCT ";
        Iterator itrLeft = allFieldsLeft.iterator();
        while (itrLeft.hasNext()) {
            String field = (String)itrLeft.next();
            sqlQuery = sharedFields.contains(field) ? String.valueOf(sqlQuery) + tabLeft + "." + field + " AS " + field + "," : String.valueOf(sqlQuery) + field + ",";
        }
        Iterator itrRight = onlyFieldsRight.iterator();
        while (itrRight.hasNext()) {
            String field = (String)itrRight.next();
            sqlQuery = String.valueOf(sqlQuery) + field + ",";
        }
        sqlQuery = sqlQuery.substring(0, sqlQuery.length() - 1);
        sqlQuery = String.valueOf(sqlQuery) + " FROM " + tabLeft + " INNER JOIN " + tabRight;
        String[] condFieldsLeft = new String[(this.conditions.length + 1) / 4];
        String[] condFieldsRight = new String[(this.conditions.length + 1) / 4];
        if (this.conditions[0].charAt(0) == '(') {
            condFieldsLeft[0] = this.conditions[0].substring(5, this.conditions[0].length());
            condFieldsRight[0] = this.conditions[2].substring(0, this.conditions[2].length() - 1);
            sqlQuery = String.valueOf(sqlQuery) + " ON ((NOT " + tabLeft + "." + this.conditions[0].substring(5, this.conditions[0].length()) + this.conditions[1] + tabRight + "." + this.conditions[2];
        } else {
            condFieldsLeft[0] = this.conditions[0];
            condFieldsRight[0] = this.conditions[2];
            sqlQuery = String.valueOf(sqlQuery) + " ON (" + tabLeft + "." + this.conditions[0] + this.conditions[1] + tabRight + "." + this.conditions[2];
        }
        if (this.conditions.length > 3) {
            int i = 3;
            while (i < this.conditions.length) {
                if (this.conditions[i + 1].charAt(0) == '(') {
                    condFieldsLeft[i / 4] = this.conditions[i + 1].substring(5, this.conditions[i + 1].length());
                    condFieldsRight[i / 4] = this.conditions[i + 3].substring(0, this.conditions[i + 3].length() - 1);
                    sqlQuery = String.valueOf(sqlQuery) + " " + this.conditions[i] + " " + "(NOT " + tabLeft + "." + this.conditions[i + 1].substring(5, this.conditions[i + 1].length()) + this.conditions[i + 2] + tabRight + "." + this.conditions[i + 3];
                } else {
                    condFieldsLeft[i / 4] = this.conditions[i + 1];
                    condFieldsRight[i / 4] = this.conditions[i + 3];
                    sqlQuery = String.valueOf(sqlQuery) + " " + this.conditions[i] + " " + tabLeft + "." + this.conditions[i + 1] + this.conditions[i + 2] + tabRight + "." + this.conditions[i + 3];
                }
                i += 4;
            }
        }
        sqlQuery = String.valueOf(sqlQuery) + ")";
        if (!tsLeft.containsAllFieldsOf(condFieldsLeft) || !tsRight.containsAllFieldsOf(condFieldsRight)) {
            throw new RAException(LogManager.prepareMsg(Language.getInstance().getString("Errore_RA_Theta_campi_mancanti_nell_operando"), true));
        }
        return sqlQuery;
    }
}

