/*
 * Decompiled with CFR 0.152.
 */
package visualra.ra2sql;

import visualra.Language;
import visualra.LogManager;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAHtml;
import visualra.ra2sql.RAOperator;

public class RASelection
extends RAOperator {
    private String[] conditions;
    private String table;

    public RASelection(String[] conds, String table) {
        this.type = 0;
        this.argSize = 1;
        this.conditions = new String[conds.length];
        try {
            System.arraycopy(conds, 0, this.conditions, 0, conds.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Array con elementi di tipo errato :" + e);
        }
        this.table = table;
        this.lastOpStatus = table == null ? 3 : 0;
    }

    public String[] getTables() {
        String[] tabs = new String[2];
        if (this.table != null) {
            tabs[0] = new String(this.table);
            tabs[1] = null;
        } else {
            tabs[0] = null;
            tabs[1] = null;
        }
        return tabs;
    }

    public void setTables(String[] tabNames) {
        this.table = tabNames[0];
        this.lastOpStatus = this.table == null ? 3 : 0;
    }

    public String[] getConditions() {
        String[] conds = new String[this.conditions.length];
        try {
            System.arraycopy(this.conditions, 0, conds, 0, this.conditions.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Errore nella restituzione dell'array delle condizioni :" + e);
        }
        return conds;
    }

    private String FilterLTGT(String s) {
        if (s.equals("<>")) {
            return "&lt;&gt;";
        }
        if (s.equals("<")) {
            return "&lt;";
        }
        if (s.equals(">")) {
            return "&gt;";
        }
        if (s.equals("<=")) {
            return "&lt;=";
        }
        if (s.equals(">=")) {
            return "&gt;=";
        }
        return s;
    }

    public String toString() {
        String op = "<font face=\"Courier New\" size=4 color=blue><b>Sel</b></font> ";
        op = String.valueOf(op) + "<font face=\"Courier New\" size=2 color=black>" + this.conditions[0] + this.FilterLTGT(this.conditions[1]) + this.conditions[2];
        if (this.conditions.length > 3) {
            int i = 3;
            while (i < this.conditions.length) {
                op = String.valueOf(op) + " " + this.conditions[i] + " " + this.conditions[i + 1] + this.FilterLTGT(this.conditions[i + 2]) + this.conditions[i + 3];
                i += 4;
            }
        }
        op = String.valueOf(op) + "</font> (";
        if (this.isLastOp()) {
            op = String.valueOf(op) + "<font face=\"Courier New\" size=3 color=#AA0000><i><b>" + this.table + "</b></i></font>" + ")";
        }
        return RAHtml.change(op);
    }

    public String toPlainString() {
        String op = "Sel ";
        op = String.valueOf(op) + this.conditions[0] + this.conditions[1] + this.conditions[2];
        if (this.conditions.length > 3) {
            int i = 3;
            while (i < this.conditions.length) {
                op = String.valueOf(op) + " " + this.conditions[i] + " " + this.conditions[i + 1] + this.conditions[i + 2] + this.conditions[i + 3];
                i += 4;
            }
        }
        op = String.valueOf(op) + " (";
        if (this.isLastOp()) {
            op = String.valueOf(op) + this.table + ")";
        }
        return op;
    }

    public String toSQL(String[] progrId) throws RAException, DBManagerException {
        int i;
        String tab = this.isLastOp() ? this.table : String.valueOf(DBManager.getTempTabPrefix()) + progrId[0];
        String sqlQuery = "SELECT DISTINCT * FROM " + tab + " WHERE (" + this.conditions[0] + this.conditions[1] + this.conditions[2];
        TableSchema ts = DBManager.getTableFields(tab);
        String[] condFields = new String[(this.conditions.length + 1) / 4];
        condFields[0] = this.conditions[0];
        if (this.conditions.length > 3) {
            i = 4;
            while (i < this.conditions.length) {
                condFields[i / 4] = this.conditions[i];
                i += 4;
            }
        }
        if (!ts.containsAllFieldsOf(condFields)) {
            throw new RAException(LogManager.prepareMsg(Language.getInstance().getString("Errore_RA_Sel_campi_mancanti_nell_operando"), true));
        }
        if (this.conditions.length > 3) {
            i = 3;
            while (i < this.conditions.length) {
                sqlQuery = String.valueOf(sqlQuery) + " " + this.conditions[i] + " " + this.conditions[i + 1] + this.conditions[i + 2] + this.conditions[i + 3];
                i += 4;
            }
        }
        sqlQuery = String.valueOf(sqlQuery) + ")";
        return sqlQuery;
    }
}

