/*
 * Decompiled with CFR 0.152.
 */
package visualra.ra2sql;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import visualra.Language;
import visualra.LogManager;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAHtml;
import visualra.ra2sql.RAOperator;

public class RARename
extends RAOperator {
    private String[] fields;
    private String table;

    public RARename(String[] flds, String table) {
        this.type = 2;
        this.argSize = 1;
        this.fields = new String[flds.length];
        try {
            System.arraycopy(flds, 0, this.fields, 0, flds.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Array con elementi di tipo errato :" + e);
        }
        this.table = table;
        this.lastOpStatus = table == null ? 3 : 0;
    }

    public String[] getTables() {
        String[] tabs = new String[2];
        if (this.table != null) {
            tabs[0] = new String(this.table);
            tabs[1] = null;
        } else {
            tabs[0] = null;
            tabs[1] = null;
        }
        return tabs;
    }

    public void setTables(String[] tabNames) {
        this.table = tabNames[0];
        this.lastOpStatus = this.table == null ? 3 : 0;
    }

    public String[] getFields() {
        String[] flds = new String[this.fields.length];
        try {
            System.arraycopy(this.fields, 0, flds, 0, this.fields.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Errore nella restituzione dell'array dei campi :" + e);
        }
        return flds;
    }

    public String toString() {
        int i;
        String op = "<font face=\"Courier New\" size=4 color=blue><b>Ren</b></font> ";
        op = String.valueOf(op) + "<font face=\"Courier New\" size=2 color=black>" + this.fields[0];
        if (this.fields.length > 2) {
            i = 2;
            while (i < this.fields.length) {
                op = String.valueOf(op) + "," + this.fields[i];
                i += 2;
            }
        }
        op = String.valueOf(op) + "&lt;-";
        op = String.valueOf(op) + this.fields[1];
        if (this.fields.length > 2) {
            i = 3;
            while (i < this.fields.length) {
                op = String.valueOf(op) + "," + this.fields[i];
                i += 2;
            }
        }
        op = String.valueOf(op) + "</font> (";
        if (this.isLastOp()) {
            op = String.valueOf(op) + "<font face=\"Courier New\" size=3 color=#AA0000><i><b>" + this.table + "</b></i></font>" + ")";
        }
        return RAHtml.change(op);
    }

    public String toPlainString() {
        int i;
        String op = "Ren ";
        op = String.valueOf(op) + this.fields[0];
        if (this.fields.length > 2) {
            i = 2;
            while (i < this.fields.length) {
                op = String.valueOf(op) + "," + this.fields[i];
                i += 2;
            }
        }
        op = String.valueOf(op) + "<-";
        op = String.valueOf(op) + this.fields[1];
        if (this.fields.length > 2) {
            i = 3;
            while (i < this.fields.length) {
                op = String.valueOf(op) + "," + this.fields[i];
                i += 2;
            }
        }
        op = String.valueOf(op) + " (";
        if (this.isLastOp()) {
            op = String.valueOf(op) + this.table + ")";
        }
        return op;
    }

    public String toSQL(String[] progrId) throws RAException, DBManagerException {
        String sqlQuery = "SELECT ";
        LinkedHashMap<String, String> fieldsMap = new LinkedHashMap<String, String>();
        fieldsMap.put(this.fields[1], this.fields[0]);
        if (this.fields.length > 2) {
            int i = 2;
            while (i < this.fields.length) {
                fieldsMap.put(this.fields[i + 1], this.fields[i]);
                i += 2;
            }
        }
        String tab = this.isLastOp() ? this.table : String.valueOf(DBManager.getTempTabPrefix()) + progrId[0];
        TableSchema ts = DBManager.getTableFields(tab);
        LinkedHashSet tabFields = (LinkedHashSet)ts.getFieldNames();
        Object[] oldRenamedFieldsObjects = fieldsMap.keySet().toArray();
        String[] oldRenamedFields = new String[fieldsMap.size()];
        int x = 0;
        while (x < fieldsMap.size()) {
            oldRenamedFields[x] = (String)oldRenamedFieldsObjects[x];
            ++x;
        }
        if (!ts.containsAllFieldsOf(oldRenamedFields)) {
            throw new RAException(LogManager.prepareMsg(Language.getInstance().getString("Errore_RA_Ren_campi_mancanti_nell_operando"), true));
        }
        LinkedList newRenamedFields = new LinkedList(fieldsMap.values());
        Iterator iterator = newRenamedFields.iterator();
        while (iterator.hasNext()) {
            String f = (String)iterator.next();
            if (f != null && f.length() != 0 && f.matches("[a-zA-Z][0-9a-zA-Z]*")) continue;
            throw new RAException(LogManager.prepareMsg(Language.getInstance().getString("Errore_RA_Ren_nuovi_campi_errati"), true));
        }
        sqlQuery = "SELECT DISTINCT ";
        Iterator itrf = tabFields.iterator();
        while (itrf.hasNext()) {
            String field = (String)itrf.next();
            sqlQuery = fieldsMap.containsKey(field) ? String.valueOf(sqlQuery) + field + " AS " + fieldsMap.get(field) + "," : String.valueOf(sqlQuery) + field + ",";
        }
        sqlQuery = sqlQuery.substring(0, sqlQuery.length() - 1);
        sqlQuery = String.valueOf(sqlQuery) + " FROM " + tab;
        return sqlQuery;
    }
}

