/*
 * Decompiled with CFR 0.152.
 */
package visualra.ra2sql;

import java.sql.ResultSet;
import javax.swing.tree.DefaultTreeModel;
import visualra.GUIControl.CachedResultSetTableModel;
import visualra.GUIControl.OpNode;
import visualra.LogManager;
import visualra.Project;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAOperator;

public final class RAQuery {
    private static DefaultTreeModel tree = null;

    public static DefaultTreeModel getTree() {
        return tree;
    }

    public static void setTree(DefaultTreeModel newTree) {
        tree = newTree;
    }

    public static ResultSet getRSFromNode(OpNode node) throws DBManagerException, RAException {
        DBManager.deleteAllTempTables();
        String s = RAQuery.executeQueryFromNode(node, "1");
        ResultSet rs = DBManager.executeQuery("SELECT * FROM " + DBManager.getTempTabPrefix() + "1");
        return rs;
    }

    public static String executeQueryFromNode(OpNode node) throws DBManagerException, RAException {
        DBManager.deleteAllTempTables();
        String s = "<html>" + RAQuery.executeQueryFromNode(node, "1");
        DBManager.deleteAllTempTables();
        return s;
    }

    public static String executeQueryFromNode(OpNode node, String tabSuffix) throws DBManagerException, RAException {
        RAOperator op = node.getOp();
        int childNumber = op.getArgSize();
        try {
            if (childNumber == 1) {
                if (op.isLastOp()) {
                    String[] progrId = new String[]{tabSuffix};
                    String sqlQuery = op.toSQL(null);
                    System.out.println(sqlQuery);
                    ResultSet rs = DBManager.executeQuery(sqlQuery);
                    CachedResultSetTableModel crs = DBManager.createTable(rs, String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix);
                    op.setCRS(crs);
                    DBManager.closeRS(rs);
                    DBManager.flush();
                    return op.toString();
                }
                String s = RAQuery.executeQueryFromNode((OpNode)node.getChildAt(0), tabSuffix);
                String[] progrId = new String[]{tabSuffix};
                String sqlQuery = op.toSQL(progrId);
                System.out.println(sqlQuery);
                ResultSet rs = DBManager.executeQuery(sqlQuery);
                CachedResultSetTableModel crs = DBManager.createTable(rs, String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP");
                op.setCRS(crs);
                DBManager.closeRS(rs);
                DBManager.flush();
                DBManager.deleteTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix);
                DBManager.copyTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP", String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix);
                DBManager.deleteTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP");
                return String.valueOf(op.toString()) + s + "<font face=\"Courier New\" size=4 color=black>)</font>";
            }
            if (op.isLastOp()) {
                String sqlQuery = op.toSQL(null);
                System.out.println(sqlQuery);
                ResultSet rs = DBManager.executeQuery(sqlQuery);
                CachedResultSetTableModel crs = DBManager.createTable(rs, String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix);
                op.setCRS(crs);
                DBManager.closeRS(rs);
                DBManager.flush();
                return op.toString();
            }
            if (op.isLastOpLeft()) {
                String tabSuffixDx = String.valueOf(tabSuffix) + "2";
                String dx = RAQuery.executeQueryFromNode((OpNode)node.getChildAt(0), tabSuffixDx);
                String[] progrId = new String[]{"", tabSuffixDx};
                String sqlQuery = op.toSQL(progrId);
                System.out.println(sqlQuery);
                ResultSet rs = DBManager.executeQuery(sqlQuery);
                CachedResultSetTableModel crs = DBManager.createTable(rs, String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP");
                op.setCRS(crs);
                DBManager.closeRS(rs);
                DBManager.flush();
                DBManager.copyTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP", String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix);
                DBManager.deleteTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP");
                DBManager.deleteTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffixDx);
                return String.valueOf(op.toString()) + dx + "<font face=\"Courier New\" size=4 color=black>)</font>";
            }
            if (op.isLastOpRight()) {
                String tabSuffixSx = String.valueOf(tabSuffix) + "1";
                String sx = RAQuery.executeQueryFromNode((OpNode)node.getChildAt(0), tabSuffixSx);
                String[] progrId = new String[]{tabSuffixSx, ""};
                String sqlQuery = op.toSQL(progrId);
                System.out.println(sqlQuery);
                ResultSet rs = DBManager.executeQuery(sqlQuery);
                CachedResultSetTableModel crs = DBManager.createTable(rs, String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP");
                op.setCRS(crs);
                DBManager.closeRS(rs);
                DBManager.flush();
                DBManager.copyTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP", String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix);
                DBManager.deleteTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP");
                DBManager.deleteTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffixSx);
                return "<font face=\"Courier New\" size=4 color=black>(</font>" + sx + op.toString();
            }
            String tabSuffixSx = String.valueOf(tabSuffix) + "1";
            String tabSuffixDx = String.valueOf(tabSuffix) + "2";
            String sx = RAQuery.executeQueryFromNode((OpNode)node.getChildAt(0), tabSuffixSx);
            String dx = RAQuery.executeQueryFromNode((OpNode)node.getChildAt(1), tabSuffixDx);
            String[] progrId = new String[]{tabSuffixSx, tabSuffixDx};
            String sqlQuery = op.toSQL(progrId);
            System.out.println(sqlQuery);
            ResultSet rs = DBManager.executeQuery(sqlQuery);
            CachedResultSetTableModel crs = DBManager.createTable(rs, String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP");
            op.setCRS(crs);
            DBManager.closeRS(rs);
            DBManager.flush();
            DBManager.copyTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP", String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix);
            DBManager.deleteTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffix + "TMP");
            DBManager.deleteTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffixDx);
            DBManager.deleteTable(String.valueOf(DBManager.getTempTabPrefix()) + tabSuffixSx);
            return "<font face=\"Courier New\" size=4 color=black>(</font>" + sx + op.toString() + dx + "<font face=\"Courier New\" size=4 color=black>)</font>";
        }
        catch (DBManagerException dbmex) {
            DBManager.deleteAllTempTables();
            if (dbmex.getOpNode() == null) {
                DBManagerException dbmex2 = new DBManagerException(String.valueOf(dbmex.getMessage()) + "<br>" + LogManager.getArrow() + LogManager.filterBGColor(node.getOp().toString()));
                dbmex2.setOpNode(node);
                throw dbmex2;
            }
            throw dbmex;
        }
        catch (RAException raex) {
            DBManager.deleteAllTempTables();
            if (raex.getOpNode() == null) {
                RAException raex2 = new RAException(String.valueOf(raex.getMessage()) + "<br>" + LogManager.getArrow() + LogManager.filterBGColor(node.getOp().toString()));
                raex2.setOpNode(node);
                throw raex2;
            }
            throw raex;
        }
    }

    public static String executeQuery() throws DBManagerException, RAException {
        String queryRA = null;
        OpNode root = (OpNode)Project.getTree().getRoot();
        if (DBManager.connected()) {
            queryRA = RAQuery.executeQueryFromNode(root);
        }
        return queryRA;
    }

    public static String getRAQueryFromNode(OpNode node) {
        return "<html>" + RAQuery.getRAQueryFromNode(node, 1);
    }

    public static String getRAQueryFromNode(OpNode node, int spaces) {
        RAOperator op = node.getOp();
        int childNumber = op.getArgSize();
        if (childNumber == 1) {
            if (op.isLastOp()) {
                return op.toString();
            }
            String s = RAQuery.getRAQueryFromNode((OpNode)node.getChildAt(0), spaces + 1);
            String spacesString = "";
            int i = 0;
            while (i < spaces) {
                spacesString = String.valueOf(spacesString) + "&#32;&#32;";
                ++i;
            }
            return String.valueOf(op.toString()) + "<BR>" + spacesString + s + "<font face=\"Courier New\" size=4 color=black>)</font>";
        }
        if (op.isLastOp()) {
            return op.toString();
        }
        if (op.isLastOpLeft()) {
            String dx = RAQuery.getRAQueryFromNode((OpNode)node.getChildAt(0), spaces);
            return String.valueOf(op.toString()) + dx + "<font face=\"Courier New\" size=4 color=black>)</font>";
        }
        if (op.isLastOpRight()) {
            String sx = RAQuery.getRAQueryFromNode((OpNode)node.getChildAt(0), spaces);
            return "<font face=\"Courier New\" size=4 color=black>(</font>" + sx + op.toString();
        }
        String sx = RAQuery.getRAQueryFromNode((OpNode)node.getChildAt(0), spaces);
        String dx = RAQuery.getRAQueryFromNode((OpNode)node.getChildAt(1), spaces);
        return "<font face=\"Courier New\" size=4 color=black>(</font>" + sx + op.toString() + dx + "<font face=\"Courier New\" size=4 color=black>)</font>";
    }

    public static String getPlainRAQueryFromNode(OpNode node) {
        return RAQuery.getPlainRAQueryFromNode(node, 1);
    }

    public static String getPlainRAQueryFromNode(OpNode node, int spaces) {
        RAOperator op = node.getOp();
        int childNumber = op.getArgSize();
        if (childNumber == 1) {
            if (op.isLastOp()) {
                return op.toPlainString();
            }
            String s = RAQuery.getPlainRAQueryFromNode((OpNode)node.getChildAt(0), spaces + 1);
            String spacesString = "";
            int i = 0;
            while (i < spaces) {
                spacesString = String.valueOf(spacesString) + "  ";
                ++i;
            }
            return String.valueOf(op.toPlainString()) + " " + spacesString + s + ")";
        }
        if (op.isLastOp()) {
            return op.toPlainString();
        }
        if (op.isLastOpLeft()) {
            String dx = RAQuery.getPlainRAQueryFromNode((OpNode)node.getChildAt(0), spaces);
            return String.valueOf(op.toPlainString()) + dx + ")";
        }
        if (op.isLastOpRight()) {
            String sx = RAQuery.getPlainRAQueryFromNode((OpNode)node.getChildAt(0), spaces);
            return "(" + sx + op.toPlainString();
        }
        String sx = RAQuery.getPlainRAQueryFromNode((OpNode)node.getChildAt(0), spaces);
        String dx = RAQuery.getPlainRAQueryFromNode((OpNode)node.getChildAt(1), spaces);
        return "(" + sx + op.toPlainString() + dx + ")";
    }

    public static String getFullRAQuery() {
        String queryRA = null;
        OpNode root = (OpNode)Project.getTree().getRoot();
        queryRA = RAQuery.getRAQueryFromNode(root);
        return queryRA;
    }

    public static TableSchema getSchemaFromNode(OpNode node) throws DBManagerException, RAException {
        RAQuery.executeQueryFromNode(node, "SCH1");
        TableSchema ts = DBManager.getTableFields(String.valueOf(DBManager.getTempTabPrefix()) + "SCH1");
        DBManager.deleteTable(String.valueOf(DBManager.getTempTabPrefix()) + "SCH1");
        return ts;
    }
}

