/*
 * Decompiled with CFR 0.152.
 */
package visualra.ra2sql;

import visualra.Language;
import visualra.LogManager;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAHtml;
import visualra.ra2sql.RAOperator;

public class RAProjection
extends RAOperator {
    private String[] fields;
    private String table;

    public RAProjection(String[] flds, String table) {
        this.type = 1;
        this.argSize = 1;
        this.fields = new String[flds.length];
        try {
            System.arraycopy(flds, 0, this.fields, 0, flds.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Array con elementi di tipo errato :" + e);
        }
        this.table = table;
        this.lastOpStatus = table == null ? 3 : 0;
    }

    public String[] getTables() {
        String[] tabs = new String[2];
        if (this.table != null) {
            tabs[0] = new String(this.table);
            tabs[1] = null;
        } else {
            tabs[0] = null;
            tabs[1] = null;
        }
        return tabs;
    }

    public void setTables(String[] tabNames) {
        this.table = tabNames[0];
        this.lastOpStatus = this.table == null ? 3 : 0;
    }

    public String[] getFields() {
        String[] flds = new String[this.fields.length];
        try {
            System.arraycopy(this.fields, 0, flds, 0, this.fields.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Errore nella restituzione dell'array dei campi :" + e);
        }
        return flds;
    }

    public String toString() {
        String op = "<font face=\"Courier New\" size=4 color=blue><b>Proj</b></font> <font face=\"Courier New\" size=2 color=black>" + this.fields[0];
        if (this.fields.length > 1) {
            int i = 1;
            while (i < this.fields.length) {
                op = String.valueOf(op) + "," + this.fields[i];
                ++i;
            }
        }
        op = String.valueOf(op) + "</font> (";
        if (this.isLastOp()) {
            op = String.valueOf(op) + "<font face=\"Courier New\" size=3 color=#AA0000><i><b>" + this.table + "</b></i></font>" + ")";
        }
        return RAHtml.change(op);
    }

    public String toPlainString() {
        String op = "Proj " + this.fields[0];
        if (this.fields.length > 1) {
            int i = 1;
            while (i < this.fields.length) {
                op = String.valueOf(op) + "," + this.fields[i];
                ++i;
            }
        }
        op = String.valueOf(op) + " (";
        if (this.isLastOp()) {
            op = String.valueOf(op) + this.table + ")";
        }
        return op;
    }

    public String toSQL(String[] progrId) throws RAException, DBManagerException {
        String sqlQuery = "SELECT DISTINCT " + this.fields[0];
        if (this.fields.length > 1) {
            int i = 1;
            while (i < this.fields.length) {
                sqlQuery = String.valueOf(sqlQuery) + "," + this.fields[i];
                ++i;
            }
        }
        sqlQuery = String.valueOf(sqlQuery) + " FROM ";
        String tab = this.isLastOp() ? this.table : String.valueOf(DBManager.getTempTabPrefix()) + progrId[0];
        TableSchema ts = DBManager.getTableFields(tab);
        if (!ts.containsAllFieldsOf(this.fields)) {
            throw new RAException(LogManager.prepareMsg(Language.getInstance().getString("Errore_RA_Proj_campi_mancanti_nell_operando"), true));
        }
        sqlQuery = String.valueOf(sqlQuery) + tab;
        return sqlQuery;
    }
}

