/*
 * Decompiled with CFR 0.152.
 */
package visualra.ra2sql;

import java.util.Iterator;
import java.util.LinkedHashSet;
import visualra.Language;
import visualra.LogManager;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAHtml;
import visualra.ra2sql.RAOperator;

public class RAMinus
extends RAOperator {
    private String[] tables = new String[]{"", ""};
    private boolean lastOpLeft;
    private boolean lastOpRight;

    public RAMinus(String table1, String table2) {
        this.type = 5;
        this.argSize = 2;
        if (table1 == null && table2 == null) {
            this.lastOpStatus = 3;
        } else if (table1 == null && table2 != null) {
            this.lastOpStatus = 2;
        } else if (table1 != null && table2 == null) {
            this.lastOpStatus = 1;
        } else if (table1 != null && table2 != null) {
            this.lastOpStatus = 0;
        }
        this.tables[0] = table1;
        this.tables[1] = table2;
    }

    public String[] getTables() {
        String[] tabs = new String[2];
        try {
            System.arraycopy(this.tables, 0, tabs, 0, this.tables.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Errore nella restituzione dell'array delle tabelle :" + e);
        }
        return tabs;
    }

    public void setTables(String[] tabNames) {
        this.tables[0] = tabNames[0];
        this.tables[1] = tabNames[1];
        String table1 = tabNames[0];
        String table2 = tabNames[1];
        if (table1 == null && table2 == null) {
            this.lastOpStatus = 3;
        } else if (table1 == null && table2 != null) {
            this.lastOpStatus = 2;
        } else if (table1 != null && table2 == null) {
            this.lastOpStatus = 1;
        } else if (table1 != null && table2 != null) {
            this.lastOpStatus = 0;
        }
    }

    public String toString() {
        String op = "";
        op = this.isLastOpLeft() ? String.valueOf(op) + "<font face=\"Courier New\" size=3 color=#AA0000><i><b>" + this.tables[0] + "</b></i></font>" + " " + "<font face=\"Courier New\" size=4 color=blue><b>" + "-" + "</b></font>" + " " : String.valueOf(op) + ") <font face=\"Courier New\" size=4 color=blue><b>-</b></font> ";
        op = this.isLastOpRight() ? String.valueOf(op) + "<font face=\"Courier New\" size=3 color=#AA0000><i><b>" + this.tables[1] + "</b></i></font>" : String.valueOf(op) + "(";
        return RAHtml.change(op);
    }

    public String toPlainString() {
        String op = "";
        op = this.isLastOpLeft() ? String.valueOf(op) + this.tables[0] + " " + "-" + " " : String.valueOf(op) + ") - ";
        op = this.isLastOpRight() ? String.valueOf(op) + this.tables[1] : String.valueOf(op) + "(";
        return op;
    }

    public String toSQL(String[] progrId) throws RAException, DBManagerException {
        String tabLeft = this.isLastOpLeft() ? this.tables[0] : String.valueOf(DBManager.getTempTabPrefix()) + progrId[0];
        String tabRight = this.isLastOpRight() ? this.tables[1] : String.valueOf(DBManager.getTempTabPrefix()) + progrId[1];
        String sqlQuery = "SELECT DISTINCT * FROM " + tabLeft + " WHERE NOT EXISTS (SELECT DISTINCT * FROM " + tabRight + " WHERE (";
        TableSchema tsl = DBManager.getTableFields(tabLeft);
        TableSchema tsr = DBManager.getTableFields(tabRight);
        if (!tsl.isEqualToExceptOrder(tsr)) {
            throw new RAException(LogManager.prepareMsg(Language.getInstance().getString("Errore_RA_schemi_differenti"), true));
        }
        LinkedHashSet fields = (LinkedHashSet)tsl.getFieldNames();
        Iterator itr = fields.iterator();
        boolean j = false;
        while (itr.hasNext()) {
            String field = (String)itr.next();
            sqlQuery = String.valueOf(sqlQuery) + tabLeft + "." + field + "=" + tabRight + "." + field + " AND ";
        }
        sqlQuery = sqlQuery.substring(0, sqlQuery.length() - 5);
        sqlQuery = String.valueOf(sqlQuery) + "))";
        return sqlQuery;
    }
}

