/*
 * Decompiled with CFR 0.152.
 */
package visualra.ra2sql;

import java.util.Iterator;
import java.util.LinkedHashSet;
import visualra.Language;
import visualra.LogManager;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAHtml;
import visualra.ra2sql.RAOperator;

public class RAFullOuterJoin
extends RAOperator {
    private String[] tables = new String[]{"", ""};
    private boolean lastOpLeft;
    private boolean lastOpRight;

    public RAFullOuterJoin(String table1, String table2) {
        this.type = 10;
        this.argSize = 2;
        if (table1 == null && table2 == null) {
            this.lastOpStatus = 3;
        } else if (table1 == null && table2 != null) {
            this.lastOpStatus = 2;
        } else if (table1 != null && table2 == null) {
            this.lastOpStatus = 1;
        } else if (table1 != null && table2 != null) {
            this.lastOpStatus = 0;
        }
        this.tables[0] = table1;
        this.tables[1] = table2;
    }

    public String[] getTables() {
        String[] tabs = new String[2];
        try {
            System.arraycopy(this.tables, 0, tabs, 0, this.tables.length);
        }
        catch (ArrayStoreException e) {
            System.out.println("Errore nella restituzione dell'array delle tabelle :" + e);
        }
        return tabs;
    }

    public void setTables(String[] tabNames) {
        this.tables[0] = tabNames[0];
        this.tables[1] = tabNames[1];
        String table1 = tabNames[0];
        String table2 = tabNames[1];
        if (table1 == null && table2 == null) {
            this.lastOpStatus = 3;
        } else if (table1 == null && table2 != null) {
            this.lastOpStatus = 2;
        } else if (table1 != null && table2 == null) {
            this.lastOpStatus = 1;
        } else if (table1 != null && table2 != null) {
            this.lastOpStatus = 0;
        }
    }

    public String toString() {
        String op = "";
        op = this.isLastOpLeft() ? String.valueOf(op) + "<font face=\"Courier New\" size=3 color=#AA0000><i><b>" + this.tables[0] + "</b></i></font>" + " " + "<font face=\"Courier New\" size=4 color=blue><b>" + "FullOuterJoin" + "</b></font>" + " " : String.valueOf(op) + ") <font face=\"Courier New\" size=4 color=blue><b>FullOuterJoin</b></font> ";
        op = this.isLastOpRight() ? String.valueOf(op) + "<font face=\"Courier New\" size=3 color=#AA0000><i><b>" + this.tables[1] + "</b></i></font>" : String.valueOf(op) + "(";
        return RAHtml.change(op);
    }

    public String toPlainString() {
        String op = "";
        op = this.isLastOpLeft() ? String.valueOf(op) + this.tables[0] + " " + "FullOuterJoin" + " " : String.valueOf(op) + ") FullOuterJoin ";
        op = this.isLastOpRight() ? String.valueOf(op) + this.tables[1] : String.valueOf(op) + "(";
        return op;
    }

    public String toSQL(String[] progrId) throws RAException, DBManagerException {
        String tabLeft = this.isLastOpLeft() ? this.tables[0] : String.valueOf(DBManager.getTempTabPrefix()) + progrId[0];
        String tabRight = this.isLastOpRight() ? this.tables[1] : String.valueOf(DBManager.getTempTabPrefix()) + progrId[1];
        String sqlQueryLeft = "SELECT DISTINCT ";
        String sqlQueryRight = "SELECT DISTINCT ";
        TableSchema tsLeft = DBManager.getTableFields(tabLeft);
        TableSchema tsRight = DBManager.getTableFields(tabRight);
        LinkedHashSet fieldsLeft = (LinkedHashSet)tsLeft.getFieldNames();
        LinkedHashSet fieldsRight = (LinkedHashSet)tsRight.getFieldNames();
        LinkedHashSet sharedFields = new LinkedHashSet(fieldsLeft);
        LinkedHashSet allFieldsLeft = new LinkedHashSet(fieldsLeft);
        LinkedHashSet onlyFieldsRight = new LinkedHashSet(fieldsRight);
        sharedFields.retainAll(fieldsRight);
        onlyFieldsRight.removeAll(sharedFields);
        int sharedFieldsNumber = sharedFields.size();
        int strictSharedFieldsNumber = tsLeft.numberOfSharedFields(tsRight);
        if (sharedFieldsNumber != strictSharedFieldsNumber) {
            throw new RAException(LogManager.prepareMsg(Language.getInstance().getString("Errore_RA_campi_comuni_non_totalmente_corrispondenti"), true));
        }
        if (sharedFieldsNumber == 0) {
            throw new RAException(LogManager.prepareMsg(Language.getInstance().getString("Errore_RA_nessun_campo_comune"), true));
        }
        String[] conditions = sharedFieldsNumber == 1 ? new String[3] : new String[(sharedFieldsNumber - 1) * 4 + 3];
        Iterator itrShared = sharedFields.iterator();
        int j = 0;
        while (itrShared.hasNext()) {
            String field;
            conditions[j] = field = (String)itrShared.next();
            conditions[j + 1] = "=";
            conditions[j + 2] = field;
            if (conditions.length > j + 3) {
                conditions[j + 3] = "AND";
            }
            j += 4;
        }
        Iterator itrLeft = allFieldsLeft.iterator();
        while (itrLeft.hasNext()) {
            String field = (String)itrLeft.next();
            if (sharedFields.contains(field)) {
                sqlQueryLeft = String.valueOf(sqlQueryLeft) + tabLeft + "." + field + " AS " + field + ",";
                sqlQueryRight = String.valueOf(sqlQueryRight) + tabRight + "." + field + " AS " + field + ",";
                continue;
            }
            sqlQueryLeft = String.valueOf(sqlQueryLeft) + field + ",";
            sqlQueryRight = String.valueOf(sqlQueryRight) + field + ",";
        }
        Iterator itrRight = onlyFieldsRight.iterator();
        while (itrRight.hasNext()) {
            String field = (String)itrRight.next();
            sqlQueryLeft = String.valueOf(sqlQueryLeft) + field + ",";
            sqlQueryRight = String.valueOf(sqlQueryRight) + field + ",";
        }
        sqlQueryLeft = sqlQueryLeft.substring(0, sqlQueryLeft.length() - 1);
        sqlQueryRight = sqlQueryRight.substring(0, sqlQueryRight.length() - 1);
        sqlQueryLeft = String.valueOf(sqlQueryLeft) + " FROM " + tabLeft + " LEFT JOIN " + tabRight;
        sqlQueryRight = String.valueOf(sqlQueryRight) + " FROM " + tabLeft + " RIGHT JOIN " + tabRight;
        sqlQueryLeft = String.valueOf(sqlQueryLeft) + " ON (" + tabLeft + "." + conditions[0] + conditions[1] + tabRight + "." + conditions[2];
        sqlQueryRight = String.valueOf(sqlQueryRight) + " ON (" + tabLeft + "." + conditions[0] + conditions[1] + tabRight + "." + conditions[2];
        if (conditions.length > 3) {
            int i = 3;
            while (i < conditions.length) {
                sqlQueryLeft = String.valueOf(sqlQueryLeft) + " " + conditions[i] + " " + tabLeft + "." + conditions[i + 1] + conditions[i + 2] + tabRight + "." + conditions[i + 3];
                sqlQueryRight = String.valueOf(sqlQueryRight) + " " + conditions[i] + " " + tabLeft + "." + conditions[i + 1] + conditions[i + 2] + tabRight + "." + conditions[i + 3];
                i += 4;
            }
        }
        sqlQueryLeft = String.valueOf(sqlQueryLeft) + ")";
        sqlQueryRight = String.valueOf(sqlQueryRight) + ")";
        return String.valueOf(sqlQueryLeft) + " UNION " + sqlQueryRight;
    }
}

