/*
 * Decompiled with CFR 0.152.
 */
package visualra.database;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import visualra.database.TableField;

public class TableSchema {
    private String name;
    private Set fields;

    TableSchema(String name) {
        this.name = name;
        this.fields = new LinkedHashSet();
    }

    public void add(TableField tf) {
        this.fields.add(tf);
    }

    public String getName() {
        return this.name;
    }

    public Set getFields() {
        return this.fields;
    }

    public Set getFieldNames() {
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        Iterator itr = this.fields.iterator();
        while (itr.hasNext()) {
            fieldNames.add(((TableField)itr.next()).getName());
        }
        return fieldNames;
    }

    public String toString() {
        return this.fields.toString();
    }

    public boolean isEqualTo(TableSchema ts) {
        Vector fields1 = new Vector(this.fields);
        Vector fields2 = new Vector(ts.getFields());
        if (fields1.size() != fields2.size()) {
            return false;
        }
        int i = 0;
        while (i < fields1.size()) {
            if (!((TableField)fields1.elementAt(i)).isEqualTo((TableField)fields2.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqualToExceptOrder(TableSchema ts) {
        return this.containsAllFieldsOf(ts) && ts.containsAllFieldsOf(this);
    }

    public boolean shareFieldsWith(TableSchema ts) {
        Vector fields1 = new Vector(this.fields);
        Vector fields2 = new Vector(ts.getFields());
        int i = 0;
        while (i < fields1.size()) {
            int j = 0;
            while (j < fields2.size()) {
                if (((TableField)fields1.elementAt(i)).isEqualTo((TableField)fields2.elementAt(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public int numberOfSharedFields(TableSchema ts) {
        Vector fields1 = new Vector(this.fields);
        Vector fields2 = new Vector(ts.getFields());
        int n = 0;
        int i = 0;
        while (i < fields1.size()) {
            int j = 0;
            while (j < fields2.size()) {
                if (((TableField)fields1.elementAt(i)).isEqualTo((TableField)fields2.elementAt(j))) {
                    ++n;
                }
                ++j;
            }
            ++i;
        }
        return n;
    }

    public boolean containsAllFieldsOf(TableSchema ts) {
        Vector fields1 = new Vector(this.fields);
        Vector fields2 = new Vector(ts.getFields());
        int k = 0;
        int i = 0;
        while (i < fields2.size()) {
            int j = 0;
            while (j < fields1.size()) {
                if (((TableField)fields1.elementAt(j)).isEqualTo((TableField)fields2.elementAt(i))) {
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return fields2.size() == k;
    }

    public boolean containsAllFieldsOf(String[] list) {
        Vector fields1 = new Vector(this.fields);
        int k = 0;
        int i = 0;
        while (i < list.length) {
            int j = 0;
            while (j < fields1.size()) {
                if (((TableField)fields1.elementAt(j)).getName().equals(list[i])) {
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return list.length == k;
    }
}

