/*
 * Decompiled with CFR 0.152.
 */
package visualra.database;

public class TableField {
    private String name;
    private int type;

    TableField(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeAsString() {
        switch (this.type) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOW";
    }

    public String getTypeAsITString() {
        switch (this.type) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "binario";
            }
            case -7: {
                return "booleano (bit)";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "booleano";
            }
            case 1: {
                return "carattere";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "data";
            }
            case 3: {
                return "decimale";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "doppia precisione";
            }
            case 6: {
                return "singola precisione";
            }
            case 4: {
                return "intero";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "numerico";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "reale";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "ora";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "stringa";
            }
        }
        return "sconosciuto";
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toString() {
        String description = String.valueOf(this.name) + ": ";
        switch (this.type) {
            case 2003: {
                description = String.valueOf(description) + "ARRAY";
                break;
            }
            case -5: {
                description = String.valueOf(description) + "BIGINT";
                break;
            }
            case -2: {
                description = String.valueOf(description) + "BINARY";
                break;
            }
            case -7: {
                description = String.valueOf(description) + "BIT";
                break;
            }
            case 2004: {
                description = String.valueOf(description) + "BLOB";
                break;
            }
            case 16: {
                description = String.valueOf(description) + "BOOLEAN";
                break;
            }
            case 1: {
                description = String.valueOf(description) + "CHAR";
                break;
            }
            case 2005: {
                description = String.valueOf(description) + "CLOB";
                break;
            }
            case 70: {
                description = String.valueOf(description) + "DATALINK";
                break;
            }
            case 91: {
                description = String.valueOf(description) + "DATE";
                break;
            }
            case 3: {
                description = String.valueOf(description) + "DECIMAL";
                break;
            }
            case 2001: {
                description = String.valueOf(description) + "DISTINCT";
                break;
            }
            case 8: {
                description = String.valueOf(description) + "DOUBLE";
                break;
            }
            case 6: {
                description = String.valueOf(description) + "FLOAT";
                break;
            }
            case 4: {
                description = String.valueOf(description) + "INTEGER";
                break;
            }
            case 2000: {
                description = String.valueOf(description) + "JAVA_OBJECT";
                break;
            }
            case -4: {
                description = String.valueOf(description) + "LONGVARBINARY";
                break;
            }
            case -1: {
                description = String.valueOf(description) + "LONGVARCHAR";
                break;
            }
            case 0: {
                description = String.valueOf(description) + "NULL";
                break;
            }
            case 2: {
                description = String.valueOf(description) + "NUMERIC";
                break;
            }
            case 1111: {
                description = String.valueOf(description) + "OTHER";
                break;
            }
            case 7: {
                description = String.valueOf(description) + "REAL";
                break;
            }
            case 2006: {
                description = String.valueOf(description) + "REF";
                break;
            }
            case 5: {
                description = String.valueOf(description) + "SMALLINT";
                break;
            }
            case 2002: {
                description = String.valueOf(description) + "STRUCT";
                break;
            }
            case 92: {
                description = String.valueOf(description) + "TIME";
                break;
            }
            case 93: {
                description = String.valueOf(description) + "TIMESTAMP";
                break;
            }
            case -6: {
                description = String.valueOf(description) + "TINYINT";
                break;
            }
            case -3: {
                description = String.valueOf(description) + "VARBINARY";
                break;
            }
            case 12: {
                description = String.valueOf(description) + "VARCHAR";
                break;
            }
            default: {
                description = String.valueOf(description) + "UNKNOW";
            }
        }
        return description;
    }

    public boolean isEqualTo(TableField tf) {
        return this.name.equals(tf.name) && this.type == tf.type;
    }
}

