/*
 * Decompiled with CFR 0.152.
 */
package visualra.database;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import visualra.GUIControl.CachedResultSetTableModel;
import visualra.Language;
import visualra.LogManager;
import visualra.database.DBManagerException;
import visualra.database.TableField;
import visualra.database.TableSchema;

public final class DBManager {
    private static Connection connection = null;
    private static String driver = null;
    private static String url = null;
    private static String fileName = null;
    private static Set tempTabsList = Collections.synchronizedSet(new LinkedHashSet());
    private static String tempTabPrefix = null;
    private static boolean isFileBased = false;

    private static void deleteTrashTable(String tabName) throws DBManagerException {
        try {
            if (DBManager.connected()) {
                String sqlOperation = "DROP TABLE \"" + tabName + "\"";
                Statement stmt = connection.createStatement();
                stmt.executeUpdate(sqlOperation);
                stmt.close();
            }
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_eliminazione_trash_tab"), true));
        }
    }

    private static void deleteTrashTables() throws DBManagerException {
        Vector deleteList = new Vector(DBManager.getTables());
        int i = 0;
        while (i < deleteList.size()) {
            String table = (String)deleteList.elementAt(i);
            if (table.startsWith("~")) {
                DBManager.deleteTrashTable(table);
            }
            ++i;
        }
    }

    private static boolean tempTabPrefixFoundInDB() throws DBManagerException {
        Vector searchList = new Vector(DBManager.getTables());
        int i = 0;
        while (i < searchList.size()) {
            if (((String)searchList.elementAt(i)).startsWith(tempTabPrefix)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean registerDBFile(File file) throws IOException, InterruptedException {
        try {
            if (file != null) {
                String temp = file.getPath();
                String modPath = "";
                int i = 0;
                while (i < temp.length()) {
                    char c = temp.charAt(i);
                    if (c == '\\') {
                        modPath = String.valueOf(modPath) + '\\';
                    }
                    modPath = String.valueOf(modPath) + c;
                    ++i;
                }
                fileName = modPath;
                File settings = new File("settings.reg");
                if (settings.exists()) {
                    settings.delete();
                }
                PrintWriter fos = new PrintWriter(new FileOutputStream(settings));
                fos.println("Windows Registry Editor Version 5.00");
                fos.println();
                fos.println("[HKEY_CURRENT_USER\\Software\\ODBC\\ODBC.INI\\Database di Microsoft Access]");
                fos.println("\"DBQ\"=\"" + modPath + "\"");
                fos.close();
                Process regedit = Runtime.getRuntime().exec("regedit.exe /s: /i: " + settings.getPath());
                regedit.waitFor();
                return true;
            }
            return false;
        }
        catch (IOException ioex) {
            throw ioex;
        }
        catch (InterruptedException iex) {
            throw iex;
        }
    }

    public static boolean connected() throws DBManagerException {
        try {
            return connection != null && !connection.isClosed();
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_verifica_connessione"), true));
        }
    }

    public static boolean connect(String drv, String urlConnection, String tempTab) throws DBManagerException {
        try {
            DBManager.disconnect();
            Class.forName(drv);
            connection = DriverManager.getConnection(urlConnection);
            connection.setAutoCommit(true);
            driver = drv;
            url = urlConnection;
            tempTabPrefix = tempTab;
            isFileBased = false;
            if (DBManager.tempTabPrefixFoundInDB()) {
                throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_tabelle_con_prefisso_gia_nel_db"), true));
            }
            DBManager.deleteTrashTables();
            return true;
        }
        catch (ClassNotFoundException cnfex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_connessione_senza_successo"), true));
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_connessione_senza_successo"), true));
        }
        catch (Exception ex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_connessione_senza_successo"), true));
        }
    }

    public static boolean connect(String drv, File file, String urlConnection, String tempTab) throws DBManagerException {
        try {
            DBManager.disconnect();
            if (drv.equals("sun.jdbc.odbc.JdbcOdbcDriver")) {
                urlConnection = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + file.getAbsolutePath() + ";DefaultDir=" + file.getParent();
            }
            Class.forName(drv);
            connection = DriverManager.getConnection(urlConnection);
            connection.setAutoCommit(true);
            driver = drv;
            url = urlConnection;
            tempTabPrefix = tempTab;
            isFileBased = true;
            if (DBManager.tempTabPrefixFoundInDB()) {
                throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_tabelle_con_prefisso_gia_nel_db"), true));
            }
            DBManager.deleteTrashTables();
            return true;
        }
        catch (ClassNotFoundException cnfex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_connessione_senza_successo"), true));
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_connessione_senza_successo"), true));
        }
        catch (Exception ex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_connessione_senza_successo"), true));
        }
    }

    public static boolean connect(File file, String tempTab) throws DBManagerException {
        if (driver != null && url != null) {
            return DBManager.connect(driver, file, url, tempTab);
        }
        return false;
    }

    public static boolean reconnect() throws DBManagerException {
        if (driver != null && url != null && fileName != null && tempTabPrefix != null) {
            File file = new File(fileName);
            return DBManager.connect(driver, file, url, tempTabPrefix);
        }
        return false;
    }

    public static boolean disconnect() throws DBManagerException {
        try {
            if (DBManager.connected()) {
                DBManager.deleteAllTempTables();
                connection.close();
                return true;
            }
            return false;
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(String.valueOf(Language.getInstance().getString("La_disconnessione_non_ha_avuto_successo")) + sqlex.getMessage() + ")", true));
        }
    }

    public static void forceDisconnect() throws DBManagerException {
        try {
            connection.close();
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_disconnessione_senza_successo"), true));
        }
    }

    public static String getConnectedFileName() {
        return new String(fileName);
    }

    public static String getTempTabPrefix() {
        return new String(tempTabPrefix);
    }

    public static void flush() throws DBManagerException {
        try {
            connection.commit();
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_flush_dati"), true));
        }
    }

    public static TreeSet getTables() throws DBManagerException {
        try {
            if (DBManager.connected()) {
                TreeSet<String> tabNames = new TreeSet<String>();
                DatabaseMetaData dbmd = connection.getMetaData();
                String[] tableType = new String[]{"TABLE"};
                ResultSet rs = dbmd.getTables(connection.getCatalog(), null, null, tableType);
                while (rs.next()) {
                    String tabName = (String)rs.getObject(3);
                    tabNames.add(tabName);
                }
                rs.close();
                return tabNames;
            }
            return null;
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_estrazione_nomi_tabelle"), true));
        }
    }

    public static TableSchema getTableFields(String tabName) throws DBManagerException {
        try {
            TableSchema ts = new TableSchema(tabName);
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tabName);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int i = 1;
            while (i <= columnCount) {
                String tfName = rsmd.getColumnName(i);
                int tfType = rsmd.getColumnType(i);
                TableField tf = new TableField(tfName, tfType);
                ts.add(tf);
                ++i;
            }
            rs.close();
            stmt.close();
            return ts;
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(String.valueOf(Language.getInstance().getString("Errore_DB_estrazione_schema_tabella")) + " " + (tabName.startsWith(tempTabPrefix) ? Language.getInstance().getString("tabella_temporanea") : tabName) + ")", true));
        }
    }

    public static TableSchema getResultSetFields(ResultSet rs, String name) throws DBManagerException {
        try {
            TableSchema ts = new TableSchema(name);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int i = 1;
            while (i <= columnCount) {
                String tfName = rsmd.getColumnName(i);
                int tfType = rsmd.getColumnType(i);
                TableField tf = new TableField(tfName, tfType);
                ts.add(tf);
                ++i;
            }
            return ts;
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_estrazione_schema"), true));
        }
    }

    public static ResultSet executeQuery(String sqlQuery) throws DBManagerException {
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(sqlQuery);
            return rs;
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_esecuzione_istruzione_SQL_sul_DB"), true));
        }
    }

    public static CachedResultSetTableModel createTable(ResultSet rs, String tabName) throws DBManagerException {
        try {
            if (!tempTabsList.contains(tabName)) {
                String sqlOperation = "CREATE TABLE \"" + tabName + "\" (";
                String fieldList = "";
                TableSchema ts = DBManager.getResultSetFields(rs, tabName);
                LinkedHashSet fields = (LinkedHashSet)ts.getFields();
                int fieldCount = fields.size();
                Vector<String> columnNames = new Vector<String>(fieldCount);
                Iterator itrf = fields.iterator();
                boolean i = false;
                while (itrf.hasNext()) {
                    if (i) {
                        sqlOperation = String.valueOf(sqlOperation) + ",";
                        fieldList = String.valueOf(fieldList) + ",";
                    }
                    TableField f = (TableField)itrf.next();
                    sqlOperation = String.valueOf(sqlOperation) + "\"" + f.getName() + "\" " + f.getTypeAsString();
                    fieldList = String.valueOf(fieldList) + "\"" + f.getName() + "\"";
                    columnNames.addElement(f.getName());
                    i = true;
                }
                sqlOperation = String.valueOf(sqlOperation) + ")";
                Statement stmt = connection.createStatement();
                stmt.executeUpdate(sqlOperation);
                tempTabsList.add(tabName);
                Vector tableData = new Vector();
                while (rs.next()) {
                    Vector<String> rowData = new Vector<String>(fieldCount);
                    String sqlInsert = "INSERT INTO \"" + tabName + "\" (" + fieldList + ") VALUES (";
                    Iterator itrf2 = fields.iterator();
                    String values = "";
                    boolean j = false;
                    while (itrf2.hasNext()) {
                        TableField f = (TableField)itrf2.next();
                        String value = "";
                        if (j) {
                            value = String.valueOf(value) + ",";
                        }
                        switch (f.getType()) {
                            case -7: {
                                String rsValue = rs.getObject(f.getName()).toString();
                                value = String.valueOf(value) + rsValue;
                                rowData.addElement(rsValue);
                                break;
                            }
                            case 16: {
                                String rsValue = rs.getBoolean(f.getName()) ? "true" : "false";
                                value = String.valueOf(value) + rsValue;
                                rowData.addElement(rsValue);
                                break;
                            }
                            case 1: {
                                String rsValue = String.valueOf(rs.getObject(f.getName()));
                                value = String.valueOf(value) + rsValue;
                                rowData.addElement(rsValue);
                                break;
                            }
                            case 8: {
                                String rsValue = String.valueOf(rs.getDouble(f.getName()));
                                value = String.valueOf(value) + rsValue;
                                rowData.addElement(rsValue);
                                break;
                            }
                            case 6: {
                                String rsValue = String.valueOf(rs.getFloat(f.getName()));
                                value = String.valueOf(value) + rsValue;
                                rowData.addElement(rsValue);
                                break;
                            }
                            case 4: {
                                String rsValue = String.valueOf(rs.getInt(f.getName()));
                                value = String.valueOf(value) + rsValue;
                                rowData.addElement(rsValue);
                                break;
                            }
                            case -1: {
                                String rsValue = rs.getString(f.getName());
                                value = String.valueOf(value) + "'" + rsValue + "'";
                                rowData.addElement(rsValue);
                                break;
                            }
                            case 7: {
                                String rsValue = String.valueOf(rs.getFloat(f.getName()));
                                value = String.valueOf(value) + rsValue;
                                rowData.addElement(rsValue);
                                break;
                            }
                            case 5: {
                                String rsValue = String.valueOf(rs.getShort(f.getName()));
                                value = String.valueOf(value) + rsValue;
                                rowData.addElement(rsValue);
                                break;
                            }
                            case -6: {
                                String rsValue = String.valueOf(rs.getByte(f.getName()));
                                value = String.valueOf(value) + rsValue;
                                rowData.addElement(rsValue);
                                break;
                            }
                            case 12: {
                                String rsValue = rs.getString(f.getName());
                                value = String.valueOf(value) + "'" + rsValue + "'";
                                rowData.addElement(rsValue);
                                break;
                            }
                            default: {
                                throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_campo_di_un_tipo_non_supportato"), true));
                            }
                        }
                        j = true;
                        values = String.valueOf(values) + value;
                    }
                    tableData.addElement(rowData);
                    sqlInsert = String.valueOf(sqlInsert) + values + ")";
                    stmt.addBatch(sqlInsert);
                }
                stmt.executeBatch();
                stmt.close();
                DBManager.flush();
                return new CachedResultSetTableModel((Vector)columnNames, tableData);
            }
            return null;
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_creazione_tabella_sul_DB"), true));
        }
    }

    public static void copyTable(String tabSource, String tabDestination) throws DBManagerException {
        try {
            ResultSet rs = DBManager.executeQuery("SELECT * FROM " + tabSource);
            DBManager.createTable(rs, tabDestination);
            Statement stmt = rs.getStatement();
            rs.close();
            stmt.close();
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_copia_tabella_sul_DB"), true));
        }
    }

    public static void deleteTable(String tabName) throws DBManagerException {
        try {
            if (tempTabsList.contains(tabName) && DBManager.connected()) {
                String sqlOperation = "DROP TABLE \"" + tabName + "\"";
                Statement stmt = connection.createStatement();
                stmt.executeUpdate(sqlOperation);
                stmt.close();
                tempTabsList.remove(tabName);
            }
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_eliminazione_tabella_dal_DB"), true));
        }
    }

    public static void closeRS(ResultSet rs) throws DBManagerException {
        try {
            Statement stmt = rs.getStatement();
            rs.close();
            stmt.close();
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_non_definito"), true));
        }
    }

    public static void deleteAllTempTables() throws DBManagerException {
        Vector deleteList = new Vector(tempTabsList);
        int i = 0;
        while (i < deleteList.size()) {
            DBManager.deleteTable((String)deleteList.elementAt(i));
            ++i;
        }
    }

    public static void removeFromTempTables(String tab) throws DBManagerException {
        tempTabsList.remove(tab);
    }
}

