/*
 * Decompiled with CFR 0.152.
 */
package visualra;

import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import visualra.GUIControl.GUI;
import visualra.Language;
import visualra.SplashScreen;

public class VisualRA {
    public static final String DB_DRIVER_KEY = "DB_DRIVER";
    public static final String DB_URL_KEY = "DB_URL";
    public static final String DB_TEMPTAB_PREFIX_KEY = "DB_TEMPTAB_PREFIX";
    public static final String SPLASHSCREEN_TIMEOUT_KEY = "SPLASHSCREEN_TIMEOUT";
    public static final String LAST_PROJECT_PATH_KEY = "LAST_PROJECT_PATH";
    public static final String LAST_USED_DB_FILE_KEY = "LAST_USED_DB_FILE";
    public static final String DEFAULT_DB_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String DEFAULT_DB_URL = "jdbc:odbc:Database di Microsoft Access";
    public static final String DEFAULT_DB_TEMPTAB_PREFIX = "TempTab";
    public static final String DEFAULT_SPLASHSCREEN_TIMEOUT = "4000";
    public static final String DEFAULT_LAST_PROJECT_PATH = System.getProperty("user.dir");
    public static final String DEFAULT_LAST_USED_DB_FILE = "";
    public static final String CONFIG_FILE_NAME = "visualra.cfg";
    public static boolean SplashScreenOpened = true;
    public static Map cfgMap;
    public GUI gui;
    public SplashScreen sc;

    public VisualRA(String startProjectFilename) {
        try {
            this.creaPreferences();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        cfgMap = new LinkedHashMap();
        cfgMap.put(DB_DRIVER_KEY, DEFAULT_DB_DRIVER);
        cfgMap.put(DB_URL_KEY, DEFAULT_DB_URL);
        cfgMap.put(DB_TEMPTAB_PREFIX_KEY, DEFAULT_DB_TEMPTAB_PREFIX);
        cfgMap.put(SPLASHSCREEN_TIMEOUT_KEY, DEFAULT_SPLASHSCREEN_TIMEOUT);
        cfgMap.put(LAST_PROJECT_PATH_KEY, DEFAULT_LAST_PROJECT_PATH);
        cfgMap.put(LAST_USED_DB_FILE_KEY, DEFAULT_LAST_USED_DB_FILE);
        VisualRA.loadConfigSettings();
        this.sc = new SplashScreen(new Frame(), Integer.parseInt((String)cfgMap.get(SPLASHSCREEN_TIMEOUT_KEY)));
        this.gui = new GUI();
        this.gui.setAscoltatori();
        while (SplashScreenOpened) {
        }
        ((Component)this.gui).setVisible(true);
        if (startProjectFilename != null) {
            this.gui.getAscoltatori().openStartingProject(startProjectFilename);
        }
    }

    public void creaPreferences() {
        File filePreferences = new File("Preferences");
        Properties pr = new Properties();
        try {
            if (!filePreferences.exists()) {
                Language l = Language.getInstance();
                Locale.setDefault(l.getLocale());
                FileOutputStream out = new FileOutputStream("Preferences");
                ((Hashtable)pr).put("lingua", l.getLocale().getDisplayLanguage());
                pr.store(out, null);
                out.close();
            } else {
                FileInputStream in = new FileInputStream("Preferences");
                pr.load(in);
                String linguaScelta = pr.getProperty("lingua");
                Language.getInstance().chooseLanguage(linguaScelta);
                in.close();
            }
        }
        catch (FileNotFoundException fnfex) {
            System.out.println(fnfex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void loadConfigSettings() {
        try {
            File configFile = new File(CONFIG_FILE_NAME);
            if (configFile.exists() && configFile.canRead()) {
                FileInputStream configFileStream = new FileInputStream(configFile);
                InputStreamReader isr = new InputStreamReader(configFileStream);
                BufferedReader br = new BufferedReader(isr);
                int separatorPosition = 0;
                while (br.ready()) {
                    String configString = br.readLine();
                    separatorPosition = configString.indexOf(61);
                    if (separatorPosition < 0) {
                        System.out.println("Formato dei dati errato nel file di configurazione : il separatore dei campo deve essere il carattere ','");
                    }
                    String configKey = configString.substring(0, separatorPosition);
                    String configValue = configString.substring(separatorPosition + 1, configString.length());
                    if (!cfgMap.containsKey(configKey)) continue;
                    cfgMap.put(configKey, configValue);
                }
                configFileStream.close();
            }
        }
        catch (FileNotFoundException fnfex) {
            System.out.println(fnfex.getMessage());
            System.exit(1);
        }
        catch (IOException ioex) {
            System.out.println(ioex.getMessage());
            System.exit(1);
        }
    }

    public static void saveConfigSettings() {
        try {
            File configFile = new File(CONFIG_FILE_NAME);
            if (configFile.exists() && configFile.canWrite()) {
                PrintWriter fos = new PrintWriter(new FileOutputStream(configFile));
                fos.println("DB_DRIVER=" + cfgMap.get(DB_DRIVER_KEY));
                fos.println("DB_URL=" + cfgMap.get(DB_URL_KEY));
                fos.println("DB_TEMPTAB_PREFIX=" + cfgMap.get(DB_TEMPTAB_PREFIX_KEY));
                fos.println("SPLASHSCREEN_TIMEOUT=" + cfgMap.get(SPLASHSCREEN_TIMEOUT_KEY));
                fos.println("LAST_PROJECT_PATH=" + cfgMap.get(LAST_PROJECT_PATH_KEY));
                fos.println("LAST_USED_DB_FILE=" + cfgMap.get(LAST_USED_DB_FILE_KEY));
                fos.close();
            }
        }
        catch (FileNotFoundException fnfex) {
            System.out.println(fnfex.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "There was an error while attempting to set the graphic configuration.\nA standard configuration will be used!", "Look&Feel Error", 0);
        }
        if (args.length == 1) {
            new VisualRA(args[0]);
        } else {
            new VisualRA(null);
        }
    }
}

