/*
 * Decompiled with CFR 0.152.
 */
package visualra;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.tree.DefaultTreeModel;
import visualra.GUIControl.OpNode;
import visualra.Language;
import visualra.database.DBManagerException;

public class ProjectFile
implements Serializable {
    private String dbDriver;
    private String dbUrl;
    private String dbFileName;
    private String dbTemptabPrefix;
    private transient String fileName;
    private String title;
    private DefaultTreeModel tree;

    public ProjectFile() {
        this.dbDriver = null;
        this.dbUrl = null;
        this.dbFileName = null;
        this.dbTemptabPrefix = null;
        this.fileName = null;
        this.title = null;
        this.tree = null;
    }

    public ProjectFile(String dbDriver, String dbUrl, String dbFileName, String dbTemptabPrefix, String fileName, String title, DefaultTreeModel tree) {
        this.dbDriver = dbDriver;
        this.dbUrl = dbUrl;
        this.dbFileName = dbFileName;
        this.dbTemptabPrefix = dbTemptabPrefix;
        this.fileName = fileName;
        this.title = title;
        this.tree = tree;
    }

    public static DefaultTreeModel getFakeTree() {
        OpNode fakeRoot = new OpNode(Language.getInstance().getString("albero_vuoto"), null);
        return new DefaultTreeModel(fakeRoot);
    }

    public static ProjectFile load(String projectFileName) throws DBManagerException {
        ProjectFile project = null;
        try {
            File loadFile = new File(projectFileName);
            if (loadFile.exists()) {
                FileInputStream loadFileStream = new FileInputStream(loadFile);
                ObjectInputStream stream = new ObjectInputStream(loadFileStream);
                project = (ProjectFile)stream.readObject();
                stream.close();
            }
            project.setFileName(projectFileName);
            return project;
        }
        catch (FileNotFoundException fnfex) {
            System.out.println(fnfex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return null;
    }

    public static void save(ProjectFile project) {
        try {
            File saveFile = new File(project.getFileName());
            FileOutputStream saveFileStream = new FileOutputStream(saveFile);
            ObjectOutputStream stream = new ObjectOutputStream(saveFileStream);
            stream.writeObject(project);
            stream.close();
        }
        catch (FileNotFoundException fnfex) {
            System.out.println(fnfex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public String getDBDriver() {
        return this.dbDriver;
    }

    public String getDBUrl() {
        return this.dbUrl;
    }

    public String getDBFileName() {
        return this.dbFileName;
    }

    public String getDBTemptabPrefix() {
        return this.dbTemptabPrefix;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTitle() {
        return this.title;
    }

    public DefaultTreeModel getTree() {
        return this.tree;
    }

    public void setDBDriver(String newDBDriver) {
        this.dbDriver = newDBDriver;
    }

    public void setDBUrl(String newDBUrl) {
        this.dbUrl = newDBUrl;
    }

    public void setDBFileName(String newDBFileName) {
        this.dbFileName = newDBFileName;
    }

    public void setDBTemptabPrefix(String newDBTemptabPrefix) {
        this.dbTemptabPrefix = newDBTemptabPrefix;
    }

    public void setFileName(String newProjectFileName) {
        this.fileName = newProjectFileName;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public void setTree(DefaultTreeModel newTree) {
        this.tree = newTree;
    }
}

