/*
 * Decompiled with CFR 0.152.
 */
package visualra;

import javax.swing.tree.DefaultTreeModel;
import visualra.ProjectFile;
import visualra.ra2sql.RAQuery;

public class Project {
    private static String dbDriver;
    private static String dbUrl;
    private static String dbFileName;
    private static String dbTemptabPrefix;
    private static String fileName;
    private static String title;
    private static DefaultTreeModel tree;
    private static boolean loaded;

    static {
        loaded = false;
        dbDriver = null;
        dbUrl = null;
        dbFileName = null;
        dbTemptabPrefix = null;
        fileName = null;
        title = null;
        tree = ProjectFile.getFakeTree();
        RAQuery.setTree(null);
    }

    public static String getDBDriver() {
        return dbDriver;
    }

    public static String getDBUrl() {
        return dbUrl;
    }

    public static String getDBFileName() {
        return dbFileName;
    }

    public static String getDBTemptabPrefix() {
        return dbTemptabPrefix;
    }

    public static String getFileName() {
        return fileName;
    }

    public static String getTitle() {
        return title;
    }

    public static DefaultTreeModel getTree() {
        return tree;
    }

    public static void setFileName(String newFileName) {
        fileName = newFileName;
    }

    public static void setTree(DefaultTreeModel newTree) {
        tree = newTree;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void setLoaded(boolean status) {
        loaded = status;
    }

    public static void clearAll() {
        loaded = false;
        dbDriver = null;
        dbUrl = null;
        dbFileName = null;
        dbTemptabPrefix = null;
        fileName = null;
        title = null;
        tree = ProjectFile.getFakeTree();
        RAQuery.setTree(null);
    }

    public static void clearTree() {
        loaded = false;
        tree = ProjectFile.getFakeTree();
        RAQuery.setTree(null);
    }

    public static ProjectFile getProjectFile() {
        if (loaded) {
            return new ProjectFile(dbDriver, dbUrl, dbFileName, dbTemptabPrefix, fileName, title, tree);
        }
        return null;
    }

    public static void setNewProjectFile(ProjectFile project) {
        loaded = false;
        dbDriver = project.getDBDriver();
        dbUrl = project.getDBUrl();
        dbFileName = project.getDBFileName();
        dbTemptabPrefix = project.getDBTemptabPrefix();
        fileName = project.getFileName();
        title = project.getTitle();
        tree = project.getTree();
        RAQuery.setTree(tree);
    }

    public static void setProjectFile(ProjectFile project) {
        loaded = true;
        dbDriver = project.getDBDriver();
        dbUrl = project.getDBUrl();
        dbFileName = project.getDBFileName();
        dbTemptabPrefix = project.getDBTemptabPrefix();
        fileName = project.getFileName();
        title = project.getTitle();
        tree = project.getTree();
        RAQuery.setTree(tree);
    }

    public static boolean isFileBasedDB() {
        return fileName != null;
    }
}

