/*
 * Decompiled with CFR 0.152.
 */
package visualra.GUIControl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import visualra.GUIControl.GUI;
import visualra.GUIControl.OpNode;
import visualra.Language;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableField;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAIntersect;
import visualra.ra2sql.RAMinus;
import visualra.ra2sql.RAOperator;
import visualra.ra2sql.RAQuery;
import visualra.ra2sql.RAUnion;

public class SetOperatorDialog
extends JDialog
implements ActionListener {
    private static final boolean EDIT_MODE = true;
    private static final boolean INSERT_MODE = false;
    private static final boolean UP_DIRECTION = true;
    private static final boolean DOWN_DIRECTION = false;
    private static final boolean LINK_LEFT = true;
    private static final boolean LINK_RIGHT = false;
    private boolean isEditing;
    private boolean editDirection;
    private boolean selectedNodeLinkPosition;
    private boolean treeValid;
    private JPanel panComandi;
    private JButton conferma;
    private JButton esci;
    GridBagLayout gbl;
    GridBagConstraints c;
    Container contentPane;
    Riga riga1;
    Riga riga2;
    RadioButton check;
    OpNode newNode;
    OpNode clickedNode;
    String nomeTab1 = "";
    String nomeTab2 = "";
    String set = "";
    Language l = Language.getInstance();
    GUI gui;

    public SetOperatorDialog(OpNode clickedNode, OpNode newNode, boolean isEditing, boolean editDirection, boolean selectedNodeLinkPosition, boolean treeValid, GUI g) {
        this.gui = g;
        this.newNode = newNode;
        this.clickedNode = clickedNode;
        this.isEditing = isEditing;
        this.editDirection = editDirection;
        this.selectedNodeLinkPosition = selectedNodeLinkPosition;
        this.treeValid = treeValid;
        this.setTitle(this.l.getString("Insiemistici"));
        JMenu help = new JMenu();
        JMenuItem helpTopics = new JMenuItem("", 71);
        helpTopics.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpTopics.addActionListener(this);
        help.add(helpTopics);
        help.setVisible(false);
        JMenuBar bar = new JMenuBar();
        bar.add(help);
        this.setJMenuBar(bar);
        this.gbl = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.weightx = 1.0;
        this.c.weighty = 0.1;
        this.c.gridwidth = 0;
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(this.gbl);
        Font titolo = new Font(null, 0, 18);
        JLabel intestazione = new JLabel("<html><b><font color=blue>" + this.l.getString("Insiemistici") + "</font></b>");
        intestazione.setFont(titolo);
        JPanel panTitle = new JPanel(new FlowLayout(1));
        panTitle.add(intestazione);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.gbl.setConstraints(panTitle, this.c);
        this.contentPane.add(panTitle);
        String[] nomiTabelle = null;
        try {
            Vector tabs = new Vector(DBManager.getTables());
            nomiTabelle = new String[tabs.size()];
            int i = 0;
            while (i < tabs.size()) {
                nomiTabelle[i] = (String)tabs.elementAt(i);
                ++i;
            }
        }
        catch (DBManagerException dbmex) {
            if (dbmex.isRACaused()) {
                this.gui.semaforo.setRosso();
            }
            this.gui.dialogWindow.append(dbmex.getMessage());
        }
        int opType = clickedNode.getOp().getType();
        if (isEditing) {
            nomiTabelle = new String[2];
            switch (opType) {
                case 3: {
                    nomiTabelle = ((RAUnion)clickedNode.getOp()).getTables();
                    this.set = this.l.getString("Unione");
                    break;
                }
                case 4: {
                    nomiTabelle = ((RAIntersect)clickedNode.getOp()).getTables();
                    this.set = this.l.getString("Intersezione");
                    break;
                }
                case 5: {
                    nomiTabelle = ((RAMinus)clickedNode.getOp()).getTables();
                    this.set = this.l.getString("Differenza");
                }
            }
            this.nomeTab1 = nomiTabelle[0];
            this.nomeTab2 = nomiTabelle[1];
        } else if (!editDirection) {
            this.nomeTab1 = nomiTabelle[0];
            this.nomeTab2 = nomiTabelle[1];
        } else if (selectedNodeLinkPosition) {
            this.nomeTab1 = null;
            this.nomeTab2 = nomiTabelle[0];
        } else {
            this.nomeTab1 = nomiTabelle[0];
            this.nomeTab2 = null;
        }
        try {
            this.gui.semaforo.setVerde();
            TableSchema ts1 = null;
            TableSchema ts2 = null;
            if (isEditing) {
                if (this.clickedNode.getOp().isLastOp()) {
                    this.riga1 = new Riga(this.nomeTab1);
                    this.riga2 = new Riga(this.nomeTab2);
                } else if (this.clickedNode.getOp().isLastOpLeft()) {
                    this.riga1 = new Riga(this.nomeTab1);
                    ts2 = RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(0));
                    this.riga2 = new Riga(ts2);
                } else if (this.clickedNode.getOp().isLastOpRight()) {
                    ts1 = RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(0));
                    this.riga1 = new Riga(ts1);
                    this.riga2 = new Riga(this.nomeTab2);
                } else {
                    ts1 = RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(0));
                    this.riga1 = new Riga(ts1);
                    ts2 = RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(1));
                    this.riga2 = new Riga(ts2);
                }
            } else if (!editDirection) {
                this.riga1 = new Riga(this.nomeTab1);
                this.riga2 = new Riga(this.nomeTab2);
            } else if (selectedNodeLinkPosition) {
                ts1 = RAQuery.getSchemaFromNode(this.clickedNode);
                this.riga1 = new Riga(ts1);
                this.riga2 = new Riga(this.nomeTab2);
            } else {
                this.riga1 = new Riga(this.nomeTab1);
                ts2 = RAQuery.getSchemaFromNode(this.clickedNode);
                this.riga2 = new Riga(ts2);
            }
            this.c.gridy = 1;
            this.gbl.setConstraints(this.riga1, this.c);
            this.contentPane.add(this.riga1);
            this.check = new RadioButton(this.set);
            this.c.gridy = 3;
            this.gbl.setConstraints(this.riga2, this.c);
            this.contentPane.add(this.riga2);
        }
        catch (DBManagerException dbmex) {
            if (dbmex.isRACaused()) {
                this.gui.semaforo.setRosso();
            }
            this.gui.dialogWindow.append(dbmex.getMessage());
        }
        catch (RAException raex) {
            this.gui.semaforo.setRosso();
            this.gui.dialogWindow.append(raex.getMessage());
        }
        this.check = !this.set.equals("") ? new RadioButton(this.set) : new RadioButton(this.l.getString("Unione"));
        this.c.gridy = 2;
        this.gbl.setConstraints(this.check, this.c);
        this.contentPane.add(this.check);
        this.panComandi = new JPanel(new FlowLayout(1));
        this.conferma = new JButton(this.l.getString("Conferma"));
        this.conferma.addActionListener(new AscoltaConferma());
        this.panComandi.add(this.conferma);
        this.esci = new JButton(this.l.getString("Annulla"));
        this.esci.addActionListener(new AscoltaEsci());
        this.panComandi.add(this.esci);
        this.c.gridy = 4;
        this.gbl.setConstraints(this.panComandi, this.c);
        this.contentPane.add(this.panComandi);
        this.addWindowListener(new AscoltaExit());
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.centra();
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.gui.showHelp(null, this, "help17.html");
    }

    private void centra() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setSize(frameSize);
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public class Riga
    extends JPanel {
        JPanel panField = new JPanel(new BorderLayout());
        String[] tabelle;
        Set fieldsName = new LinkedHashSet();
        String nomeTab = new String();
        TableSchema ts = null;
        JPanel panTab = new JPanel(new FlowLayout(1));

        public Riga(String nomeTab) {
            this.setLayout(new FlowLayout(0));
            JPanel contieneTabelle = new JPanel(new GridLayout(2, 1));
            JLabel labelTabelle = new JLabel("<html><b><font color=blue>" + SetOperatorDialog.this.l.getString("Lista_Tabelle") + "</font></b>");
            contieneTabelle.add(labelTabelle);
            String[] tabList = this.creaListaTabelle();
            JComboBox<String> tabCombo = new JComboBox<String>(tabList);
            tabCombo.addActionListener(new AscoltaTabs());
            if (!nomeTab.equals("")) {
                tabCombo.setSelectedItem(nomeTab);
            } else {
                tabCombo.setSelectedItem(tabList[0]);
            }
            contieneTabelle.add(tabCombo);
            this.panTab.add(contieneTabelle);
            this.add(this.panTab);
            try {
                this.ts = DBManager.getTableFields(nomeTab);
                this.creaListaCampi(this.ts);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    SetOperatorDialog.this.gui.semaforo.setRosso();
                }
                SetOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
            SetOperatorDialog.this.pack();
        }

        public Riga(TableSchema ts) {
            this.creaListaCampi(ts);
            this.ts = ts;
        }

        public String[] creaListaTabelle() {
            try {
                TreeSet ts = DBManager.getTables();
                this.tabelle = new String[ts.size()];
                ts.toArray(this.tabelle);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    SetOperatorDialog.this.gui.semaforo.setRosso();
                }
                SetOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
            return this.tabelle;
        }

        public Set creaListaCampi(TableSchema ts) {
            JLabel titoloTabella;
            JPanel titoloCampiTabella = new JPanel(new FlowLayout(0));
            Font titolo = new Font(null, 0, 13);
            JPanel campi = new JPanel(new GridLayout(0, 1, 1, 1));
            titoloCampiTabella.removeAll();
            this.panField.removeAll();
            this.fieldsName.clear();
            Set set = ts.getFieldNames();
            Set setField = ts.getFields();
            Iterator it = set.iterator();
            Iterator itf = setField.iterator();
            if (!this.nomeTab.equals("")) {
                this.panField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
                titoloTabella = new JLabel("<html><font size=4 color=blue>" + SetOperatorDialog.this.l.getString("Campi_di") + " " + this.nomeTab + "</font>");
            } else {
                this.panField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
                titoloTabella = new JLabel("<html><font size=4 color=blue>" + SetOperatorDialog.this.l.getString("Campi_Disponibili") + "</font>");
            }
            titoloCampiTabella.add(titoloTabella);
            campi.add(titoloCampiTabella);
            while (it.hasNext()) {
                String nome = (String)it.next();
                String tipo = ((TableField)itf.next()).getTypeAsITString();
                JLabel nomeCampo = new JLabel("<html><font face=\"Courier New\" size=3><b>" + nome + "</b>: <i>" + tipo + "</font></i>");
                campi.add(nomeCampo);
                this.panField.add(campi);
                this.fieldsName.add(nome);
                this.add(this.panField);
                SetOperatorDialog.this.pack();
            }
            return this.fieldsName;
        }

        private class AscoltaTabs
        implements ActionListener {
            AscoltaTabs() {
            }

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                Riga.this.nomeTab = (String)cb.getSelectedItem();
                try {
                    Riga.this.ts = DBManager.getTableFields(Riga.this.nomeTab);
                    Set listaCampi = Riga.this.creaListaCampi(Riga.this.ts);
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        ((Riga)Riga.this).SetOperatorDialog.this.gui.semaforo.setRosso();
                    }
                    ((Riga)Riga.this).SetOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
                }
            }
        }
    }

    private class AscoltaConferma
    implements ActionListener {
        RAOperator op = null;
        String[] selectedTabs = new String[2];

        AscoltaConferma() {
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = new JFrame();
            if (SetOperatorDialog.this.riga1.ts.isEqualToExceptOrder(SetOperatorDialog.this.riga2.ts)) {
                int n = JOptionPane.showConfirmDialog(frame, SetOperatorDialog.this.l.getString("Confermare_i_dati_selezionati?"), SetOperatorDialog.this.l.getString("Conferma_dati_immessi..."), 2);
                if (n == 0) {
                    this.confermato();
                }
            } else {
                Object[] possibleValues = new Object[]{SetOperatorDialog.this.l.getString("IgnoraProsegui"), SetOperatorDialog.this.l.getString("Correggi")};
                int n = JOptionPane.showOptionDialog(null, SetOperatorDialog.this.l.getString("I_2_schemi_risultano_differenti_!"), SetOperatorDialog.this.l.getString("Dati_non_validi"), -1, 2, null, possibleValues, possibleValues[1]);
                if (n == 0) {
                    this.confermato();
                }
            }
        }

        private void confermato() {
            this.op = SetOperatorDialog.this.check.operator.equals(SetOperatorDialog.this.l.getString("Unione")) ? new RAUnion(null, null) : (SetOperatorDialog.this.check.operator.equals(SetOperatorDialog.this.l.getString("Intersezione")) ? new RAIntersect(null, null) : new RAMinus(null, null));
            if (SetOperatorDialog.this.isEditing) {
                if (SetOperatorDialog.this.clickedNode.getOp().isLastOp()) {
                    this.selectedTabs[0] = SetOperatorDialog.this.riga1.nomeTab;
                    this.selectedTabs[1] = SetOperatorDialog.this.riga2.nomeTab;
                } else if (SetOperatorDialog.this.clickedNode.getOp().isLastOpLeft()) {
                    this.selectedTabs[0] = SetOperatorDialog.this.riga1.nomeTab;
                    this.selectedTabs[1] = null;
                } else if (SetOperatorDialog.this.clickedNode.getOp().isLastOpRight()) {
                    this.selectedTabs[0] = null;
                    this.selectedTabs[1] = SetOperatorDialog.this.riga2.nomeTab;
                } else {
                    this.selectedTabs[0] = null;
                    this.selectedTabs[1] = null;
                }
            } else if (!SetOperatorDialog.this.editDirection) {
                this.selectedTabs[0] = SetOperatorDialog.this.riga1.nomeTab;
                this.selectedTabs[1] = SetOperatorDialog.this.riga2.nomeTab;
            } else if (SetOperatorDialog.this.selectedNodeLinkPosition) {
                this.selectedTabs[0] = null;
                this.selectedTabs[1] = SetOperatorDialog.this.riga2.nomeTab;
            } else {
                this.selectedTabs[0] = SetOperatorDialog.this.riga1.nomeTab;
                this.selectedTabs[1] = null;
            }
            this.op.setTables(this.selectedTabs);
            SetOperatorDialog.this.newNode.updateOp("<html>" + this.op.toString(), this.op);
            SetOperatorDialog.this.dispose();
        }
    }

    private class AscoltaEsci
    implements ActionListener {
        AscoltaEsci() {
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = new JFrame();
            int n = JOptionPane.showConfirmDialog(frame, SetOperatorDialog.this.l.getString("Vuoi_annullare_davvero_l'operazione?"), SetOperatorDialog.this.l.getString("Esci_da_Insiemistici..."), 2);
            if (n == 0) {
                if (SetOperatorDialog.this.isEditing) {
                    if (SetOperatorDialog.this.treeValid) {
                        SetOperatorDialog.this.newNode.updateOp("<html>" + SetOperatorDialog.this.clickedNode.getOp().toString(), SetOperatorDialog.this.clickedNode.getOp());
                    } else {
                        SetOperatorDialog.this.newNode.updateOp(null, null);
                    }
                } else {
                    SetOperatorDialog.this.newNode.updateOp(null, null);
                }
                SetOperatorDialog.this.dispose();
            }
        }
    }

    private class AscoltaExit
    extends WindowAdapter {
        AscoltaExit() {
        }

        public void windowClosing(WindowEvent e) {
            if (SetOperatorDialog.this.isEditing) {
                if (SetOperatorDialog.this.treeValid) {
                    SetOperatorDialog.this.newNode.updateOp("<html>" + SetOperatorDialog.this.clickedNode.getOp().toString(), SetOperatorDialog.this.clickedNode.getOp());
                } else {
                    SetOperatorDialog.this.newNode.updateOp(null, null);
                }
            } else {
                SetOperatorDialog.this.newNode.updateOp(null, null);
            }
            SetOperatorDialog.this.dispose();
        }
    }

    public class RadioButton
    extends JPanel
    implements ActionListener {
        String unione;
        String intersezione;
        String differenza;
        String operator;

        public RadioButton(String defaultValue) {
            this.unione = SetOperatorDialog.this.l.getString("Unione");
            this.intersezione = SetOperatorDialog.this.l.getString("Intersezione");
            this.differenza = SetOperatorDialog.this.l.getString("Differenza");
            this.operator = SetOperatorDialog.this.l.getString("Unione");
            JRadioButton unioneButton = new JRadioButton(this.unione);
            unioneButton.setMnemonic(66);
            unioneButton.setActionCommand(this.unione);
            JRadioButton intersezioneButton = new JRadioButton(this.intersezione);
            intersezioneButton.setMnemonic(67);
            intersezioneButton.setActionCommand(this.intersezione);
            JRadioButton differenzaButton = new JRadioButton(this.differenza);
            differenzaButton.setMnemonic(68);
            differenzaButton.setActionCommand(this.differenza);
            if (defaultValue.equals(this.unione)) {
                unioneButton.setSelected(true);
                this.operator = this.unione;
            } else if (defaultValue.equals(this.intersezione)) {
                intersezioneButton.setSelected(true);
                this.operator = this.intersezione;
            } else if (defaultValue.equals(this.differenza)) {
                differenzaButton.setSelected(true);
                this.operator = this.differenza;
            } else {
                unioneButton.setSelected(true);
            }
            ButtonGroup group = new ButtonGroup();
            group.add(unioneButton);
            group.add(intersezioneButton);
            group.add(differenzaButton);
            unioneButton.addActionListener(this);
            intersezioneButton.addActionListener(this);
            differenzaButton.addActionListener(this);
            JPanel radioPanel = new JPanel();
            radioPanel.setLayout(new FlowLayout(0));
            radioPanel.add(unioneButton);
            radioPanel.add(intersezioneButton);
            radioPanel.add(differenzaButton);
            this.setLayout(new BorderLayout());
            this.add((Component)radioPanel, "East");
        }

        public void actionPerformed(ActionEvent e) {
            this.operator = e.getActionCommand();
            System.out.println(this.operator);
        }

        public String getOperator() {
            return this.operator;
        }
    }
}

