/*
 * Decompiled with CFR 0.152.
 */
package visualra.GUIControl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import visualra.GUIControl.GUI;
import visualra.GUIControl.OpNode;
import visualra.Language;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableField;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAQuery;
import visualra.ra2sql.RASelection;

public class SelectionOperatorDialog
extends JDialog
implements ActionListener {
    private static final boolean EDIT_MODE = true;
    private static final boolean INSERT_MODE = false;
    private static final boolean UP_DIRECTION = true;
    private static final boolean DOWN_DIRECTION = false;
    private LinkedList boxList = new LinkedList();
    private GridLayout griglia = new GridLayout(0, 1, 0, 0);
    private JDialog opDialog;
    private JPanel panRows = new JPanel(new BorderLayout());
    private JPanel panComandi;
    private JButton conferma;
    private JButton esci;
    private JPanel panTabField = new JPanel(new FlowLayout(1));
    private JPanel panTab = new JPanel(new FlowLayout(1));
    private JPanel panField = new JPanel(new BorderLayout());
    TreeSet ts;
    String[] tabelle;
    Riga riga;
    Set fieldsName = new LinkedHashSet();
    OpNode newNode;
    OpNode clickedNode;
    String nomeTab = "";
    private boolean isEditing;
    private boolean editDirection;
    private boolean treeValid;
    JPanel nome = new JPanel(new FlowLayout(0));
    JLabel titoloTabella;
    Language l = Language.getInstance();
    GUI gui;

    public SelectionOperatorDialog(OpNode clickedNode, OpNode newNode, boolean isEditing, boolean editDirection, boolean treeValid, GUI g) {
        this.gui = g;
        this.newNode = newNode;
        this.clickedNode = clickedNode;
        this.isEditing = isEditing;
        this.editDirection = editDirection;
        this.treeValid = treeValid;
        this.opDialog = this;
        this.opDialog.setTitle(this.l.getString("Selezione"));
        this.opDialog.getContentPane().setLayout(new BorderLayout());
        JMenu help = new JMenu();
        JMenuItem helpTopics = new JMenuItem("", 71);
        helpTopics.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpTopics.addActionListener(this);
        help.add(helpTopics);
        help.setVisible(false);
        JMenuBar bar = new JMenuBar();
        bar.add(help);
        this.opDialog.setJMenuBar(bar);
        Font titolo = new Font(null, 0, 18);
        JLabel intestazione = new JLabel("<html><b><font color=blue>" + this.l.getString("Selezione") + "</font></b>");
        intestazione.setFont(titolo);
        JPanel panTitle = new JPanel(new FlowLayout(1));
        panTitle.add(intestazione);
        this.opDialog.getContentPane().add((Component)panTitle, "North");
        if ((clickedNode.getChildCount() != 2 && clickedNode.getOp().getArgSize() == 2 || clickedNode.getChildCount() != 1 && clickedNode.getOp().getArgSize() == 1) && !editDirection) {
            String[] tabList = this.creaListaTabelle();
            JComboBox<String> tabCombo = new JComboBox<String>(tabList);
            if (isEditing) {
                String[] tabsInOp = clickedNode.getOp().getTables();
                this.nomeTab = tabsInOp[0];
            } else {
                this.nomeTab = tabCombo.getItemAt(0);
            }
            tabCombo.setSelectedItem(this.nomeTab);
            tabCombo.addActionListener(new AscoltaTabs());
            JPanel contieneTabelle = new JPanel(new GridLayout(2, 1));
            JLabel labelTabelle = new JLabel("<html><b><font color=blue>" + Language.getInstance().getString("Lista_Tabelle") + "</font></b>");
            contieneTabelle.add(labelTabelle);
            contieneTabelle.add(tabCombo);
            this.panTab.add(contieneTabelle);
            this.panTabField.add(this.panTab);
            this.opDialog.getContentPane().add((Component)this.panTabField, "Center");
            try {
                TableSchema tsc = DBManager.getTableFields(this.nomeTab);
                this.creaListaCampi(tsc);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    this.gui.semaforo.setRosso();
                }
                this.gui.dialogWindow.append(dbmex.getMessage());
            }
        } else {
            try {
                this.gui.semaforo.setVerde();
                TableSchema tsc = isEditing ? RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(0)) : RAQuery.getSchemaFromNode(this.clickedNode);
                this.creaListaCampi(tsc);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    this.gui.semaforo.setRosso();
                }
                this.gui.dialogWindow.append(dbmex.getMessage());
            }
            catch (RAException raex) {
                this.gui.semaforo.setRosso();
                this.gui.dialogWindow.append(raex.getMessage());
            }
        }
        this.panRows.setLayout(this.griglia);
        if (isEditing) {
            String[] condizioneRiga;
            String[] stringCampi = ((RASelection)clickedNode.getOp()).getConditions();
            if (stringCampi.length == 0) {
                condizioneRiga = new String[]{"", "", "", ""};
                this.riga = new Riga(this.nomeTab, condizioneRiga);
                this.panRows.add((Component)this.riga, "Center");
                this.boxList.addLast(this.riga);
            } else if (stringCampi.length > 3) {
                condizioneRiga = new String[4];
                int i = 0;
                while (i < 4) {
                    condizioneRiga[i] = stringCampi[i];
                    ++i;
                }
                this.riga = new Riga(this.nomeTab, condizioneRiga);
                this.panRows.add((Component)this.riga, "Center");
                this.boxList.addLast(this.riga);
                this.riga.aggiungi.setEnabled(true);
                if (condizioneRiga[3] != "") {
                    i = 4;
                    while (i < stringCampi.length - 3) {
                        condizioneRiga = new String[4];
                        int j = 0;
                        while (j < 4) {
                            condizioneRiga[j] = stringCampi[i + j];
                            ++j;
                        }
                        this.riga = new Riga(this.nomeTab, condizioneRiga);
                        this.panRows.add((Component)this.riga, "Center");
                        this.boxList.addLast(this.riga);
                        i += 4;
                    }
                    condizioneRiga = new String[]{stringCampi[stringCampi.length - 3], stringCampi[stringCampi.length - 2], stringCampi[stringCampi.length - 1], ""};
                    this.riga = new Riga(this.nomeTab, condizioneRiga);
                    this.panRows.add((Component)this.riga, "Center");
                    this.boxList.addLast(this.riga);
                    this.riga.aggiungi.setEnabled(true);
                }
            } else {
                condizioneRiga = new String[4];
                int i = 0;
                while (i < 3) {
                    condizioneRiga[i] = stringCampi[i];
                    ++i;
                }
                condizioneRiga[3] = "";
                this.riga = new Riga(this.nomeTab, condizioneRiga);
                this.panRows.add((Component)this.riga, "Center");
                this.boxList.addLast(this.riga);
                this.riga.aggiungi.setEnabled(true);
            }
        } else {
            String[] vuoto = new String[]{"", "", "", ""};
            this.riga = !editDirection ? new Riga(this.nomeTab, vuoto) : new Riga("", vuoto);
            this.panRows.add((Component)this.riga, "Center");
            this.boxList.addLast(this.riga);
            this.riga.aggiungi.setEnabled(true);
        }
        this.panComandi = new JPanel(new FlowLayout(1));
        this.conferma = new JButton(this.l.getString("Conferma"));
        this.conferma.addActionListener(new AscoltaConferma());
        this.panComandi.add(this.conferma);
        this.esci = new JButton(this.l.getString("Annulla"));
        this.esci.addActionListener(new AscoltaEsci());
        this.panComandi.add(this.esci);
        this.panRows.add((Component)this.panComandi, "South");
        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.l.getString("Condizioni"), 0, 0, new Font(null, 2, 16));
        title.setTitleColor(Color.blue);
        this.panRows.setBorder(title);
        this.opDialog.getContentPane().add((Component)this.panRows, "South");
        this.opDialog.addWindowListener(new AscoltaExit());
        ((Component)this.opDialog).setLocation(200, 200);
        this.opDialog.setResizable(false);
        this.opDialog.setModal(true);
        this.opDialog.pack();
        this.centra();
        ((Component)this.opDialog).setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.gui.showHelp(null, this, "help13.html");
    }

    private void centra() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.opDialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this.opDialog).setSize(frameSize);
        ((Component)this.opDialog).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public String[] creaListaTabelle() {
        try {
            this.ts = DBManager.getTables();
            this.tabelle = new String[this.ts.size()];
            this.ts.toArray(this.tabelle);
        }
        catch (DBManagerException dbmex) {
            if (dbmex.isRACaused()) {
                this.gui.semaforo.setRosso();
            }
            this.gui.dialogWindow.append(dbmex.getMessage());
        }
        return this.tabelle;
    }

    public Set creaListaCampi(TableSchema ts) {
        Font titolo = new Font(null, 0, 13);
        JPanel campi = new JPanel(new GridLayout(0, 1));
        this.nome.removeAll();
        this.panField.removeAll();
        this.fieldsName.clear();
        Set set = ts.getFieldNames();
        Set setField = ts.getFields();
        Iterator it = set.iterator();
        Iterator itf = setField.iterator();
        if (!this.nomeTab.equals("")) {
            this.panField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
            this.titoloTabella = new JLabel("<html><font size=4 color=blue>" + this.l.getString("Campi_di") + " " + this.nomeTab + "</font>");
        } else {
            this.panField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
            this.titoloTabella = new JLabel("<html><font size=4 color=blue>" + this.l.getString("Campi_Disponibili") + "</font>");
        }
        this.nome.add(this.titoloTabella);
        campi.add(this.nome);
        while (it.hasNext()) {
            String nome = (String)it.next();
            String tipo = ((TableField)itf.next()).getTypeAsITString();
            JLabel nomeCampo = new JLabel("<html><font face=\"Courier New\" size=3><b>" + nome + "</b> : <i>" + tipo + "</font></i>");
            campi.add(nomeCampo);
            this.panField.add(campi);
            this.fieldsName.add(nome);
            this.panTabField.add(this.panField);
            this.opDialog.getContentPane().add((Component)this.panTabField, "Center");
        }
        return this.fieldsName;
    }

    private class AscoltaTabs
    implements ActionListener {
        AscoltaTabs() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            SelectionOperatorDialog.this.nomeTab = (String)cb.getSelectedItem();
            try {
                TableSchema ts = DBManager.getTableFields(SelectionOperatorDialog.this.nomeTab);
                SelectionOperatorDialog.this.creaListaCampi(ts);
                SelectionOperatorDialog.this.panRows.removeAll();
                SelectionOperatorDialog.this.boxList.clear();
                String[] vuoto = new String[]{"", "", "", ""};
                SelectionOperatorDialog.this.riga = new Riga(SelectionOperatorDialog.this.nomeTab, vuoto);
                SelectionOperatorDialog.this.panRows.add((Component)SelectionOperatorDialog.this.riga, "Center");
                SelectionOperatorDialog.this.panRows.add((Component)SelectionOperatorDialog.this.panComandi, "South");
                SelectionOperatorDialog.this.opDialog.getContentPane().add((Component)SelectionOperatorDialog.this.panRows, "South");
                SelectionOperatorDialog.this.boxList.addLast(SelectionOperatorDialog.this.riga);
                TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), SelectionOperatorDialog.this.l.getString("Condizioni"), 0, 0, new Font(null, 2, 16));
                title.setTitleColor(Color.blue);
                SelectionOperatorDialog.this.panRows.setBorder(title);
                SelectionOperatorDialog.this.opDialog.getContentPane().add((Component)SelectionOperatorDialog.this.panRows, "South");
                SelectionOperatorDialog.this.opDialog.pack();
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    SelectionOperatorDialog.this.gui.semaforo.setRosso();
                }
                SelectionOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
        }
    }

    private class AscoltaEsci
    implements ActionListener {
        AscoltaEsci() {
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = new JFrame();
            int n = JOptionPane.showConfirmDialog(frame, SelectionOperatorDialog.this.l.getString("Vuoi_annullare_davvero_l'operazione?"), SelectionOperatorDialog.this.l.getString("Esci_da_Selezione..."), 2);
            if (n == 0) {
                if (SelectionOperatorDialog.this.isEditing) {
                    if (SelectionOperatorDialog.this.treeValid) {
                        SelectionOperatorDialog.this.newNode.updateOp("<html>" + SelectionOperatorDialog.this.clickedNode.getOp().toString(), SelectionOperatorDialog.this.clickedNode.getOp());
                    } else {
                        SelectionOperatorDialog.this.newNode.updateOp(null, null);
                    }
                } else {
                    SelectionOperatorDialog.this.newNode.updateOp(null, null);
                }
                SelectionOperatorDialog.this.opDialog.dispose();
            }
        }
    }

    private class AscoltaExit
    extends WindowAdapter {
        AscoltaExit() {
        }

        public void windowClosing(WindowEvent e) {
            if (SelectionOperatorDialog.this.isEditing) {
                if (SelectionOperatorDialog.this.treeValid) {
                    SelectionOperatorDialog.this.newNode.updateOp("<html>" + SelectionOperatorDialog.this.clickedNode.getOp().toString(), SelectionOperatorDialog.this.clickedNode.getOp());
                } else {
                    SelectionOperatorDialog.this.newNode.updateOp(null, null);
                }
            } else {
                SelectionOperatorDialog.this.newNode.updateOp(null, null);
            }
            SelectionOperatorDialog.this.opDialog.dispose();
        }
    }

    private class AscoltaConferma
    implements ActionListener {
        AscoltaConferma() {
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = new JFrame();
            int n = JOptionPane.showConfirmDialog(frame, SelectionOperatorDialog.this.l.getString("Confermare_i_dati_selezionati?"), SelectionOperatorDialog.this.l.getString("Conferma_dati_immessi..."), 2);
            if (n == 0) {
                int i = 0;
                while (i < SelectionOperatorDialog.this.boxList.size()) {
                    Riga riga = (Riga)SelectionOperatorDialog.this.boxList.get(i);
                    if (riga.fields.opCombo.getItemCount() == 0 || riga.val.getText().equals("")) {
                        JOptionPane.showMessageDialog(null, SelectionOperatorDialog.this.l.getString("Occorre_riempire_tutti_i_campi_condizione_prima_di_procedere"), SelectionOperatorDialog.this.l.getString("Errore..."), 2);
                        return;
                    }
                    ++i;
                }
                Vector<String> condizioni = new Vector<String>();
                String opLogico = "";
                Riga riga = (Riga)SelectionOperatorDialog.this.boxList.get(0);
                if (riga.check.isSelected()) {
                    condizioni.add("(NOT " + riga.fields.getValue());
                    condizioni.add(riga.campi.getValue());
                    condizioni.add(String.valueOf(riga.val.getText()) + ")");
                    opLogico = riga.opLogici.getOperator();
                } else {
                    condizioni.add(riga.fields.getValue());
                    condizioni.add(riga.campi.getValue());
                    condizioni.add(riga.val.getText());
                    opLogico = riga.opLogici.getOperator();
                }
                if (SelectionOperatorDialog.this.boxList.size() > 1) {
                    int i2 = 1;
                    while (i2 < SelectionOperatorDialog.this.boxList.size() - 1) {
                        condizioni.add(opLogico);
                        riga = (Riga)SelectionOperatorDialog.this.boxList.get(i2);
                        if (riga.check.isSelected()) {
                            condizioni.add("(NOT " + riga.fields.getValue());
                            condizioni.add(riga.campi.getValue());
                            condizioni.add(String.valueOf(riga.val.getText()) + ")");
                            opLogico = riga.opLogici.getOperator();
                        } else {
                            condizioni.add(riga.fields.getValue());
                            condizioni.add(riga.campi.getValue());
                            condizioni.add(riga.val.getText());
                            opLogico = riga.opLogici.getOperator();
                        }
                        ++i2;
                    }
                    condizioni.add(opLogico);
                    riga = (Riga)SelectionOperatorDialog.this.boxList.get(SelectionOperatorDialog.this.boxList.size() - 1);
                    if (riga.check.isSelected()) {
                        condizioni.add("(NOT " + riga.fields.getValue());
                        condizioni.add(riga.campi.getValue());
                        condizioni.add(String.valueOf(riga.val.getText()) + ")");
                        opLogico = riga.opLogici.getOperator();
                    } else {
                        condizioni.add(riga.fields.getValue());
                        condizioni.add(riga.campi.getValue());
                        condizioni.add(riga.val.getText());
                    }
                }
                String[] conditions = new String[condizioni.size()];
                int i3 = 0;
                while (i3 < condizioni.size()) {
                    conditions[i3] = (String)condizioni.elementAt(i3);
                    ++i3;
                }
                RASelection op = SelectionOperatorDialog.this.isEditing ? (SelectionOperatorDialog.this.clickedNode.getOp().isLastOp() ? new RASelection(conditions, SelectionOperatorDialog.this.nomeTab) : new RASelection(conditions, null)) : (!SelectionOperatorDialog.this.editDirection ? new RASelection(conditions, SelectionOperatorDialog.this.nomeTab) : new RASelection(conditions, null));
                SelectionOperatorDialog.this.newNode.updateOp("<html>" + op.toString(), op);
                SelectionOperatorDialog.this.opDialog.dispose();
            }
        }
    }

    public class Riga
    extends JPanel {
        JCheckBox check;
        JTextField val;
        RadioButton opLogici;
        JButton aggiungi;
        JButton remove;
        JPanel riga;
        String campo;
        String operatore;
        String valore;
        String funLogica;
        CheckCombo fields;
        CheckCombo campi;

        public Riga(String nomeTab, String[] condizione) {
            this.campo = condizione[0];
            this.operatore = condizione[1];
            this.valore = condizione[2];
            this.funLogica = condizione[3];
            this.riga = this;
            this.setLayout(new FlowLayout(0));
            this.check = new JCheckBox("<html><b><font color=blue size=2> NOT </font></b>");
            if (!this.campo.equals("")) {
                if (this.campo.charAt(0) == '(') {
                    this.check.setSelected(true);
                }
            } else {
                this.check.setSelected(false);
            }
            this.add(this.check);
            if (nomeTab.equals("")) {
                this.fields = this.check.isSelected() ? new CheckCombo(SelectionOperatorDialog.this.fieldsName, this.campo.substring(5)) : new CheckCombo(SelectionOperatorDialog.this.fieldsName, this.campo);
                this.add(this.fields);
            } else {
                try {
                    TableSchema ts = DBManager.getTableFields(nomeTab);
                    Set listaCampi = SelectionOperatorDialog.this.creaListaCampi(ts);
                    this.fields = this.check.isSelected() ? new CheckCombo(listaCampi, this.campo.substring(5)) : new CheckCombo(listaCampi, this.campo);
                    this.add(this.fields);
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        SelectionOperatorDialog.this.gui.semaforo.setRosso();
                    }
                    SelectionOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
                }
            }
            LinkedHashSet<String> opConfronto = new LinkedHashSet<String>(6);
            opConfronto.add("=");
            opConfronto.add("<>");
            opConfronto.add(">");
            opConfronto.add("<");
            opConfronto.add(">=");
            opConfronto.add("<=");
            this.campi = !this.operatore.equals("") ? new CheckCombo(opConfronto, this.operatore) : new CheckCombo(opConfronto, "=");
            this.add(this.campi);
            if (!this.valore.equals("")) {
                if (this.valore.charAt(this.valore.length() - 1) == ')') {
                    int numeroCaratteri = this.valore.length();
                    this.val = new JTextField(this.valore.substring(0, numeroCaratteri - 1), 10);
                } else {
                    this.val = new JTextField(this.valore, 10);
                }
            } else {
                this.val = new JTextField(10);
            }
            this.val.setSize(10, 3);
            this.val.getDocument().addDocumentListener(new AscoltaTextField());
            this.add(this.val);
            this.opLogici = new RadioButton(this.funLogica);
            this.add(this.opLogici);
            if (this.funLogica.equals("")) {
                this.opLogici.setVisible(false);
            } else {
                this.opLogici.setVisible(true);
            }
            this.aggiungi = new JButton(SelectionOperatorDialog.this.l.getString("Aggiungi"));
            this.aggiungi.addActionListener(new AscoltaAggiungi());
            this.add(this.aggiungi);
            this.aggiungi.setToolTipText(SelectionOperatorDialog.this.l.getString("Specificare_una_condizione_prima_di_aggiungerne_una_nuova"));
            JButton rimuovi = new JButton(SelectionOperatorDialog.this.l.getString("Rimuovi"));
            rimuovi.setToolTipText(SelectionOperatorDialog.this.l.getString("Elimina_una_condizione_inserita"));
            rimuovi.addActionListener(new AscoltaRemove());
            this.add(rimuovi);
        }

        private class AscoltaRemove
        implements ActionListener {
            AscoltaRemove() {
            }

            public void actionPerformed(ActionEvent e) {
                if (SelectionOperatorDialog.this.boxList.size() > 1) {
                    SelectionOperatorDialog.this.panRows.remove(Riga.this.riga);
                    SelectionOperatorDialog.this.boxList.remove(Riga.this.riga);
                    Riga riga = (Riga)SelectionOperatorDialog.this.boxList.getLast();
                    riga.opLogici.setVisible(false);
                    riga.aggiungi.setEnabled(true);
                    riga.aggiungi.setToolTipText(((Riga)Riga.this).SelectionOperatorDialog.this.l.getString("Specificare_una_condizione_prima_di_aggiungerne_una_nuova"));
                    SelectionOperatorDialog.this.opDialog.pack();
                } else {
                    JOptionPane.showMessageDialog(null, ((Riga)Riga.this).SelectionOperatorDialog.this.l.getString("Non_puoi_rimuovere_il_componente"), ((Riga)Riga.this).SelectionOperatorDialog.this.l.getString("Errore..."), 0);
                }
            }
        }

        private class AscoltaAggiungi
        implements ActionListener {
            AscoltaAggiungi() {
            }

            public void actionPerformed(ActionEvent e) {
                Riga.this.opLogici.setVisible(true);
                Riga.this.opLogici.setToolTipText(((Riga)Riga.this).SelectionOperatorDialog.this.l.getString("Selezionare_un_operatore_logico"));
                Riga.this.aggiungi.setEnabled(false);
                Riga.this.aggiungi.setToolTipText(((Riga)Riga.this).SelectionOperatorDialog.this.l.getString("Specificare_una_condizione_prima_di_aggiungerne_una_nuova"));
                SelectionOperatorDialog.this.conferma.setToolTipText(((Riga)Riga.this).SelectionOperatorDialog.this.l.getString("Per_confermare_occorre_riempire_i_campi"));
                String[] vuoto = new String[]{"", "", "", ""};
                Riga riga = new Riga("", vuoto);
                SelectionOperatorDialog.this.panRows.add((Component)riga, "Center");
                SelectionOperatorDialog.this.panRows.add((Component)SelectionOperatorDialog.this.panComandi, "South");
                SelectionOperatorDialog.this.opDialog.getContentPane().add((Component)SelectionOperatorDialog.this.panRows, "South");
                SelectionOperatorDialog.this.boxList.addLast(riga);
                SelectionOperatorDialog.this.opDialog.pack();
            }
        }

        private class AscoltaTextField
        implements DocumentListener {
            AscoltaTextField() {
            }

            public void changedUpdate(DocumentEvent e) {
            }

            public void removeUpdate(DocumentEvent e) {
                if (Riga.this.val.getText().equals("") || Riga.this.fields.getValue().equals("")) {
                    SelectionOperatorDialog.this.conferma.setEnabled(false);
                    SelectionOperatorDialog.this.conferma.setToolTipText(((Riga)Riga.this).SelectionOperatorDialog.this.l.getString("Per_confermare_occorre_riempire_i_campi"));
                    Riga.this.aggiungi.setEnabled(false);
                    Riga.this.aggiungi.setToolTipText(((Riga)Riga.this).SelectionOperatorDialog.this.l.getString("Specificare_una_condizione_prima_di_aggiungerne_una_nuova"));
                }
            }

            public void insertUpdate(DocumentEvent e) {
                SelectionOperatorDialog.this.conferma.setEnabled(true);
                SelectionOperatorDialog.this.conferma.setToolTipText(((Riga)Riga.this).SelectionOperatorDialog.this.l.getString("Conferma_dati_immessi..."));
                Riga.this.aggiungi.setEnabled(true);
                Riga.this.aggiungi.setToolTipText(((Riga)Riga.this).SelectionOperatorDialog.this.l.getString("Aggiungi_una_nuova_condizione"));
            }
        }
    }

    public class CheckCombo
    extends JPanel {
        String campo;
        JComboBox opCombo;

        public CheckCombo(Set opzioni, String campoItem) {
            this.opCombo = new JComboBox<Object>(opzioni.toArray());
            this.opCombo.addActionListener(new AscoltaCombo());
            this.opCombo.setSelectedItem(campoItem);
            this.campo = (String)this.opCombo.getSelectedItem();
            this.add(this.opCombo);
        }

        public String getValue() {
            return this.campo;
        }

        private class AscoltaCombo
        implements ActionListener {
            AscoltaCombo() {
            }

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                CheckCombo.this.campo = (String)cb.getSelectedItem();
            }
        }
    }

    public class RadioButton
    extends JPanel
    implements ActionListener {
        String and = "AND";
        String or = "OR";
        String operator = "AND";

        public RadioButton(String defaultValue) {
            JRadioButton andButton = new JRadioButton(this.and);
            andButton.setMnemonic(66);
            andButton.setActionCommand(this.and);
            JRadioButton orButton = new JRadioButton(this.or);
            orButton.setMnemonic(67);
            orButton.setActionCommand(this.or);
            if (defaultValue.equals(this.and)) {
                andButton.setSelected(true);
                this.operator = "AND";
            } else if (defaultValue.equals(this.or)) {
                orButton.setSelected(true);
                this.operator = "OR";
            } else {
                andButton.setSelected(true);
            }
            ButtonGroup group = new ButtonGroup();
            group.add(andButton);
            group.add(orButton);
            andButton.addActionListener(this);
            orButton.addActionListener(this);
            JPanel radioPanel = new JPanel();
            radioPanel.setLayout(new FlowLayout(0));
            radioPanel.add(andButton);
            radioPanel.add(orButton);
            this.setLayout(new BorderLayout());
            this.add((Component)radioPanel, "East");
        }

        public void actionPerformed(ActionEvent e) {
            this.operator = e.getActionCommand();
        }

        public String getOperator() {
            return this.operator;
        }
    }
}

