/*
 * Decompiled with CFR 0.152.
 */
package visualra.GUIControl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visualra.GUIControl.GUI;
import visualra.Language;
import visualra.database.DBManager;
import visualra.database.DBManagerException;

public class SaveResultTableDialog
extends JDialog {
    JLabel titolo;
    JPanel pannelloTotal;
    JPanel pannelloTableName;
    JLabel labelTableName;
    JTextField casellaTableName;
    JPanel pannelloTasti;
    JButton crea;
    JButton annulla;
    ResultSet rs;
    GUI gui;
    JDialog window;

    public SaveResultTableDialog(GUI g, ResultSet resset) {
        this.gui = g;
        this.window = this;
        this.rs = resset;
        this.setTitle(Language.getInstance().getString("Creazione_tabella_risultato"));
        this.getContentPane().setLayout(new BorderLayout());
        this.pannelloTableName = new JPanel(new FlowLayout(0));
        this.labelTableName = new JLabel("<html><b><font color=blue size=2>" + Language.getInstance().getString("Nome_Tabella") + "</font></b>");
        this.casellaTableName = new JTextField(20);
        this.pannelloTableName.add(this.labelTableName);
        this.pannelloTableName.add(this.casellaTableName);
        this.pannelloTasti = new JPanel(new FlowLayout(1));
        this.crea = new JButton(Language.getInstance().getString("Crea"));
        this.crea.addActionListener(new AscoltaCrea());
        this.pannelloTasti.add(this.crea);
        this.annulla = new JButton(Language.getInstance().getString("Annulla"));
        this.annulla.addActionListener(new AscoltaAnnulla());
        this.pannelloTasti.add(this.annulla);
        this.addWindowListener(new AscoltaExit());
        this.getContentPane().add((Component)this.pannelloTableName, "North");
        this.getContentPane().add((Component)this.pannelloTasti, "Center");
        this.setModal(true);
        this.pack();
        this.centra();
        ((Component)this).setVisible(true);
    }

    private void centra() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setSize(frameSize);
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private class AscoltaAnnulla
    implements ActionListener {
        AscoltaAnnulla() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DBManager.closeRS(SaveResultTableDialog.this.rs);
                DBManager.deleteAllTempTables();
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    SaveResultTableDialog.this.gui.semaforo.setRosso();
                }
                SaveResultTableDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
            SaveResultTableDialog.this.window.dispose();
        }
    }

    private class AscoltaExit
    extends WindowAdapter {
        AscoltaExit() {
        }

        public void windowClosing(WindowEvent e) {
            try {
                DBManager.closeRS(SaveResultTableDialog.this.rs);
                DBManager.deleteAllTempTables();
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    SaveResultTableDialog.this.gui.semaforo.setRosso();
                }
                SaveResultTableDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
            SaveResultTableDialog.this.window.dispose();
        }
    }

    private class AscoltaCrea
    implements ActionListener {
        AscoltaCrea() {
        }

        public void actionPerformed(ActionEvent e) {
            String tabName = SaveResultTableDialog.this.casellaTableName.getText();
            boolean trovatoErrore = false;
            char[] caratteriVietati = new char[]{'@', '#', '-', '<', '>', '.', '/', '\\', ',', ';', '\'', '&', '%', '$', '\"', '!', '|'};
            int i = 0;
            while (i < caratteriVietati.length) {
                String carattere = String.valueOf(caratteriVietati[i]);
                if (tabName.indexOf(carattere, 0) != -1 || tabName.equals("")) {
                    JOptionPane.showMessageDialog(SaveResultTableDialog.this.window, String.valueOf(Language.getInstance().getString("Il_nome_della_tabella_inserito_\u00e8_vuoto_o_non_\u00e8_valido")) + Language.getInstance().getString("I_seguenti_caratteri_non_sono_ammessi") + "@  #  -  .  /  \\  ;  | <  >  !  &  %  $  \u00a3  (  )  ?  [  ]  ^  \u00a7  \u00b0", Language.getInstance().getString("Errore_inserimento_dati"), 2);
                    trovatoErrore = true;
                    break;
                }
                ++i;
            }
            if (!trovatoErrore) {
                try {
                    DBManager.createTable(SaveResultTableDialog.this.rs, tabName);
                    SaveResultTableDialog.this.gui.tabellaDB.addTab(tabName, null);
                    DBManager.closeRS(SaveResultTableDialog.this.rs);
                    DBManager.removeFromTempTables(tabName);
                    DBManager.deleteAllTempTables();
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        SaveResultTableDialog.this.gui.semaforo.setRosso();
                    }
                    SaveResultTableDialog.this.gui.dialogWindow.append(dbmex.getMessage());
                }
                SaveResultTableDialog.this.window.dispose();
            }
        }
    }
}

