/*
 * Decompiled with CFR 0.152.
 */
package visualra.GUIControl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import visualra.GUIControl.GUI;
import visualra.GUIControl.OpNode;
import visualra.Language;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAQuery;
import visualra.ra2sql.RARename;

public class RenameOperatorDialog
extends JDialog
implements ActionListener {
    private static final boolean EDIT_MODE = true;
    private static final boolean INSERT_MODE = false;
    private static final boolean UP_DIRECTION = true;
    private static final boolean DOWN_DIRECTION = false;
    private boolean isEditing;
    private boolean editDirection;
    private boolean treeValid;
    JDialog opDialog;
    String[] tabelle;
    Vector fieldsName = new Vector();
    LinkedList boxList = new LinkedList();
    JPanel panTabField = new JPanel(new FlowLayout(1));
    JPanel pulsanti = new JPanel(new FlowLayout(1));
    JPanel panRows = new JPanel(new GridLayout(0, 1, 0, -10));
    String nameFields;
    String[] tabList;
    Riga riga;
    JButton conferma;
    JButton annulla;
    OpNode newNode;
    OpNode clickedNode;
    String nomeTab = "";
    Vector listacampi = null;
    TableSchema ts = null;
    JPanel nome = new JPanel(new FlowLayout(0));
    JLabel titoloTabella;
    Language l = Language.getInstance();
    GUI gui;

    public RenameOperatorDialog(OpNode clickedNode, OpNode newNode, boolean isEditing, boolean editDirection, boolean treeValid, GUI g) {
        this.gui = g;
        this.newNode = newNode;
        this.clickedNode = clickedNode;
        this.isEditing = isEditing;
        this.editDirection = editDirection;
        this.treeValid = treeValid;
        this.opDialog = this;
        this.opDialog.setTitle(this.l.getString("Ridenominazione"));
        this.opDialog.getContentPane().setLayout(new BorderLayout());
        JMenu help = new JMenu();
        JMenuItem helpTopics = new JMenuItem("", 71);
        helpTopics.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpTopics.addActionListener(this);
        help.add(helpTopics);
        help.setVisible(false);
        JMenuBar bar = new JMenuBar();
        bar.add(help);
        this.opDialog.setJMenuBar(bar);
        Font title = new Font(null, 0, 18);
        JLabel intestazione = new JLabel("<html><b><font color=blue>" + this.l.getString("Ridenominazione") + "</font></b>");
        intestazione.setFont(title);
        JPanel panTitle = new JPanel(new FlowLayout(1));
        panTitle.add(intestazione);
        this.opDialog.getContentPane().add((Component)panTitle, "North");
        if ((clickedNode.getChildCount() != 2 && clickedNode.getOp().getArgSize() == 2 || clickedNode.getChildCount() != 1 && clickedNode.getOp().getArgSize() == 1) && !editDirection) {
            Font titolo = new Font(null, 0, 14);
            JPanel contieneTabelle = new JPanel(new GridLayout(2, 1));
            JLabel tabelle = new JLabel("<html><b><font color=blue>" + this.l.getString("Lista_Tabelle") + "</font></b>");
            contieneTabelle.add(tabelle);
            this.tabList = this.creaListaTabelle();
            JComboBox<String> tabCombo = new JComboBox<String>(this.tabList);
            if (isEditing) {
                String[] tabsInOp = clickedNode.getOp().getTables();
                this.nomeTab = tabsInOp[0];
            } else {
                this.nomeTab = tabCombo.getItemAt(0);
            }
            tabCombo.setSelectedItem(this.nomeTab);
            tabCombo.addActionListener(new AscoltaComboTab());
            contieneTabelle.add(tabCombo);
            this.panTabField.add(contieneTabelle);
            try {
                this.ts = DBManager.getTableFields(this.nomeTab);
                this.listacampi = this.creaListaCampi(this.ts);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    this.gui.semaforo.setRosso();
                }
                this.gui.dialogWindow.append(dbmex.getMessage());
            }
        } else {
            try {
                this.gui.semaforo.setVerde();
                this.ts = isEditing ? RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(0)) : RAQuery.getSchemaFromNode(this.clickedNode);
                this.listacampi = this.creaListaCampi(this.ts);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    this.gui.semaforo.setRosso();
                }
                this.gui.dialogWindow.append(dbmex.getMessage());
            }
            catch (RAException raex) {
                this.gui.semaforo.setRosso();
                this.gui.dialogWindow.append(raex.getMessage());
            }
        }
        if (isEditing) {
            String[] stringCampi = ((RARename)clickedNode.getOp()).getFields();
            int i = 0;
            while (i < this.listacampi.size()) {
                boolean trovato = false;
                int j = 0;
                while (j < stringCampi.length) {
                    if (stringCampi[j + 1].equals(this.listacampi.get(i))) {
                        String nomeText = stringCampi[j];
                        String nomeCampo = stringCampi[j + 1];
                        this.riga = new Riga(nomeCampo, nomeText);
                        this.boxList.addLast(this.riga);
                        this.panRows.add(this.riga);
                        trovato = true;
                    }
                    j += 2;
                }
                if (!trovato) {
                    this.riga = new Riga((String)this.listacampi.get(i));
                    this.boxList.addLast(this.riga);
                    this.panRows.add(this.riga);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.listacampi.size()) {
                this.riga = new Riga((String)this.listacampi.get(i));
                this.boxList.addLast(this.riga);
                this.panRows.add(this.riga);
                ++i;
            }
        }
        this.panTabField.add(this.panRows);
        this.opDialog.getContentPane().add((Component)this.panTabField, "Center");
        this.conferma = new JButton(this.l.getString("Conferma"));
        this.conferma.addActionListener(new AscoltaConferma());
        this.pulsanti.add(this.conferma);
        this.annulla = new JButton(this.l.getString("Annulla"));
        this.annulla.addActionListener(new AscoltaAnnulla());
        this.pulsanti.add(this.annulla);
        this.opDialog.getContentPane().add((Component)this.pulsanti, "South");
        this.opDialog.addWindowListener(new AscoltaExit());
        this.opDialog.setResizable(false);
        this.opDialog.setModal(true);
        this.opDialog.pack();
        this.centra();
        ((Component)this.opDialog).setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.gui.showHelp(null, this, "help15.html");
    }

    public void titoloCampi() {
        if (!this.nomeTab.equals("")) {
            this.panRows.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
            this.titoloTabella = new JLabel("<html><font size=4 color=blue>" + this.l.getString("Campi_di") + " " + this.nomeTab + "</font>");
        } else {
            this.panRows.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
            this.titoloTabella = new JLabel("<html><font size=4 color=blue>" + this.l.getString("Campi_Disponibili") + "</font>");
        }
        this.nome.add(this.titoloTabella);
        this.panRows.add(this.nome);
    }

    private void centra() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.opDialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this.opDialog).setSize(frameSize);
        ((Component)this.opDialog).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public String[] creaListaTabelle() {
        try {
            TreeSet ts = DBManager.getTables();
            this.tabelle = new String[ts.size()];
            ts.toArray(this.tabelle);
        }
        catch (DBManagerException dbmex) {
            if (dbmex.isRACaused()) {
                this.gui.semaforo.setRosso();
            }
            this.gui.dialogWindow.append(dbmex.getMessage());
        }
        return this.tabelle;
    }

    public Vector creaListaCampi(TableSchema ts) {
        this.fieldsName.clear();
        Set set = ts.getFieldNames();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String nome = (String)it.next();
            this.fieldsName.addElement(nome);
        }
        this.titoloCampi();
        return this.fieldsName;
    }

    private class AscoltaComboTab
    implements ActionListener {
        AscoltaComboTab() {
        }

        public void actionPerformed(ActionEvent e) {
            RenameOperatorDialog.this.boxList.clear();
            RenameOperatorDialog.this.nome.removeAll();
            RenameOperatorDialog.this.panRows.removeAll();
            JComboBox cb = (JComboBox)e.getSource();
            RenameOperatorDialog.this.nomeTab = (String)cb.getSelectedItem();
            try {
                TableSchema ts = DBManager.getTableFields(RenameOperatorDialog.this.nomeTab);
                Vector listaCampi = RenameOperatorDialog.this.creaListaCampi(ts);
                int i = 0;
                while (i < listaCampi.size()) {
                    RenameOperatorDialog.this.nameFields = (String)listaCampi.get(i);
                    RenameOperatorDialog.this.riga = new Riga(RenameOperatorDialog.this.nameFields);
                    RenameOperatorDialog.this.boxList.addLast(RenameOperatorDialog.this.riga);
                    RenameOperatorDialog.this.panRows.add(RenameOperatorDialog.this.riga);
                    ++i;
                }
                RenameOperatorDialog.this.panTabField.add(RenameOperatorDialog.this.panRows);
                RenameOperatorDialog.this.opDialog.pack();
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    RenameOperatorDialog.this.gui.semaforo.setRosso();
                }
                RenameOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
        }
    }

    private class AscoltaConferma
    implements ActionListener {
        JFrame frame = new JFrame();

        AscoltaConferma() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void actionPerformed(ActionEvent e) {
            boolean vuoto = true;
            boolean trovatoClone = false;
            boolean trovatoOmonimo = false;
            int i = 0;
            while (i < RenameOperatorDialog.this.boxList.size()) {
                RenameOperatorDialog.this.riga = (Riga)RenameOperatorDialog.this.boxList.get(i);
                if (RenameOperatorDialog.this.riga.freccia.isVisible()) {
                    if (!RenameOperatorDialog.this.riga.nuovoNome.getText().equals("")) {
                        vuoto = false;
                    } else {
                        vuoto = true;
                        break;
                    }
                }
                ++i;
            }
            if (vuoto) {
                JOptionPane.showMessageDialog(this.frame, RenameOperatorDialog.this.l.getString("Per_rinominare_un_campo_occorre_digitare_un_nuovo_nome"), RenameOperatorDialog.this.l.getString("Errore_inserimento_dati"), 0);
                return;
            }
            LinkedList<String> newNameSelected = new LinkedList<String>();
            LinkedList<String> listaSelected = new LinkedList<String>();
            int i2 = 0;
            while (i2 < RenameOperatorDialog.this.boxList.size()) {
                RenameOperatorDialog.this.riga = (Riga)RenameOperatorDialog.this.boxList.get(i2);
                if (RenameOperatorDialog.this.riga.freccia.isVisible()) {
                    listaSelected.addLast(RenameOperatorDialog.this.riga.nuovoNome.getText());
                    newNameSelected.addLast(RenameOperatorDialog.this.riga.nuovoNome.getText());
                    listaSelected.addLast(RenameOperatorDialog.this.riga.campo.campoBox.getText());
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < newNameSelected.size()) {
                if (RenameOperatorDialog.this.listacampi.contains((String)newNameSelected.get(i3))) {
                    int r = 0;
                    while (r < RenameOperatorDialog.this.boxList.size()) {
                        RenameOperatorDialog.this.riga = (Riga)RenameOperatorDialog.this.boxList.get(r);
                        if (RenameOperatorDialog.this.riga.campo.campoBox.getText().equals((String)newNameSelected.get(i3))) {
                            if (!RenameOperatorDialog.this.riga.freccia.isVisible()) {
                                trovatoOmonimo = true;
                                break;
                            }
                            if (RenameOperatorDialog.this.riga.nuovoNome.getText().equals(RenameOperatorDialog.this.riga.campo.campoBox.getText())) {
                                trovatoOmonimo = true;
                                break;
                            }
                        }
                        ++r;
                    }
                }
                ++i3;
            }
            int k = 0;
            int numeroTrovatiUguali = 0;
            while (k < newNameSelected.size()) {
                numeroTrovatiUguali = 0;
                int j = 0;
                while (j < newNameSelected.size()) {
                    if (newNameSelected.get(k).equals(newNameSelected.get(j))) {
                        ++numeroTrovatiUguali;
                    }
                    if (numeroTrovatiUguali > 1) {
                        trovatoClone = true;
                        break;
                    }
                    ++j;
                }
                ++k;
                if (numeroTrovatiUguali > 1) break;
            }
            if (trovatoOmonimo) {
                this.showErrorParametres();
                newNameSelected.clear();
                listaSelected.clear();
                return;
            }
            if (trovatoClone) {
                this.showErrorCloneParametres();
                newNameSelected.clear();
                listaSelected.clear();
                return;
            }
            int n = JOptionPane.showConfirmDialog(this.frame, RenameOperatorDialog.this.l.getString("Confermare_i_dati_selezionati?"), RenameOperatorDialog.this.l.getString("Conferma_dati_immessi..."), 2);
            if (n != 0) return;
            LinkedList arrayCampi = new LinkedList();
            int i4 = 0;
            while (i4 < listaSelected.size()) {
                arrayCampi.add(listaSelected.get(i4));
                arrayCampi.add(listaSelected.get(++i4));
                ++i4;
            }
            String[] ciccio = new String[arrayCampi.size()];
            int i5 = 0;
            while (i5 < arrayCampi.size()) {
                ciccio[i5] = (String)arrayCampi.get(i5);
                ++i5;
            }
            RARename op = RenameOperatorDialog.this.isEditing ? (RenameOperatorDialog.this.clickedNode.getOp().isLastOp() ? new RARename(ciccio, RenameOperatorDialog.this.nomeTab) : new RARename(ciccio, null)) : (!RenameOperatorDialog.this.editDirection ? new RARename(ciccio, RenameOperatorDialog.this.nomeTab) : new RARename(ciccio, null));
            RenameOperatorDialog.this.newNode.updateOp("<html>" + op.toString(), op);
            RenameOperatorDialog.this.opDialog.dispose();
        }

        public void showErrorParametres() {
            JOptionPane.showMessageDialog(this.frame, RenameOperatorDialog.this.l.getString("Uno_dei_nuovi_nomi_inseriti_\u00e8_gi\u00e0_presente_nella_lista_dei_campi_disponibili"), RenameOperatorDialog.this.l.getString("Errore_inserimento_dati"), 0);
        }

        public void showErrorCloneParametres() {
            JOptionPane.showMessageDialog(this.frame, RenameOperatorDialog.this.l.getString("Non_\u00e8_possibile_rinominare_due_campi_assegnando_loro_uno_stesso_nome"), RenameOperatorDialog.this.l.getString("Errore_inserimento_dati"), 0);
        }
    }

    private class AscoltaAnnulla
    implements ActionListener {
        AscoltaAnnulla() {
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = new JFrame();
            int n = JOptionPane.showConfirmDialog(frame, RenameOperatorDialog.this.l.getString("Vuoi_annullare_davvero_l'operazione?"), RenameOperatorDialog.this.l.getString("Esci_da_Ridenominazione"), 2);
            if (n == 0) {
                if (RenameOperatorDialog.this.isEditing) {
                    if (RenameOperatorDialog.this.treeValid) {
                        RenameOperatorDialog.this.newNode.updateOp("<html>" + RenameOperatorDialog.this.clickedNode.getOp().toString(), RenameOperatorDialog.this.clickedNode.getOp());
                    } else {
                        RenameOperatorDialog.this.newNode.updateOp(null, null);
                    }
                } else {
                    RenameOperatorDialog.this.newNode.updateOp(null, null);
                }
                RenameOperatorDialog.this.opDialog.dispose();
            }
        }
    }

    private class AscoltaExit
    extends WindowAdapter {
        AscoltaExit() {
        }

        public void windowClosing(WindowEvent e) {
            if (RenameOperatorDialog.this.isEditing) {
                if (RenameOperatorDialog.this.treeValid) {
                    RenameOperatorDialog.this.newNode.updateOp("<html>" + RenameOperatorDialog.this.clickedNode.getOp().toString(), RenameOperatorDialog.this.clickedNode.getOp());
                } else {
                    RenameOperatorDialog.this.newNode.updateOp(null, null);
                }
            } else {
                RenameOperatorDialog.this.newNode.updateOp(null, null);
            }
            RenameOperatorDialog.this.opDialog.dispose();
        }
    }

    public class Riga
    extends JPanel {
        CheckBox campo;
        JLabel freccia;
        JTextField nuovoNome;

        public Riga(String nomeCampo) {
            this.setLayout(new FlowLayout(0));
            this.campo = new CheckBox(nomeCampo);
            this.add(this.campo);
            this.freccia = new JLabel("--->");
            this.freccia.setVisible(false);
            this.add(this.freccia);
            this.nuovoNome = new JTextField(10);
            this.nuovoNome.setVisible(false);
            this.add(this.nuovoNome);
        }

        public Riga(String nomeCampo, String nomeText) {
            this.setLayout(new FlowLayout(0));
            this.campo = new CheckBox(nomeCampo);
            this.campo.campoBox.setSelected(true);
            this.add(this.campo);
            this.freccia = new JLabel("--->");
            this.freccia.setVisible(true);
            this.add(this.freccia);
            this.nuovoNome = new JTextField(nomeText, 10);
            this.nuovoNome.setVisible(true);
            this.add(this.nuovoNome);
        }
    }

    public class CheckBox
    extends JPanel
    implements ItemListener {
        JCheckBox campoBox;

        public CheckBox(String nomeCampo) {
            this.campoBox = new JCheckBox(nomeCampo);
            this.campoBox.setMnemonic(67);
            this.campoBox.setSelected(false);
            this.campoBox.addItemListener(this);
            this.add(this.campoBox);
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                int i = 0;
                while (i < RenameOperatorDialog.this.boxList.size()) {
                    Riga riga = (Riga)RenameOperatorDialog.this.boxList.get(i);
                    if (riga.campo.campoBox == (JCheckBox)e.getItem()) {
                        riga.freccia.setVisible(true);
                        riga.nuovoNome.setVisible(true);
                    }
                    ++i;
                }
                RenameOperatorDialog.this.opDialog.pack();
            } else if (e.getStateChange() == 2) {
                int i = 0;
                while (i < RenameOperatorDialog.this.boxList.size()) {
                    Riga riga = (Riga)RenameOperatorDialog.this.boxList.get(i);
                    if (riga.campo.campoBox == (JCheckBox)e.getItem()) {
                        riga.freccia.setVisible(false);
                        riga.nuovoNome.setText("");
                        riga.nuovoNome.setVisible(false);
                    }
                    ++i;
                }
                RenameOperatorDialog.this.opDialog.pack();
            }
        }
    }
}

