/*
 * Decompiled with CFR 0.152.
 */
package visualra.GUIControl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import visualra.GUIControl.GUI;
import visualra.GUIControl.OpNode;
import visualra.Language;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAProjection;
import visualra.ra2sql.RAQuery;

public class ProjectionOperatorDialog
extends JDialog
implements ActionListener {
    private static final boolean EDIT_MODE = true;
    private static final boolean INSERT_MODE = false;
    private static final boolean UP_DIRECTION = true;
    private static final boolean DOWN_DIRECTION = false;
    private boolean isEditing;
    private boolean editDirection;
    private boolean treeValid;
    JDialog opDialog;
    JPanel panTabField = new JPanel(new FlowLayout(1));
    JPanel pulsanti = new JPanel(new FlowLayout(1));
    String[] tabelle;
    Vector fieldsName = new Vector();
    JButton conferma;
    JButton annulla;
    JPanel panCampi = new JPanel(new GridLayout(0, 1));
    String nomeTabella = "";
    Vector listaSelected = new Vector();
    String nameFields;
    Vector listacampi = null;
    TableSchema ts = null;
    OpNode newNode;
    OpNode clickedNode;
    JPanel nome = new JPanel(new FlowLayout(0));
    JLabel titoloTabella;
    Language l = Language.getInstance();
    GUI gui;

    public ProjectionOperatorDialog(OpNode clickedNode, OpNode newNode, boolean isEditing, boolean editDirection, boolean treeValid, GUI g) {
        CheckBox box;
        this.gui = g;
        this.newNode = newNode;
        this.clickedNode = clickedNode;
        this.isEditing = isEditing;
        this.editDirection = editDirection;
        this.treeValid = treeValid;
        this.opDialog = this;
        this.opDialog.setTitle(this.l.getString("Proiezione"));
        this.opDialog.getContentPane().setLayout(new BorderLayout());
        JMenu help = new JMenu();
        JMenuItem helpTopics = new JMenuItem("", 71);
        helpTopics.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpTopics.addActionListener(this);
        help.add(helpTopics);
        help.setVisible(false);
        JMenuBar bar = new JMenuBar();
        bar.add(help);
        this.opDialog.setJMenuBar(bar);
        Font title = new Font(null, 0, 18);
        JLabel intestazione = new JLabel("<html><b><font color=blue>" + this.l.getString("Proiezione") + "</font></b>");
        intestazione.setFont(title);
        JPanel panTitle = new JPanel(new FlowLayout(1));
        panTitle.add(intestazione);
        this.opDialog.getContentPane().add((Component)panTitle, "North");
        if ((clickedNode.getChildCount() != 2 && clickedNode.getOp().getArgSize() == 2 || clickedNode.getChildCount() != 1 && clickedNode.getOp().getArgSize() == 1) && !editDirection) {
            Font titolo = new Font(null, 0, 14);
            JPanel contieneTabelle = new JPanel(new GridLayout(2, 1));
            JLabel tabelle = new JLabel("<html><b><font color=blue>" + this.l.getString("Lista_Tabelle") + "</font></b>");
            contieneTabelle.add(tabelle);
            String[] tabList = this.creaListaTabelle();
            JComboBox<String> tabCombo = new JComboBox<String>(tabList);
            if (isEditing) {
                String[] tabsInOp = clickedNode.getOp().getTables();
                this.nomeTabella = tabsInOp[0];
            } else {
                this.nomeTabella = tabCombo.getItemAt(0);
            }
            tabCombo.setSelectedItem(this.nomeTabella);
            tabCombo.addActionListener(new AscoltaComboTab());
            contieneTabelle.add(tabCombo);
            this.panTabField.add(contieneTabelle);
            this.opDialog.getContentPane().add((Component)this.panTabField, "Center");
            try {
                this.ts = DBManager.getTableFields(this.nomeTabella);
                this.listacampi = this.creaListaCampi(this.ts);
                int i = 0;
                while (i < this.listacampi.size()) {
                    this.nameFields = (String)this.listacampi.get(i);
                    CheckBox box2 = new CheckBox(this.nameFields);
                    this.panCampi.add(box2);
                    this.panTabField.add(this.panCampi);
                    this.opDialog.getContentPane().add((Component)this.panTabField, "Center");
                    this.opDialog.pack();
                    ++i;
                }
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    this.gui.semaforo.setRosso();
                }
                this.gui.dialogWindow.append(dbmex.getMessage());
            }
        } else {
            try {
                this.gui.semaforo.setVerde();
                this.ts = isEditing ? RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(0)) : RAQuery.getSchemaFromNode(this.clickedNode);
                this.listacampi = this.creaListaCampi(this.ts);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    this.gui.semaforo.setRosso();
                }
                this.gui.dialogWindow.append(dbmex.getMessage());
            }
            catch (RAException raex) {
                this.gui.semaforo.setRosso();
                this.gui.dialogWindow.append(raex.getMessage());
            }
        }
        if (isEditing) {
            String[] stringCampi = ((RAProjection)clickedNode.getOp()).getFields();
            if (!stringCampi[0].equals("")) {
                this.nome.removeAll();
                this.panCampi.removeAll();
                this.titoloCampi();
                int i = 0;
                while (i < this.listacampi.size()) {
                    this.nameFields = (String)this.listacampi.get(i);
                    box = new CheckBox(this.nameFields);
                    this.panCampi.add(box);
                    int j = 0;
                    while (j < stringCampi.length) {
                        if (stringCampi[j].equals((String)this.fieldsName.get(i))) {
                            box.campo.setSelected(true);
                        }
                        ++j;
                    }
                    this.panTabField.add(this.panCampi);
                    this.opDialog.getContentPane().add((Component)this.panTabField, "Center");
                    this.opDialog.pack();
                    ++i;
                }
            }
        } else {
            this.nome.removeAll();
            this.panCampi.removeAll();
            this.titoloCampi();
            int i = 0;
            while (i < this.listacampi.size()) {
                this.nameFields = (String)this.listacampi.get(i);
                box = new CheckBox(this.nameFields);
                this.panCampi.add(box);
                this.panTabField.add(this.panCampi);
                this.opDialog.getContentPane().add((Component)this.panTabField, "Center");
                this.opDialog.pack();
                ++i;
            }
        }
        this.conferma = new JButton(this.l.getString("Conferma"));
        this.conferma.addActionListener(new AscoltaConferma());
        this.pulsanti.add(this.conferma);
        this.annulla = new JButton(this.l.getString("Annulla"));
        this.annulla.addActionListener(new AscoltaAnnulla());
        this.pulsanti.add(this.annulla);
        this.opDialog.getContentPane().add((Component)this.pulsanti, "South");
        this.opDialog.addWindowListener(new AscoltaExit());
        this.opDialog.setResizable(false);
        this.opDialog.setModal(true);
        this.centra();
        this.opDialog.pack();
        ((Component)this.opDialog).setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.gui.showHelp(null, this, "help14.html");
    }

    public void titoloCampi() {
        if (!this.nomeTabella.equals("")) {
            this.panCampi.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
            this.titoloTabella = new JLabel("<html><font size=4 color=blue>" + this.l.getString("Campi_di") + this.nomeTabella + "</font>");
        } else {
            this.panCampi.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
            this.titoloTabella = new JLabel("<html><font size=4 color=blue>" + this.l.getString("Campi_Disponibili") + "</font>");
        }
        this.nome.add(this.titoloTabella);
        this.panCampi.add(this.nome);
    }

    private void centra() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.opDialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this.opDialog).setSize(frameSize);
        ((Component)this.opDialog).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public String[] creaListaTabelle() {
        try {
            TreeSet ts = DBManager.getTables();
            this.tabelle = new String[ts.size()];
            ts.toArray(this.tabelle);
        }
        catch (DBManagerException dbmex) {
            if (dbmex.isRACaused()) {
                this.gui.semaforo.setRosso();
            }
            this.gui.dialogWindow.append(dbmex.getMessage());
        }
        return this.tabelle;
    }

    public Vector creaListaCampi(TableSchema ts) {
        this.fieldsName.clear();
        this.panCampi.removeAll();
        this.listaSelected.clear();
        LinkedHashSet set = (LinkedHashSet)ts.getFieldNames();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String nome = (String)it.next();
            this.fieldsName.addElement(nome);
        }
        this.titoloCampi();
        return this.fieldsName;
    }

    private class AscoltaComboTab
    implements ActionListener {
        AscoltaComboTab() {
        }

        public void actionPerformed(ActionEvent e) {
            ProjectionOperatorDialog.this.fieldsName.clear();
            ProjectionOperatorDialog.this.nome.removeAll();
            ProjectionOperatorDialog.this.panCampi.removeAll();
            ProjectionOperatorDialog.this.listaSelected.clear();
            JComboBox cb = (JComboBox)e.getSource();
            ProjectionOperatorDialog.this.nomeTabella = (String)cb.getSelectedItem();
            try {
                TableSchema ts = DBManager.getTableFields(ProjectionOperatorDialog.this.nomeTabella);
                Vector listaCampi = ProjectionOperatorDialog.this.creaListaCampi(ts);
                int i = 0;
                while (i < listaCampi.size()) {
                    ProjectionOperatorDialog.this.nameFields = (String)listaCampi.get(i);
                    CheckBox box = new CheckBox(ProjectionOperatorDialog.this.nameFields);
                    ProjectionOperatorDialog.this.panCampi.add(box);
                    ++i;
                }
                ProjectionOperatorDialog.this.panTabField.add(ProjectionOperatorDialog.this.panCampi);
                ProjectionOperatorDialog.this.opDialog.getContentPane().add((Component)ProjectionOperatorDialog.this.panTabField, "Center");
                ProjectionOperatorDialog.this.opDialog.pack();
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    ProjectionOperatorDialog.this.gui.semaforo.setRosso();
                }
                ProjectionOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
        }
    }

    private class AscoltaConferma
    implements ActionListener {
        AscoltaConferma() {
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = new JFrame();
            if (ProjectionOperatorDialog.this.listaSelected.isEmpty()) {
                JOptionPane.showMessageDialog(frame, ProjectionOperatorDialog.this.l.getString("Occorre_selezionare_almeno_un_campo_della_tabella_prima_di_procedere"), ProjectionOperatorDialog.this.l.getString("Errore..."), 2);
                return;
            }
            int n = JOptionPane.showConfirmDialog(frame, ProjectionOperatorDialog.this.l.getString("Confermare_i_dati_selezionati?"), ProjectionOperatorDialog.this.l.getString("Conferma_dati_immessi..."), 2);
            if (n == 0) {
                String[] arrayCampi = new String[ProjectionOperatorDialog.this.listaSelected.size()];
                int j = 0;
                int i = 0;
                while (i < ProjectionOperatorDialog.this.listacampi.size()) {
                    if (ProjectionOperatorDialog.this.listaSelected.contains(ProjectionOperatorDialog.this.listacampi.get(i))) {
                        arrayCampi[j] = (String)ProjectionOperatorDialog.this.listacampi.get(i);
                        ++j;
                    }
                    ++i;
                }
                RAProjection op = ProjectionOperatorDialog.this.isEditing ? (ProjectionOperatorDialog.this.clickedNode.getOp().isLastOp() ? new RAProjection(arrayCampi, ProjectionOperatorDialog.this.nomeTabella) : new RAProjection(arrayCampi, null)) : (!ProjectionOperatorDialog.this.editDirection ? new RAProjection(arrayCampi, ProjectionOperatorDialog.this.nomeTabella) : new RAProjection(arrayCampi, null));
                ProjectionOperatorDialog.this.newNode.updateOp("<html>" + op.toString(), op);
                ProjectionOperatorDialog.this.opDialog.dispose();
            }
        }
    }

    private class AscoltaAnnulla
    implements ActionListener {
        AscoltaAnnulla() {
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = new JFrame();
            int n = JOptionPane.showConfirmDialog(frame, ProjectionOperatorDialog.this.l.getString("Vuoi_annullare_davvero_l'operazione?"), ProjectionOperatorDialog.this.l.getString("Esci_da_Proiezione..."), 2);
            if (n == 0) {
                if (ProjectionOperatorDialog.this.isEditing) {
                    if (ProjectionOperatorDialog.this.treeValid) {
                        ProjectionOperatorDialog.this.newNode.updateOp("<html>" + ProjectionOperatorDialog.this.clickedNode.getOp().toString(), ProjectionOperatorDialog.this.clickedNode.getOp());
                    } else {
                        ProjectionOperatorDialog.this.newNode.updateOp(null, null);
                    }
                } else {
                    ProjectionOperatorDialog.this.newNode.updateOp(null, null);
                }
                ProjectionOperatorDialog.this.opDialog.dispose();
            }
        }
    }

    private class AscoltaExit
    extends WindowAdapter {
        AscoltaExit() {
        }

        public void windowClosing(WindowEvent e) {
            if (ProjectionOperatorDialog.this.isEditing) {
                if (ProjectionOperatorDialog.this.treeValid) {
                    ProjectionOperatorDialog.this.newNode.updateOp("<html>" + ProjectionOperatorDialog.this.clickedNode.getOp().toString(), ProjectionOperatorDialog.this.clickedNode.getOp());
                } else {
                    ProjectionOperatorDialog.this.newNode.updateOp(null, null);
                }
            } else {
                ProjectionOperatorDialog.this.newNode.updateOp(null, null);
            }
            ProjectionOperatorDialog.this.opDialog.dispose();
        }
    }

    public class CheckBox
    extends JPanel
    implements ItemListener {
        JCheckBox campo;

        public CheckBox(String nomeCampo) {
            this.campo = new JCheckBox(nomeCampo);
            this.campo.setMnemonic(67);
            this.campo.setSelected(false);
            this.campo.addItemListener(this);
            JPanel checkPanel = new JPanel();
            checkPanel.setLayout(new GridLayout(0, 1));
            checkPanel.add(this.campo);
            this.setLayout(new BorderLayout());
            this.add((Component)checkPanel, "Before");
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JCheckBox check = (JCheckBox)e.getItem();
                String nome = check.getText();
                ProjectionOperatorDialog.this.listaSelected.add(nome);
            } else if (e.getStateChange() == 2) {
                JCheckBox check = (JCheckBox)e.getItem();
                String nome = check.getText();
                ProjectionOperatorDialog.this.listaSelected.remove(nome);
            }
        }
    }
}

