/*
 * Decompiled with CFR 0.152.
 */
package visualra.GUIControl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;
import visualra.GUIControl.GUI;
import visualra.Language;
import visualra.LogManager;
import visualra.Project;
import visualra.ProjectFile;
import visualra.VisualRA;
import visualra.database.DBManager;
import visualra.database.DBManagerException;

public class NewProject
extends JDialog
implements ActionListener {
    JLabel titolo;
    JPanel pannelloInfo;
    JPanel pannelloNomeProgetto;
    JLabel nomeProgetto;
    JTextField casellaNome;
    JPanel pannelloSceltaFile;
    JLabel labelDataBase;
    JTextField casellaFile;
    JButton sfoglia;
    JCheckBox check;
    JPanel pannelloNomeDriver;
    JLabel nomeDriver;
    JComboBox elencoDriver;
    JPanel pannelloURL;
    JLabel nomeURL;
    JComboBox elencoURL;
    JPanel pannelloPrefisso;
    JLabel nomePrefisso;
    JTextField tipoPrefisso;
    JPanel pannelloTasti;
    JButton crea;
    JButton annulla;
    GUI gui;
    File file;
    JDialog window;

    public NewProject(GUI g) {
        this.gui = g;
        this.window = this;
        this.setTitle(Language.getInstance().getString("Nuovo_Progetto_VisualRA"));
        this.getContentPane().setLayout(new BorderLayout());
        this.pannelloInfo = new JPanel(new GridLayout(6, 1, 4, 4));
        JMenu help = new JMenu();
        JMenuItem helpTopics = new JMenuItem("", 71);
        helpTopics.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpTopics.addActionListener(this);
        help.add(helpTopics);
        help.setVisible(false);
        JMenuBar bar = new JMenuBar();
        bar.add(help);
        this.setJMenuBar(bar);
        this.titolo = new JLabel("<html><b><font color=blue size=5>" + Language.getInstance().getString("Nuovo_Progetto_VisualRA") + "</font></b>");
        JPanel contieneTitolo = new JPanel(new FlowLayout(1));
        contieneTitolo.add(this.titolo);
        this.getContentPane().add((Component)contieneTitolo, "North");
        this.pannelloNomeProgetto = new JPanel(new FlowLayout(0));
        this.nomeProgetto = new JLabel("<html><b><font color=blue size=2>" + Language.getInstance().getString("Nome_Progetto") + "</font></b>");
        this.casellaNome = new JTextField(15);
        this.pannelloNomeProgetto.add(this.nomeProgetto);
        this.pannelloNomeProgetto.add(this.casellaNome);
        this.pannelloInfo.add(this.pannelloNomeProgetto);
        this.pannelloSceltaFile = new JPanel(new FlowLayout(0));
        this.labelDataBase = new JLabel("<html><b><font color=blue size=2>" + Language.getInstance().getString("Data_Base") + "</font></b>");
        this.casellaFile = new JTextField(20);
        this.casellaFile.setText((String)VisualRA.cfgMap.get("LAST_USED_DB_FILE"));
        this.sfoglia = new JButton("Sfoglia");
        this.pannelloSceltaFile.add(this.labelDataBase);
        this.pannelloSceltaFile.add(this.casellaFile);
        this.pannelloSceltaFile.add(this.sfoglia);
        this.pannelloInfo.add(this.pannelloSceltaFile);
        this.sfoglia.addActionListener(new AscoltaApriSfoglia());
        this.check = new JCheckBox("<html><b><font color=blue size=2>" + Language.getInstance().getString("Specifica_Parametri_di_Connessione") + "</font></b>");
        this.check.addItemListener(new AscoltaCheck());
        this.pannelloInfo.add(this.check);
        this.pannelloNomeDriver = new JPanel(new FlowLayout(0));
        this.nomeDriver = new JLabel("<html><b><font color=blue size=2>" + Language.getInstance().getString("Driver") + "</font></b>");
        String[] driver = new String[]{(String)VisualRA.cfgMap.get("DB_DRIVER")};
        this.elencoDriver = new JComboBox<String>(driver);
        this.elencoDriver.setEditable(true);
        this.elencoDriver.setEnabled(false);
        this.pannelloNomeDriver.add(this.nomeDriver);
        this.pannelloNomeDriver.add(this.elencoDriver);
        this.pannelloInfo.add(this.pannelloNomeDriver);
        this.pannelloURL = new JPanel(new FlowLayout(0));
        this.nomeURL = new JLabel("<html><b><font color=blue size=2>" + Language.getInstance().getString("Url") + "</font></b>");
        String[] url = new String[]{(String)VisualRA.cfgMap.get("DB_URL")};
        this.elencoURL = new JComboBox<String>(url);
        this.elencoURL.setEditable(true);
        this.elencoURL.setEnabled(false);
        this.pannelloURL.add(this.nomeURL);
        this.pannelloURL.add(this.elencoURL);
        this.pannelloInfo.add(this.pannelloURL);
        this.pannelloPrefisso = new JPanel(new FlowLayout(0));
        this.nomePrefisso = new JLabel("<html><b><font color=blue size=2>" + Language.getInstance().getString("Prefisso") + "</font></b>");
        this.tipoPrefisso = new JTextField((String)VisualRA.cfgMap.get("DB_TEMPTAB_PREFIX"), 10);
        this.tipoPrefisso.setEnabled(false);
        this.pannelloPrefisso.add(this.nomePrefisso);
        this.pannelloPrefisso.add(this.tipoPrefisso);
        this.pannelloInfo.add(this.pannelloPrefisso);
        this.pannelloTasti = new JPanel(new FlowLayout(1));
        this.crea = new JButton(Language.getInstance().getString("Crea_Progetto"));
        this.crea.addActionListener(new AscoltaCrea());
        this.pannelloTasti.add(this.crea);
        this.annulla = new JButton(Language.getInstance().getString("Annulla"));
        this.annulla.addActionListener(new AscoltaAnnulla());
        this.pannelloTasti.add(this.annulla);
        this.getContentPane().add((Component)this.pannelloTasti, "South");
        this.getContentPane().add((Component)this.pannelloInfo, "Center");
        this.setModal(true);
        this.pack();
        this.centra();
        ((Component)this).setVisible(true);
    }

    private void centra() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setSize(frameSize);
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void actionPerformed(ActionEvent e) {
        this.gui.showHelp(null, this, "help12.html");
    }

    private class AscoltaCheck
    implements ItemListener {
        AscoltaCheck() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                NewProject.this.elencoDriver.setEnabled(true);
                NewProject.this.elencoURL.setEnabled(true);
                NewProject.this.tipoPrefisso.setEnabled(true);
            } else {
                NewProject.this.elencoDriver.setEnabled(false);
                NewProject.this.elencoURL.setEnabled(false);
                NewProject.this.tipoPrefisso.setEnabled(false);
                NewProject.this.tipoPrefisso.setBackground(Color.white);
                NewProject.this.elencoDriver.setSelectedIndex(0);
                NewProject.this.elencoURL.setSelectedIndex(0);
                NewProject.this.tipoPrefisso.setText((String)VisualRA.cfgMap.get("DB_TEMPTAB_PREFIX"));
            }
        }
    }

    private class AscoltaAnnulla
    implements ActionListener {
        AscoltaAnnulla() {
        }

        public void actionPerformed(ActionEvent e) {
            NewProject.this.window.dispose();
        }
    }

    private class AscoltaApriSfoglia
    implements ActionListener {
        AscoltaApriSfoglia() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser apriFile = new JFileChooser((String)VisualRA.cfgMap.get("LAST_USED_DB_FILE"));
            apriFile.setFileFilter(new FiltroMDB());
            int scelta = apriFile.showOpenDialog(NewProject.this.window);
            if (scelta == 0) {
                NewProject.this.file = apriFile.getSelectedFile();
                NewProject.this.casellaFile.setText(NewProject.this.file.getPath());
            }
        }

        private class FiltroMDB
        extends FileFilter {
            FiltroMDB() {
            }

            public String getDescription() {
                return Language.getInstance().getString("File_di_MS_Access");
            }

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String nome = file.getName();
                String ext = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                return ext.equals(Language.getInstance().getString("mdb"));
            }
        }
    }

    private class AscoltaCrea
    implements ActionListener {
        AscoltaCrea() {
        }

        public void actionPerformed(ActionEvent e) {
            File file;
            String carattere;
            boolean trovatoErrore = false;
            char[] caratteriVietati = new char[]{'@', '#', '-', '<', '>', '.', '/', '\\', ',', ';', '\'', '&', '%', '$', '\"', '!', '|'};
            int i = 0;
            while (i < caratteriVietati.length) {
                carattere = String.valueOf(caratteriVietati[i]);
                if (NewProject.this.casellaNome.getText().indexOf(carattere, 0) != -1 || NewProject.this.casellaNome.getText().equals("")) {
                    JOptionPane.showMessageDialog(NewProject.this.window, String.valueOf(Language.getInstance().getString("Il_nome_del_progetto_inserito_\u00e8_vuoto_o_non_\u00e8_valido")) + Language.getInstance().getString("I_seguenti_caratteri_non_sono_ammessi") + "@  #  -  .  /  \\  ;  | <  >  !  &  %  $  \u00a3  (  )  ?  [  ]  ^  \u00a7  \u00b0", Language.getInstance().getString("Errore_inserimento_dati"), 2);
                    trovatoErrore = true;
                    break;
                }
                ++i;
            }
            if (!trovatoErrore && !(file = new File(NewProject.this.casellaFile.getText())).exists()) {
                JOptionPane.showMessageDialog(NewProject.this.window, String.valueOf(Language.getInstance().getString("Il_nome_del_file_del_Data_Base_non_esiste")) + Language.getInstance().getString("Controllare_il_nome_del_file_o_il_percorso_specificato"), Language.getInstance().getString("Errore_inserimento_dati"), 2);
                trovatoErrore = true;
            }
            if (NewProject.this.tipoPrefisso.isEnabled()) {
                i = 0;
                while (i < caratteriVietati.length) {
                    carattere = String.valueOf(caratteriVietati[i]);
                    if (NewProject.this.tipoPrefisso.getText().indexOf(carattere, 0) != -1 || NewProject.this.tipoPrefisso.getText().equals("")) {
                        JOptionPane.showMessageDialog(NewProject.this.window, String.valueOf(Language.getInstance().getString("Il_prefisso_inserito_\u00e8_vuoto_o_non_\u00e8_valido")) + Language.getInstance().getString("I_seguenti_caratteri_non_sono_ammessi") + "@  #  -  .  /  \\  ;  | <  >  !  &  %  $  \u00a3  (  )  ?  [  ]  ^  \u00a7  \u00b0", Language.getInstance().getString("Errore_inserimento_dati"), 2);
                        trovatoErrore = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!trovatoErrore) {
                JFileChooser creaFile = new JFileChooser((String)VisualRA.cfgMap.get("LAST_PROJECT_PATH"));
                creaFile.setFileFilter(new FiltroVRA());
                File vraFileName = null;
                creaFile.setDialogTitle(Language.getInstance().getString("Crea_nuovo_progetto"));
                creaFile.setSelectedFile(new File(NewProject.this.casellaNome.getText()));
                int scelta = creaFile.showDialog(NewProject.this.window, Language.getInstance().getString("Crea"));
                if (scelta == 0) {
                    vraFileName = creaFile.getSelectedFile();
                    VisualRA.cfgMap.put("LAST_USED_DB_FILE", NewProject.this.casellaFile.getText());
                    String fileWithPath = vraFileName.getAbsolutePath();
                    VisualRA.cfgMap.put("LAST_PROJECT_PATH", fileWithPath.substring(0, fileWithPath.length() - vraFileName.getName().length() - 1));
                    DefaultTreeModel fakeTree = ProjectFile.getFakeTree();
                    ProjectFile projectFile = new ProjectFile((String)NewProject.this.elencoDriver.getSelectedItem(), (String)NewProject.this.elencoURL.getSelectedItem(), NewProject.this.casellaFile.getText(), NewProject.this.tipoPrefisso.getText(), String.valueOf(vraFileName.getAbsolutePath()) + ".vra", NewProject.this.casellaNome.getText(), fakeTree);
                    Project.setNewProjectFile(projectFile);
                    this.connetti();
                    NewProject.this.gui.salvafile.setEnabled(true);
                    NewProject.this.gui.saveProject.setEnabled(true);
                    NewProject.this.gui.saveAsProject.setEnabled(true);
                    NewProject.this.gui.modificaNodo.setEnabled(true);
                    NewProject.this.gui.deleteQuery.setEnabled(true);
                    NewProject.this.gui.opUnario.setEnabled(true);
                    NewProject.this.gui.opBinario.setEnabled(true);
                    NewProject.this.gui.modificaOp.setEnabled(true);
                    NewProject.this.gui.eliminaOp.setEnabled(true);
                    NewProject.this.gui.saveAsTable.setEnabled(true);
                    NewProject.this.gui.queryWindow.setText("");
                    NewProject.this.gui.tabelleNodi.setModel(new DefaultTableModel(10, 6));
                }
                NewProject.this.window.dispose();
            }
        }

        private void connetti() {
            try {
                DBManager.connect(Project.getDBDriver(), new File(Project.getDBFileName()), Project.getDBUrl(), Project.getDBTemptabPrefix());
                NewProject.this.gui.dialogWindow.setTextVRA(LogManager.prepareMsg(Language.getInstance().getString("Il_programma_\u00e8_connesso_al_Database"), false));
                NewProject.this.gui.logWindow.setTextVRA(LogManager.prepareMsg(Language.getInstance().getString("Il_programma_\u00e8_connesso_al_Database"), false));
                NewProject.this.gui.tabellaDB.removeAll();
                TreeSet dbTables = DBManager.getTables();
                Iterator itr = dbTables.iterator();
                while (itr.hasNext()) {
                    String name = (String)itr.next();
                    NewProject.this.gui.tabellaDB.addTab(name, null);
                    NewProject.this.gui.tabellaDB.setComponentAt(0, NewProject.this.gui.panTabelleDB);
                }
            }
            catch (DBManagerException dbmex) {
                NewProject.this.gui.dialogWindow.append(dbmex.getMessage());
            }
        }

        private class FiltroVRA
        extends FileFilter {
            FiltroVRA() {
            }

            public String getDescription() {
                return Language.getInstance().getString("File_di_VisualRA");
            }

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String nome = file.getName();
                String ext = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                return ext.equals(Language.getInstance().getString("vra"));
            }
        }
    }
}

