/*
 * Decompiled with CFR 0.152.
 */
package visualra.GUIControl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import visualra.GUIControl.GUI;
import visualra.GUIControl.OpNode;
import visualra.Language;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableField;
import visualra.database.TableSchema;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RAFullOuterJoin;
import visualra.ra2sql.RALeftOuterJoin;
import visualra.ra2sql.RANaturalJoin;
import visualra.ra2sql.RAOperator;
import visualra.ra2sql.RAQuery;
import visualra.ra2sql.RARightOuterJoin;
import visualra.ra2sql.RAThetaJoin;

public class JoinOperatorDialog
extends JDialog
implements ActionListener {
    private static final boolean EDIT_MODE = true;
    private static final boolean INSERT_MODE = false;
    private static final boolean UP_DIRECTION = true;
    private static final boolean DOWN_DIRECTION = false;
    private static final boolean LINK_LEFT = true;
    private static final boolean LINK_RIGHT = false;
    private boolean isEditing;
    private boolean editDirection;
    private boolean selectedNodeLinkPosition;
    private boolean treeValid;
    private LinkedList boxList = new LinkedList();
    private JDialog opDialog;
    private JPanel panRows = new JPanel(new GridLayout(0, 1));
    private JPanel panComandi;
    private JButton conferma;
    private JButton esci;
    Riga riga;
    Set fieldsNameSx = new LinkedHashSet();
    Set fieldsNameDx = new LinkedHashSet();
    OpNode newNode;
    OpNode clickedNode;
    JPanel subPanel;
    CampoJoinSx campoSinistra;
    CampoJoinDx campoDestra;
    RadioButtonOpSet joinRadio;
    String[] stringCampi = null;
    String nomeTabSx = "";
    String nomeTabDx = "";
    String operatoreLogico = Language.getInstance().getString("Join_Esterno_Completo");
    GUI gui;

    public JoinOperatorDialog(OpNode clickedNode, OpNode newNode, boolean isEditing, boolean editDirection, boolean selectedNodeLinkPosition, boolean treeValid, GUI g) {
        this.gui = g;
        this.newNode = newNode;
        this.clickedNode = clickedNode;
        this.isEditing = isEditing;
        this.editDirection = editDirection;
        this.selectedNodeLinkPosition = selectedNodeLinkPosition;
        this.treeValid = treeValid;
        String[] nomiTabSxDx = null;
        try {
            Vector tabs = new Vector(DBManager.getTables());
            nomiTabSxDx = new String[tabs.size()];
            int i = 0;
            while (i < tabs.size()) {
                nomiTabSxDx[i] = (String)tabs.elementAt(i);
                ++i;
            }
        }
        catch (DBManagerException dbmex) {
            if (dbmex.isRACaused()) {
                this.gui.semaforo.setRosso();
            }
            this.gui.dialogWindow.append(dbmex.getMessage());
        }
        int opType = clickedNode.getOp().getType();
        if (isEditing) {
            nomiTabSxDx = new String[2];
            switch (opType) {
                case 10: {
                    nomiTabSxDx = ((RAFullOuterJoin)clickedNode.getOp()).getTables();
                    this.operatoreLogico = Language.getInstance().getString("Join_Esterno_Completo");
                    break;
                }
                case 8: {
                    nomiTabSxDx = ((RALeftOuterJoin)clickedNode.getOp()).getTables();
                    this.operatoreLogico = Language.getInstance().getString("Join_Esterno_Sinistro");
                    break;
                }
                case 9: {
                    nomiTabSxDx = ((RARightOuterJoin)clickedNode.getOp()).getTables();
                    this.operatoreLogico = Language.getInstance().getString("Join_Esterno_Destro");
                    break;
                }
                case 6: {
                    nomiTabSxDx = ((RANaturalJoin)clickedNode.getOp()).getTables();
                    this.operatoreLogico = Language.getInstance().getString("Join_Naturale");
                    break;
                }
                case 7: {
                    nomiTabSxDx = ((RAThetaJoin)clickedNode.getOp()).getTables();
                    this.stringCampi = ((RAThetaJoin)clickedNode.getOp()).getConditions();
                    this.operatoreLogico = Language.getInstance().getString("Theta_Join");
                }
            }
            this.nomeTabSx = nomiTabSxDx[0];
            this.nomeTabDx = nomiTabSxDx[1];
        } else if (!editDirection) {
            this.nomeTabSx = nomiTabSxDx[0];
            this.nomeTabDx = nomiTabSxDx[1];
        } else if (selectedNodeLinkPosition) {
            this.nomeTabSx = null;
            this.nomeTabDx = nomiTabSxDx[0];
        } else {
            this.nomeTabSx = nomiTabSxDx[0];
            this.nomeTabDx = null;
        }
        this.opDialog = new JDialog();
        this.opDialog.setTitle(Language.getInstance().getString("Join"));
        this.opDialog.getContentPane().setLayout(new BorderLayout());
        JMenu help = new JMenu();
        JMenuItem helpTopics = new JMenuItem("", 71);
        helpTopics.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpTopics.addActionListener(this);
        help.add(helpTopics);
        help.setVisible(false);
        JMenuBar bar = new JMenuBar();
        bar.add(help);
        this.opDialog.setJMenuBar(bar);
        Font titolo = new Font(null, 0, 18);
        JLabel intestazione = new JLabel("<html><b><font color=blue>" + Language.getInstance().getString("Join") + "</font></b>");
        intestazione.setFont(titolo);
        JPanel panTitle = new JPanel(new FlowLayout(1));
        panTitle.add(intestazione);
        this.opDialog.getContentPane().add((Component)panTitle, "North");
        this.subPanel = new JPanel(new BorderLayout());
        JPanel pannelloCampi = new JPanel(new FlowLayout(1));
        try {
            this.gui.semaforo.setVerde();
            TableSchema tsSx = null;
            TableSchema tsDx = null;
            if (isEditing) {
                if (this.clickedNode.getOp().isLastOp()) {
                    this.campoSinistra = new CampoJoinSx(this.nomeTabSx);
                    this.campoDestra = new CampoJoinDx(this.nomeTabDx);
                } else if (this.clickedNode.getOp().isLastOpLeft()) {
                    this.campoSinistra = new CampoJoinSx(this.nomeTabSx);
                    tsDx = RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(0));
                    this.campoDestra = new CampoJoinDx(tsDx);
                } else if (this.clickedNode.getOp().isLastOpRight()) {
                    tsSx = RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(0));
                    this.campoSinistra = new CampoJoinSx(tsSx);
                    this.campoDestra = new CampoJoinDx(this.nomeTabDx);
                } else {
                    tsSx = RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(0));
                    this.campoSinistra = new CampoJoinSx(tsSx);
                    tsDx = RAQuery.getSchemaFromNode((OpNode)this.clickedNode.getChildAt(1));
                    this.campoDestra = new CampoJoinDx(tsDx);
                }
            } else if (!editDirection) {
                this.campoSinistra = new CampoJoinSx(this.nomeTabSx);
                this.campoDestra = new CampoJoinDx(this.nomeTabDx);
            } else if (selectedNodeLinkPosition) {
                tsSx = RAQuery.getSchemaFromNode(this.clickedNode);
                this.campoSinistra = new CampoJoinSx(tsSx);
                this.campoDestra = new CampoJoinDx(this.nomeTabDx);
            } else {
                this.campoSinistra = new CampoJoinSx(this.nomeTabSx);
                tsDx = RAQuery.getSchemaFromNode(this.clickedNode);
                this.campoDestra = new CampoJoinDx(tsDx);
            }
            this.joinRadio = new RadioButtonOpSet(this.operatoreLogico);
            this.subPanel.add((Component)this.joinRadio, "Center");
            pannelloCampi.add(this.campoSinistra);
            pannelloCampi.add(this.campoDestra);
            this.subPanel.add((Component)pannelloCampi, "North");
            this.opDialog.getContentPane().add((Component)this.subPanel, "Center");
        }
        catch (DBManagerException dbmex) {
            if (dbmex.isRACaused()) {
                this.gui.semaforo.setRosso();
            }
            this.gui.dialogWindow.append(dbmex.getMessage());
        }
        catch (RAException raex) {
            this.gui.semaforo.setRosso();
            this.gui.dialogWindow.append(raex.getMessage());
        }
        if (this.stringCampi != null) {
            int i;
            String[] condizioneRiga;
            if (this.stringCampi.length > 3) {
                condizioneRiga = new String[4];
                i = 0;
                while (i < 4) {
                    condizioneRiga[i] = this.stringCampi[i];
                    ++i;
                }
                this.riga = new Riga(this.nomeTabSx, this.nomeTabDx, condizioneRiga);
                this.panRows.add(this.riga);
                this.boxList.addLast(this.riga);
                this.riga.aggiungi.setEnabled(true);
                if (condizioneRiga[3] != "") {
                    i = 4;
                    while (i < this.stringCampi.length - 3) {
                        condizioneRiga = new String[4];
                        int j = 0;
                        while (j < 4) {
                            condizioneRiga[j] = this.stringCampi[i + j];
                            ++j;
                        }
                        this.riga = new Riga(this.nomeTabSx, this.nomeTabDx, condizioneRiga);
                        this.panRows.add(this.riga);
                        this.boxList.addLast(this.riga);
                        i += 4;
                    }
                    condizioneRiga = new String[]{this.stringCampi[this.stringCampi.length - 3], this.stringCampi[this.stringCampi.length - 2], this.stringCampi[this.stringCampi.length - 1], ""};
                    this.riga = new Riga(this.nomeTabSx, this.nomeTabDx, condizioneRiga);
                    this.panRows.add(this.riga);
                    this.boxList.addLast(this.riga);
                    this.riga.aggiungi.setEnabled(true);
                }
            } else {
                condizioneRiga = new String[4];
                i = 0;
                while (i < 3) {
                    condizioneRiga[i] = this.stringCampi[i];
                    ++i;
                }
                condizioneRiga[3] = "";
                this.riga = new Riga(this.nomeTabSx, this.nomeTabDx, condizioneRiga);
                this.panRows.add(this.riga);
                this.boxList.addLast(this.riga);
                this.riga.aggiungi.setEnabled(true);
            }
            TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Language.getInstance().getString("Condizioni"), 0, 0, new Font(null, 2, 16));
            title.setTitleColor(Color.blue);
            this.panRows.setBorder(title);
            this.subPanel.add((Component)this.panRows, "South");
            this.opDialog.getContentPane().add((Component)this.subPanel, "Center");
        }
        this.panComandi = new JPanel(new FlowLayout(1));
        this.conferma = new JButton(Language.getInstance().getString("Conferma"));
        this.conferma.addActionListener(new AscoltaConferma());
        this.panComandi.add((Component)this.conferma, "South");
        this.esci = new JButton(Language.getInstance().getString("Annulla"));
        this.esci.addActionListener(new AscoltaEsci());
        this.panComandi.add(this.esci);
        this.opDialog.getContentPane().add((Component)this.panComandi, "South");
        this.opDialog.addWindowListener(new AscoltaExit());
        this.opDialog.setResizable(false);
        this.opDialog.setModal(true);
        this.opDialog.pack();
        this.centra();
        ((Component)this.opDialog).setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.gui.showHelp(null, this, "help16.html");
    }

    private void centra() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.opDialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this.opDialog).setSize(frameSize);
        ((Component)this.opDialog).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private class AscoltaEsci
    implements ActionListener {
        AscoltaEsci() {
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = new JFrame();
            int n = JOptionPane.showConfirmDialog(frame, Language.getInstance().getString("Vuoi_annullare_davvero_l'operazione?"), Language.getInstance().getString("Esci_da_Selezione..."), 2);
            if (n == 0) {
                if (JoinOperatorDialog.this.isEditing) {
                    if (JoinOperatorDialog.this.treeValid) {
                        JoinOperatorDialog.this.newNode.updateOp("<html>" + JoinOperatorDialog.this.clickedNode.getOp().toString(), JoinOperatorDialog.this.clickedNode.getOp());
                    } else {
                        JoinOperatorDialog.this.newNode.updateOp(null, null);
                    }
                } else {
                    JoinOperatorDialog.this.newNode.updateOp(null, null);
                }
                JoinOperatorDialog.this.opDialog.dispose();
            }
        }
    }

    private class AscoltaExit
    extends WindowAdapter {
        AscoltaExit() {
        }

        public void windowClosing(WindowEvent e) {
            if (JoinOperatorDialog.this.isEditing) {
                if (JoinOperatorDialog.this.treeValid) {
                    JoinOperatorDialog.this.newNode.updateOp("<html>" + JoinOperatorDialog.this.clickedNode.getOp().toString(), JoinOperatorDialog.this.clickedNode.getOp());
                } else {
                    JoinOperatorDialog.this.newNode.updateOp(null, null);
                }
            } else {
                JoinOperatorDialog.this.newNode.updateOp(null, null);
            }
            JoinOperatorDialog.this.opDialog.dispose();
        }
    }

    private class AscoltaConferma
    implements ActionListener {
        AscoltaConferma() {
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = new JFrame();
            Vector<String> condizioni = new Vector<String>();
            int n = JOptionPane.showConfirmDialog(frame, Language.getInstance().getString("Confermare_i_dati_selezionati?"), Language.getInstance().getString("Conferma_dati_immessi..."), 2);
            RAOperator op = null;
            if (n == 0) {
                if (JoinOperatorDialog.this.operatoreLogico.equals(Language.getInstance().getString("Join_Esterno_Completo"))) {
                    op = new RAFullOuterJoin(null, null);
                } else if (JoinOperatorDialog.this.operatoreLogico.equals(Language.getInstance().getString("Join_Esterno_Sinistro"))) {
                    op = new RALeftOuterJoin(null, null);
                } else if (JoinOperatorDialog.this.operatoreLogico.equals(Language.getInstance().getString("Join_Esterno_Destro"))) {
                    op = new RARightOuterJoin(null, null);
                } else if (JoinOperatorDialog.this.operatoreLogico.equals(Language.getInstance().getString("Join_Naturale"))) {
                    op = new RANaturalJoin(null, null);
                } else {
                    int i = 0;
                    while (i < JoinOperatorDialog.this.boxList.size()) {
                        JoinOperatorDialog.this.riga = (Riga)JoinOperatorDialog.this.boxList.get(i);
                        if (JoinOperatorDialog.this.riga.check.isSelected()) {
                            condizioni.addElement("(NOT " + JoinOperatorDialog.this.riga.fieldsSx.opCombo.getSelectedItem().toString());
                            condizioni.addElement(JoinOperatorDialog.this.riga.operatori.opCombo.getSelectedItem().toString());
                            condizioni.addElement(String.valueOf(JoinOperatorDialog.this.riga.fieldsDx.opCombo.getSelectedItem().toString()) + ")");
                        } else {
                            condizioni.addElement(JoinOperatorDialog.this.riga.fieldsSx.opCombo.getSelectedItem().toString());
                            condizioni.addElement(JoinOperatorDialog.this.riga.operatori.opCombo.getSelectedItem().toString());
                            condizioni.addElement(JoinOperatorDialog.this.riga.fieldsDx.opCombo.getSelectedItem().toString());
                        }
                        if (JoinOperatorDialog.this.riga.opLogici.isVisible()) {
                            condizioni.addElement(JoinOperatorDialog.this.riga.opLogici.getOperator());
                        }
                        ++i;
                    }
                    String[] arrayCondizioni = new String[condizioni.size()];
                    int i2 = 0;
                    while (i2 < condizioni.size()) {
                        arrayCondizioni[i2] = (String)condizioni.get(i2);
                        ++i2;
                    }
                    op = new RAThetaJoin(null, null, arrayCondizioni);
                }
                String[] selectedTabs = new String[2];
                if (JoinOperatorDialog.this.isEditing) {
                    if (JoinOperatorDialog.this.clickedNode.getOp().isLastOp()) {
                        selectedTabs[0] = JoinOperatorDialog.this.nomeTabSx;
                        selectedTabs[1] = JoinOperatorDialog.this.nomeTabDx;
                    } else if (JoinOperatorDialog.this.clickedNode.getOp().isLastOpLeft()) {
                        selectedTabs[0] = JoinOperatorDialog.this.nomeTabSx;
                        selectedTabs[1] = null;
                    } else if (JoinOperatorDialog.this.clickedNode.getOp().isLastOpRight()) {
                        selectedTabs[0] = null;
                        selectedTabs[1] = JoinOperatorDialog.this.nomeTabDx;
                    } else {
                        selectedTabs[0] = null;
                        selectedTabs[1] = null;
                    }
                } else if (!JoinOperatorDialog.this.editDirection) {
                    selectedTabs[0] = JoinOperatorDialog.this.nomeTabSx;
                    selectedTabs[1] = JoinOperatorDialog.this.nomeTabDx;
                } else if (JoinOperatorDialog.this.selectedNodeLinkPosition) {
                    selectedTabs[0] = null;
                    selectedTabs[1] = JoinOperatorDialog.this.nomeTabDx;
                } else {
                    selectedTabs[0] = JoinOperatorDialog.this.nomeTabSx;
                    selectedTabs[1] = null;
                }
                op.setTables(selectedTabs);
                JoinOperatorDialog.this.newNode.updateOp("<html>" + op.toString(), op);
                JoinOperatorDialog.this.opDialog.dispose();
            }
        }
    }

    public class CampoJoinSx
    extends JPanel {
        JPanel panFieldSx = new JPanel(new BorderLayout());
        TreeSet tsSx;
        String[] tabelleSx;
        JPanel panTabSx = new JPanel(new FlowLayout(1));
        JComboBox tabComboSx;

        public CampoJoinSx(String nomeTabSx) {
            this.setLayout(new FlowLayout(0));
            TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Language.getInstance().getString("Operando_Sinistro"), 0, 2, new Font(null, 1, 14));
            title.setTitleColor(Color.blue);
            this.setBorder(title);
            JPanel contieneTabelle = new JPanel(new GridLayout(2, 1));
            JLabel labelTabelle = new JLabel("<html><b><font color=blue>" + Language.getInstance().getString("Lista_Tabelle") + "</font></b>");
            contieneTabelle.add(labelTabelle);
            String[] tabList = this.creaListaTabelleSx();
            this.tabComboSx = new JComboBox<String>(tabList);
            this.tabComboSx.setSelectedItem(nomeTabSx);
            this.tabComboSx.addActionListener(new AscoltaTabsSx());
            contieneTabelle.add(this.tabComboSx);
            this.panTabSx.add(contieneTabelle);
            this.add(this.panTabSx);
            if (!nomeTabSx.equals("")) {
                try {
                    TableSchema ts = DBManager.getTableFields(nomeTabSx);
                    this.creaListaCampiSx(ts);
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        JoinOperatorDialog.this.gui.semaforo.setRosso();
                    }
                    JoinOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
                }
            }
        }

        public CampoJoinSx(TableSchema ts) {
            this.setLayout(new FlowLayout(0));
            TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Language.getInstance().getString("Operando_Sinistro"), 0, 2, new Font(null, 1, 14));
            title.setTitleColor(Color.blue);
            this.setBorder(title);
            this.creaListaCampiSx(ts);
        }

        public String[] creaListaTabelleSx() {
            try {
                this.tsSx = DBManager.getTables();
                this.tabelleSx = new String[this.tsSx.size()];
                this.tsSx.toArray(this.tabelleSx);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    JoinOperatorDialog.this.gui.semaforo.setRosso();
                }
                JoinOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
            return this.tabelleSx;
        }

        public Set creaListaCampiSx(TableSchema ts) {
            JLabel titoloTabella;
            JPanel titoloCampiTabella = new JPanel(new FlowLayout(0));
            Font titolo = new Font(null, 0, 13);
            JPanel campi = new JPanel(new GridLayout(0, 1));
            titoloCampiTabella.removeAll();
            this.panFieldSx.removeAll();
            JoinOperatorDialog.this.fieldsNameSx.clear();
            Set set = ts.getFieldNames();
            Set setField = ts.getFields();
            Iterator it = set.iterator();
            Iterator itf = setField.iterator();
            if (JoinOperatorDialog.this.nomeTabSx != null) {
                this.panFieldSx.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
                titoloTabella = new JLabel("<html><font size=4 color=blue>" + Language.getInstance().getString("Campi_di") + " " + JoinOperatorDialog.this.nomeTabSx + "</font>");
            } else {
                this.panFieldSx.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
                titoloTabella = new JLabel("<html><font size=4 color=blue>" + Language.getInstance().getString("Campi_Disponibili") + "</font>");
            }
            titoloCampiTabella.add(titoloTabella);
            campi.add(titoloCampiTabella);
            while (it.hasNext()) {
                String nome = (String)it.next();
                String tipo = ((TableField)itf.next()).getTypeAsITString();
                JLabel nomeCampo = new JLabel("<html><font face=\"Courier New\" size=3><b>" + nome + "</b>: <i>" + tipo + "</font></i>");
                campi.add(nomeCampo);
                this.panFieldSx.add(campi);
                JoinOperatorDialog.this.fieldsNameSx.add(nome);
            }
            this.add(this.panFieldSx);
            return JoinOperatorDialog.this.fieldsNameSx;
        }

        private class AscoltaTabsSx
        implements ActionListener {
            AscoltaTabsSx() {
            }

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                ((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.nomeTabSx = (String)cb.getSelectedItem();
                try {
                    TableSchema ts = DBManager.getTableFields(((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.nomeTabSx);
                    Set listaCampi = CampoJoinSx.this.creaListaCampiSx(ts);
                    if (JoinOperatorDialog.this.boxList.size() >= 1) {
                        ((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.riga = (Riga)JoinOperatorDialog.this.boxList.getLast();
                        Set<Component> campi = new LinkedHashSet<Component>();
                        int i = 0;
                        while (i < ((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.riga.fieldsDx.getComponentCount()) {
                            campi.add(((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.riga.fieldsDx.getComponent(i));
                            campi = ((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.riga.fieldsDx.getCampi();
                            ++i;
                        }
                        JoinOperatorDialog.this.panRows.removeAll();
                        JoinOperatorDialog.this.boxList.clear();
                        String[] vuoto = new String[]{"", "", "", ""};
                        ((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.riga = new Riga(((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.fieldsNameSx, campi, vuoto);
                        JoinOperatorDialog.this.panRows.add(((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.riga);
                        ((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.subPanel.add((Component)JoinOperatorDialog.this.panRows, "South");
                        JoinOperatorDialog.this.opDialog.getContentPane().add((Component)((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.subPanel, "Center");
                        JoinOperatorDialog.this.boxList.addLast(((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.riga);
                    }
                    JoinOperatorDialog.this.opDialog.pack();
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        ((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.gui.semaforo.setRosso();
                    }
                    ((CampoJoinSx)CampoJoinSx.this).JoinOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
                }
            }
        }
    }

    public class CampoJoinDx
    extends JPanel {
        JPanel panFieldDx = new JPanel(new BorderLayout());
        String[] tabelle;
        JPanel panTabDx = new JPanel(new FlowLayout(1));
        JComboBox tabComboDx;

        public CampoJoinDx(String nomeTabDx) {
            this.setLayout(new FlowLayout(0));
            TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Language.getInstance().getString("Operando_Destro"), 0, 2, new Font(null, 1, 14));
            title.setTitleColor(Color.blue);
            this.setBorder(title);
            JPanel contieneTabelle = new JPanel(new GridLayout(2, 1));
            JLabel labelTabelle = new JLabel("<html><b><font color=blue>" + Language.getInstance().getString("Lista_Tabelle") + "</font></b>");
            contieneTabelle.add(labelTabelle);
            String[] tabList = this.creaListaTabelle();
            this.tabComboDx = new JComboBox<String>(tabList);
            this.tabComboDx.setSelectedItem(nomeTabDx);
            this.tabComboDx.addActionListener(new AscoltaTabsDx());
            contieneTabelle.add(this.tabComboDx);
            this.panTabDx.add(contieneTabelle);
            this.add(this.panTabDx);
            try {
                TableSchema ts = DBManager.getTableFields(nomeTabDx);
                this.creaListaCampiDx(ts);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    JoinOperatorDialog.this.gui.semaforo.setRosso();
                }
                JoinOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
        }

        public CampoJoinDx(TableSchema ts) {
            this.setLayout(new FlowLayout(0));
            TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Language.getInstance().getString("Operando_Destro"), 0, 2, new Font(null, 1, 14));
            title.setTitleColor(Color.blue);
            this.setBorder(title);
            this.creaListaCampiDx(ts);
        }

        public String[] creaListaTabelle() {
            try {
                TreeSet ts = DBManager.getTables();
                this.tabelle = new String[ts.size()];
                ts.toArray(this.tabelle);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    JoinOperatorDialog.this.gui.semaforo.setRosso();
                }
                JoinOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
            return this.tabelle;
        }

        public Set creaListaCampiDx(TableSchema ts) {
            JLabel titoloTabella;
            JPanel titoloCampiTabella = new JPanel(new FlowLayout(0));
            Font titolo = new Font(null, 0, 13);
            JPanel campiDx = new JPanel(new GridLayout(0, 1));
            titoloCampiTabella.removeAll();
            this.panFieldDx.removeAll();
            JoinOperatorDialog.this.fieldsNameDx.clear();
            Set set = ts.getFieldNames();
            Set setField = ts.getFields();
            Iterator it = set.iterator();
            Iterator itf = setField.iterator();
            if (JoinOperatorDialog.this.nomeTabDx != null) {
                this.panFieldDx.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
                titoloTabella = new JLabel("<html><font size=4 color=blue>" + Language.getInstance().getString("Campi_di") + " " + JoinOperatorDialog.this.nomeTabDx + "</font>");
            } else {
                this.panFieldDx.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, new Font(null, 2, 16)));
                titoloTabella = new JLabel("<html><font size=4 color=blue>" + Language.getInstance().getString("Campi_Disponibili") + "</font>");
            }
            titoloCampiTabella.add(titoloTabella);
            campiDx.add(titoloCampiTabella);
            while (it.hasNext()) {
                String nome = (String)it.next();
                String tipo = ((TableField)itf.next()).getTypeAsITString();
                JLabel nomeCampo = new JLabel("<html><font face=\"Courier New\" size=3><b>" + nome + "</b>: <i>" + tipo + "</font></i>");
                campiDx.add(nomeCampo);
                this.panFieldDx.add(campiDx);
                JoinOperatorDialog.this.fieldsNameDx.add(nome);
            }
            this.add(this.panFieldDx);
            return JoinOperatorDialog.this.fieldsNameDx;
        }

        private class AscoltaTabsDx
        implements ActionListener {
            AscoltaTabsDx() {
            }

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                ((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.nomeTabDx = (String)cb.getSelectedItem();
                try {
                    TableSchema ts = DBManager.getTableFields(((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.nomeTabDx);
                    Set listaCampi = CampoJoinDx.this.creaListaCampiDx(ts);
                    if (JoinOperatorDialog.this.boxList.size() >= 1) {
                        ((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.riga = (Riga)JoinOperatorDialog.this.boxList.getLast();
                        Set<Component> campi = new LinkedHashSet<Component>();
                        int i = 0;
                        while (i < ((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.riga.fieldsSx.getComponentCount()) {
                            campi.add(((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.riga.fieldsSx.getComponent(i));
                            campi = ((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.riga.fieldsSx.getCampi();
                            ++i;
                        }
                        JoinOperatorDialog.this.panRows.removeAll();
                        JoinOperatorDialog.this.boxList.clear();
                        String[] vuoto = new String[]{"", "", "", ""};
                        ((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.riga = new Riga(campi, ((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.nomeTabDx, vuoto);
                        JoinOperatorDialog.this.panRows.add(((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.riga);
                        ((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.subPanel.add((Component)JoinOperatorDialog.this.panRows, "South");
                        JoinOperatorDialog.this.opDialog.getContentPane().add((Component)((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.subPanel, "Center");
                        JoinOperatorDialog.this.boxList.addLast(((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.riga);
                        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Language.getInstance().getString("Condizioni"), 0, 0, new Font(null, 2, 14));
                        title.setTitleColor(Color.blue);
                        JoinOperatorDialog.this.panRows.setBorder(title);
                    }
                    JoinOperatorDialog.this.opDialog.pack();
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        ((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.gui.semaforo.setRosso();
                    }
                    ((CampoJoinDx)CampoJoinDx.this).JoinOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
                }
            }
        }
    }

    public class Riga
    extends JPanel {
        JCheckBox check;
        JTextField val;
        RadioButtonOpLogici opLogici;
        JButton aggiungi;
        JButton remove;
        JPanel riga;
        String campo1;
        String operatore;
        String campo2;
        String funLogica;
        CheckCombo fieldsSx;
        CheckCombo fieldsDx;
        CheckCombo operatori;

        public Riga(String nomeTabSx, String nomeTabDx, String[] condizione) {
            this.campo1 = condizione[0];
            this.operatore = condizione[1];
            this.campo2 = condizione[2];
            this.funLogica = condizione[3];
            this.riga = this;
            this.setLayout(new FlowLayout(0));
            this.check = new JCheckBox("<html><b><font color=blue size=2> NOT </font></b>");
            if (!this.campo1.equals("") && this.campo1.charAt(0) == '(') {
                this.check.setSelected(true);
            } else {
                this.check.setSelected(false);
            }
            this.add(this.check);
            if (nomeTabSx == null || nomeTabSx.equals("")) {
                this.fieldsSx = this.check.isSelected() ? new CheckCombo(JoinOperatorDialog.this.fieldsNameSx, this.campo1.substring(5)) : new CheckCombo(JoinOperatorDialog.this.fieldsNameSx, this.campo1);
                this.add(this.fieldsSx);
            } else {
                try {
                    TableSchema ts = DBManager.getTableFields(nomeTabSx);
                    Set listaCampi = JoinOperatorDialog.this.campoSinistra.creaListaCampiSx(ts);
                    this.fieldsSx = this.check.isSelected() ? new CheckCombo(listaCampi, this.campo1.substring(5)) : new CheckCombo(listaCampi, this.campo1);
                    this.add(this.fieldsSx);
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        JoinOperatorDialog.this.gui.semaforo.setRosso();
                    }
                    JoinOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
                }
            }
            LinkedHashSet<String> opConfronto = new LinkedHashSet<String>(6);
            opConfronto.add("=");
            opConfronto.add("<>");
            opConfronto.add(">");
            opConfronto.add("<");
            opConfronto.add(">=");
            opConfronto.add("<=");
            this.operatori = !this.operatore.equals("") ? new CheckCombo(opConfronto, this.operatore) : new CheckCombo(opConfronto, "=");
            this.add(this.operatori);
            if (nomeTabDx == null || nomeTabDx.equals("")) {
                if (this.check.isSelected()) {
                    if (this.campo2.charAt(this.campo2.length() - 1) == ')') {
                        int numeroCaratteri = this.campo2.length();
                        this.fieldsDx = new CheckCombo(JoinOperatorDialog.this.fieldsNameDx, this.campo2.substring(0, numeroCaratteri - 1));
                    }
                } else {
                    this.fieldsDx = new CheckCombo(JoinOperatorDialog.this.fieldsNameDx, this.campo2);
                }
                this.add(this.fieldsDx);
            } else {
                try {
                    TableSchema ts = DBManager.getTableFields(nomeTabDx);
                    Set listaCampi = JoinOperatorDialog.this.campoDestra.creaListaCampiDx(ts);
                    if (this.check.isSelected()) {
                        if (this.campo2.charAt(this.campo2.length() - 1) == ')') {
                            int numeroCaratteri = this.campo2.length();
                            this.fieldsDx = new CheckCombo(listaCampi, this.campo2.substring(0, numeroCaratteri - 1));
                        }
                    } else {
                        this.fieldsDx = new CheckCombo(listaCampi, this.campo2);
                    }
                    this.add(this.fieldsDx);
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        JoinOperatorDialog.this.gui.semaforo.setRosso();
                    }
                    JoinOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
                }
            }
            this.opLogici = new RadioButtonOpLogici(this.funLogica);
            this.add(this.opLogici);
            if (this.funLogica.equals("")) {
                this.opLogici.setVisible(false);
            } else {
                this.opLogici.setVisible(true);
            }
            this.aggiungi = new JButton(Language.getInstance().getString("Aggiungi"));
            this.aggiungi.addActionListener(new AscoltaAggiungi());
            this.add(this.aggiungi);
            this.aggiungi.setToolTipText(Language.getInstance().getString("Specificare_una_condizione_prima_di_aggiungerne_una_nuova"));
            JButton rimuovi = new JButton(Language.getInstance().getString("Rimuovi"));
            rimuovi.setToolTipText(Language.getInstance().getString("Elimina_una_condizione_inserita"));
            rimuovi.addActionListener(new AscoltaRemove());
            this.add(rimuovi);
        }

        public Riga(Set fieldsNameSx, Set campi, String[] condizione) {
            this.campo1 = condizione[0];
            this.operatore = condizione[1];
            this.campo2 = condizione[2];
            this.funLogica = condizione[3];
            this.riga = this;
            this.setLayout(new FlowLayout(0));
            LinkedHashSet nomiCampi = new LinkedHashSet();
            this.check = new JCheckBox("<html><b><font color=blue size=2> NOT </font></b>");
            if (!this.campo1.equals("") && this.campo1.charAt(0) == '(') {
                this.check.setSelected(true);
            } else {
                this.check.setSelected(false);
            }
            this.add(this.check);
            this.fieldsSx = this.check.isSelected() ? new CheckCombo(fieldsNameSx, this.campo1.substring(5)) : new CheckCombo(fieldsNameSx, this.campo1);
            this.add(this.fieldsSx);
            LinkedHashSet<String> opConfronto = new LinkedHashSet<String>(6);
            opConfronto.add("=");
            opConfronto.add("!=");
            opConfronto.add(">");
            opConfronto.add("<");
            opConfronto.add(">=");
            opConfronto.add("<=");
            this.operatori = !this.operatore.equals("") ? new CheckCombo(opConfronto, this.operatore) : new CheckCombo(opConfronto, "=");
            this.add(this.operatori);
            if (this.check.isSelected()) {
                if (this.campo2.charAt(this.campo2.length() - 1) == ')') {
                    int numeroCaratteri = this.campo2.length();
                    this.fieldsDx = new CheckCombo(campi, this.campo2.substring(0, numeroCaratteri - 1));
                }
            } else {
                this.fieldsDx = new CheckCombo(campi, this.campo2);
            }
            this.add(this.fieldsDx);
            this.opLogici = new RadioButtonOpLogici(this.funLogica);
            this.add(this.opLogici);
            if (this.funLogica.equals("")) {
                this.opLogici.setVisible(false);
            } else {
                this.opLogici.setVisible(true);
            }
            this.aggiungi = new JButton(Language.getInstance().getString("Aggiungi"));
            this.aggiungi.addActionListener(new AscoltaAggiungi());
            this.add(this.aggiungi);
            this.aggiungi.setToolTipText(Language.getInstance().getString("Specificare_una_condizione_prima_di_aggiungerne_una_nuova"));
            JButton rimuovi = new JButton(Language.getInstance().getString("Rimuovi"));
            rimuovi.setToolTipText(Language.getInstance().getString("Elimina_una_condizione_inserita"));
            rimuovi.addActionListener(new AscoltaRemove());
            this.add(rimuovi);
        }

        public Riga(Set campi, String nomeTabDx, String[] condizione) {
            this.campo1 = condizione[0];
            this.operatore = condizione[1];
            this.campo2 = condizione[2];
            this.funLogica = condizione[3];
            this.riga = this;
            this.setLayout(new FlowLayout(0));
            LinkedHashSet nomiCampi = new LinkedHashSet();
            this.check = new JCheckBox("<html><b><font color=blue size=2> NOT </font></b>");
            if (!this.campo1.equals("") && this.campo1.charAt(0) == '(') {
                this.check.setSelected(true);
            } else {
                this.check.setSelected(false);
            }
            this.add(this.check);
            if (this.check.isSelected()) {
                if (this.campo2.charAt(this.campo2.length() - 1) == ')') {
                    int numeroCaratteri = this.campo2.length();
                    this.fieldsSx = new CheckCombo(campi, this.campo2.substring(0, numeroCaratteri - 1));
                }
            } else {
                this.fieldsSx = new CheckCombo(campi, this.campo2);
            }
            this.add(this.fieldsSx);
            LinkedHashSet<String> opConfronto = new LinkedHashSet<String>(6);
            opConfronto.add("=");
            opConfronto.add("!=");
            opConfronto.add(">");
            opConfronto.add("<");
            opConfronto.add(">=");
            opConfronto.add("<=");
            this.operatori = !this.operatore.equals("") ? new CheckCombo(opConfronto, this.operatore) : new CheckCombo(opConfronto, "=");
            this.add(this.operatori);
            try {
                TableSchema ts = DBManager.getTableFields(nomeTabDx);
                Set listaCampi = JoinOperatorDialog.this.campoDestra.creaListaCampiDx(ts);
                if (this.check.isSelected()) {
                    if (this.campo2.charAt(this.campo2.length() - 1) == ')') {
                        int numeroCaratteri = this.campo2.length();
                        this.fieldsDx = new CheckCombo(listaCampi, this.campo2.substring(0, numeroCaratteri - 1));
                    }
                } else {
                    this.fieldsDx = new CheckCombo(listaCampi, this.campo2);
                }
                this.add(this.fieldsDx);
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    JoinOperatorDialog.this.gui.semaforo.setRosso();
                }
                JoinOperatorDialog.this.gui.dialogWindow.append(dbmex.getMessage());
            }
            this.opLogici = new RadioButtonOpLogici(this.funLogica);
            this.add(this.opLogici);
            if (this.funLogica.equals("")) {
                this.opLogici.setVisible(false);
            } else {
                this.opLogici.setVisible(true);
            }
            this.aggiungi = new JButton(Language.getInstance().getString("Aggiungi"));
            this.aggiungi.addActionListener(new AscoltaAggiungi());
            this.add(this.aggiungi);
            this.aggiungi.setToolTipText(Language.getInstance().getString("Specificare_una_condizione_prima_di_aggiungerne_una_nuova"));
            JButton rimuovi = new JButton(Language.getInstance().getString("Rimuovi"));
            rimuovi.setToolTipText(Language.getInstance().getString("Elimina_una_condizione_inserita"));
            rimuovi.addActionListener(new AscoltaRemove());
            this.add(rimuovi);
        }

        private class AscoltaRemove
        implements ActionListener {
            AscoltaRemove() {
            }

            public void actionPerformed(ActionEvent e) {
                if (JoinOperatorDialog.this.boxList.size() > 1) {
                    JoinOperatorDialog.this.panRows.remove(Riga.this.riga);
                    JoinOperatorDialog.this.boxList.remove(Riga.this.riga);
                    Riga riga = (Riga)JoinOperatorDialog.this.boxList.getLast();
                    riga.opLogici.setVisible(false);
                    riga.aggiungi.setEnabled(true);
                    riga.aggiungi.setToolTipText(Language.getInstance().getString("Specificare_una_condizione_prima_di_aggiungerne_una_nuova"));
                    JoinOperatorDialog.this.opDialog.pack();
                } else {
                    JOptionPane.showMessageDialog(null, Language.getInstance().getString("Non_puoi_rimuovere_il_componente"), Language.getInstance().getString("Errore..."), 0);
                }
            }
        }

        private class AscoltaAggiungi
        implements ActionListener {
            AscoltaAggiungi() {
            }

            public void actionPerformed(ActionEvent e) {
                Riga.this.opLogici.setVisible(true);
                Riga.this.opLogici.setToolTipText(Language.getInstance().getString("Selezionare_un_operatore_logico"));
                Riga.this.aggiungi.setEnabled(false);
                Riga.this.aggiungi.setToolTipText(Language.getInstance().getString("Specificare_una_condizione_prima_di_aggiungerne_una_nuova"));
                JoinOperatorDialog.this.conferma.setToolTipText(Language.getInstance().getString("Per_confermare_occorre_riempire_i_campi"));
                String[] vuoto = new String[]{"", "", "", ""};
                Riga riga = new Riga("", "", vuoto);
                JoinOperatorDialog.this.panRows.add(riga);
                ((Riga)Riga.this).JoinOperatorDialog.this.subPanel.add((Component)JoinOperatorDialog.this.panRows, "South");
                JoinOperatorDialog.this.opDialog.getContentPane().add((Component)((Riga)Riga.this).JoinOperatorDialog.this.subPanel, "Center");
                JoinOperatorDialog.this.boxList.addLast(riga);
                JoinOperatorDialog.this.opDialog.pack();
            }
        }
    }

    public class CheckCombo
    extends JPanel {
        String campo;
        JComboBox opCombo;
        Set campi = new LinkedHashSet();

        public CheckCombo(Set opzioni, String campoItem) {
            this.opCombo = new JComboBox<Object>(opzioni.toArray());
            this.opCombo.addActionListener(new AscoltaCombo());
            this.opCombo.setSelectedItem(campoItem);
            this.campo = (String)this.opCombo.getSelectedItem();
            this.add(this.opCombo);
            this.campi = opzioni;
        }

        public Set getCampi() {
            return this.campi;
        }

        public String getValue() {
            return this.campo;
        }

        private class AscoltaCombo
        implements ActionListener {
            AscoltaCombo() {
            }

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                CheckCombo.this.campo = (String)cb.getSelectedItem();
            }
        }
    }

    public class RadioButtonOpSet
    extends JPanel
    implements ActionListener {
        String joinEstCompleto = Language.getInstance().getString("Join_Esterno_Completo");
        String joinEstSinistro = Language.getInstance().getString("Join_Esterno_Sinistro");
        String joinEstDestro = Language.getInstance().getString("Join_Esterno_Destro");
        String joinNaturale = Language.getInstance().getString("Join_Naturale");
        String joinTheta = Language.getInstance().getString("Theta_Join");

        public RadioButtonOpSet(String defaultValue) {
            JRadioButton JEstConpletoButton = new JRadioButton(this.joinEstCompleto);
            JEstConpletoButton.setMnemonic(66);
            JEstConpletoButton.setActionCommand(this.joinEstCompleto);
            JRadioButton JEstSinistroButton = new JRadioButton(this.joinEstSinistro);
            JEstSinistroButton.setMnemonic(66);
            JEstSinistroButton.setActionCommand(this.joinEstSinistro);
            JRadioButton JEstDestroButton = new JRadioButton(this.joinEstDestro);
            JEstDestroButton.setMnemonic(66);
            JEstDestroButton.setActionCommand(this.joinEstDestro);
            JRadioButton JNaturalButton = new JRadioButton(this.joinNaturale);
            JNaturalButton.setMnemonic(66);
            JNaturalButton.setActionCommand(this.joinNaturale);
            JRadioButton JThetaButton = new JRadioButton(this.joinTheta);
            JThetaButton.setMnemonic(66);
            JThetaButton.setActionCommand(this.joinTheta);
            if (defaultValue.equals(this.joinEstCompleto)) {
                JEstConpletoButton.setSelected(true);
            } else if (defaultValue.equals(this.joinEstSinistro)) {
                JEstSinistroButton.setSelected(true);
            } else if (defaultValue.equals(this.joinEstDestro)) {
                JEstDestroButton.setSelected(true);
            } else if (defaultValue.equals(this.joinNaturale)) {
                JNaturalButton.setSelected(true);
            } else if (defaultValue.equals(this.joinTheta)) {
                JThetaButton.setSelected(true);
            } else {
                JEstConpletoButton.setSelected(true);
            }
            ButtonGroup group = new ButtonGroup();
            group.add(JEstConpletoButton);
            group.add(JEstSinistroButton);
            group.add(JEstDestroButton);
            group.add(JNaturalButton);
            group.add(JThetaButton);
            JEstConpletoButton.addActionListener(this);
            JEstSinistroButton.addActionListener(this);
            JEstDestroButton.addActionListener(this);
            JNaturalButton.addActionListener(this);
            JThetaButton.addActionListener(this);
            JPanel radioPanel = new JPanel();
            radioPanel.setLayout(new FlowLayout(0));
            radioPanel.add(JEstConpletoButton);
            radioPanel.add(JEstSinistroButton);
            radioPanel.add(JEstDestroButton);
            radioPanel.add(JNaturalButton);
            radioPanel.add(JThetaButton);
            this.setLayout(new BorderLayout());
            this.add((Component)radioPanel, "East");
        }

        public void actionPerformed(ActionEvent e) {
            JoinOperatorDialog.this.operatoreLogico = e.getActionCommand();
            if (JoinOperatorDialog.this.operatoreLogico.equals(Language.getInstance().getString("Theta_Join"))) {
                int i;
                JoinOperatorDialog.this.panRows.removeAll();
                JoinOperatorDialog.this.subPanel.remove(JoinOperatorDialog.this.panRows);
                JoinOperatorDialog.this.boxList.clear();
                if (JoinOperatorDialog.this.stringCampi == null) {
                    String[] condizioneRiga = new String[]{"", "", "", ""};
                    JoinOperatorDialog.this.riga = new Riga(JoinOperatorDialog.this.nomeTabSx, JoinOperatorDialog.this.nomeTabDx, condizioneRiga);
                    JoinOperatorDialog.this.panRows.add((Component)JoinOperatorDialog.this.riga, "Center");
                } else if (JoinOperatorDialog.this.stringCampi.length > 3) {
                    String[] condizioneRiga = new String[4];
                    i = 0;
                    while (i < 4) {
                        condizioneRiga[i] = JoinOperatorDialog.this.stringCampi[i];
                        ++i;
                    }
                    JoinOperatorDialog.this.riga = new Riga(JoinOperatorDialog.this.nomeTabSx, JoinOperatorDialog.this.nomeTabDx, condizioneRiga);
                    if (condizioneRiga[3] != "") {
                        i = 4;
                        while (i < JoinOperatorDialog.this.stringCampi.length - 3) {
                            condizioneRiga = new String[4];
                            int j = 0;
                            while (j < 4) {
                                condizioneRiga[j] = JoinOperatorDialog.this.stringCampi[i + j];
                                ++j;
                            }
                            JoinOperatorDialog.this.riga = new Riga(JoinOperatorDialog.this.nomeTabSx, JoinOperatorDialog.this.nomeTabDx, condizioneRiga);
                            i += 4;
                        }
                        condizioneRiga = new String[]{JoinOperatorDialog.this.stringCampi[JoinOperatorDialog.this.stringCampi.length - 3], JoinOperatorDialog.this.stringCampi[JoinOperatorDialog.this.stringCampi.length - 2], JoinOperatorDialog.this.stringCampi[JoinOperatorDialog.this.stringCampi.length - 1], ""};
                        JoinOperatorDialog.this.riga = new Riga(JoinOperatorDialog.this.nomeTabSx, JoinOperatorDialog.this.nomeTabDx, condizioneRiga);
                    }
                } else {
                    String[] condizioneRiga = new String[4];
                    i = 0;
                    while (i < 3) {
                        condizioneRiga[i] = JoinOperatorDialog.this.stringCampi[i];
                        ++i;
                    }
                    condizioneRiga[3] = "";
                    JoinOperatorDialog.this.riga = new Riga(JoinOperatorDialog.this.nomeTabSx, JoinOperatorDialog.this.nomeTabDx, condizioneRiga);
                }
                JoinOperatorDialog.this.panRows.add(JoinOperatorDialog.this.riga);
                JoinOperatorDialog.this.boxList.addLast(JoinOperatorDialog.this.riga);
                TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Language.getInstance().getString("Condizioni"), 0, 0, new Font(null, 2, 14));
                title.setTitleColor(Color.blue);
                JoinOperatorDialog.this.panRows.setBorder(title);
                JoinOperatorDialog.this.subPanel.add((Component)JoinOperatorDialog.this.panRows, "South");
                JoinOperatorDialog.this.opDialog.getContentPane().add((Component)JoinOperatorDialog.this.subPanel, "Center");
                JoinOperatorDialog.this.opDialog.pack();
            } else {
                JoinOperatorDialog.this.panRows.removeAll();
                JoinOperatorDialog.this.subPanel.remove(JoinOperatorDialog.this.panRows);
                JoinOperatorDialog.this.boxList.clear();
                JoinOperatorDialog.this.opDialog.pack();
            }
        }

        public String getOperator() {
            return JoinOperatorDialog.this.operatoreLogico;
        }
    }

    public class RadioButtonOpLogici
    extends JPanel
    implements ActionListener {
        String and = "AND";
        String or = "OR";
        String operator = "AND";

        public RadioButtonOpLogici(String defaultValue) {
            JRadioButton andButton = new JRadioButton(this.and);
            andButton.setMnemonic(66);
            andButton.setActionCommand(this.and);
            JRadioButton orButton = new JRadioButton(this.or);
            orButton.setMnemonic(67);
            orButton.setActionCommand(this.or);
            if (defaultValue.equals(this.and)) {
                andButton.setSelected(true);
                this.operator = "AND";
            } else if (defaultValue.equals(this.or)) {
                orButton.setSelected(true);
                this.operator = "OR";
            } else {
                andButton.setSelected(true);
            }
            ButtonGroup group = new ButtonGroup();
            group.add(andButton);
            group.add(orButton);
            andButton.addActionListener(this);
            orButton.addActionListener(this);
            JPanel radioPanel = new JPanel();
            radioPanel.setLayout(new FlowLayout(0));
            radioPanel.add(andButton);
            radioPanel.add(orButton);
            this.setLayout(new BorderLayout());
            this.add((Component)radioPanel, "East");
        }

        public void actionPerformed(ActionEvent e) {
            this.operator = e.getActionCommand();
        }

        public String getOperator() {
            return this.operator;
        }
    }
}

