/*
 * Decompiled with CFR 0.152.
 */
package visualra.GUIControl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import visualra.Language;
import visualra.LogManager;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.database.TableSchema;

public class CachedResultSetTableModel
extends DefaultTableModel {
    public CachedResultSetTableModel(ResultSet rs) throws DBManagerException {
        try {
            TableSchema ts = DBManager.getResultSetFields(rs, "");
            LinkedHashSet fields = (LinkedHashSet)ts.getFieldNames();
            int fieldCount = fields.size();
            Vector<String> columnNames = new Vector<String>(fieldCount);
            Iterator itrf = fields.iterator();
            while (itrf.hasNext()) {
                String field = (String)itrf.next();
                columnNames.addElement(field);
            }
            Vector tableData = new Vector();
            while (rs.next()) {
                Vector<Object> rowData = new Vector<Object>(fieldCount);
                int i = 1;
                while (i <= fieldCount) {
                    rowData.addElement(rs.getObject(i));
                    ++i;
                }
                tableData.addElement(rowData);
            }
            this.setDataVector(tableData, columnNames);
        }
        catch (SQLException sqlex) {
            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_estrazione_dati_x_creazione_tabella_grafica"), true));
        }
        catch (DBManagerException dbcex) {
            throw dbcex;
        }
    }

    public CachedResultSetTableModel(Vector columnNames, Vector tableData) throws DBManagerException {
        this.setDataVector(tableData, columnNames);
    }

    public boolean isCellEditable(int r, int c) {
        return false;
    }
}

