/*
 * Decompiled with CFR 0.152.
 */
package visualra.GUIControl;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import visualra.GUIControl.CachedResultSetTableModel;
import visualra.GUIControl.GUI;
import visualra.GUIControl.JoinOperatorDialog;
import visualra.GUIControl.NewProject;
import visualra.GUIControl.OpNode;
import visualra.GUIControl.ProjectionOperatorDialog;
import visualra.GUIControl.RenameOperatorDialog;
import visualra.GUIControl.SaveResultTableDialog;
import visualra.GUIControl.SelectionOperatorDialog;
import visualra.GUIControl.SetOperatorDialog;
import visualra.Language;
import visualra.LogManager;
import visualra.Project;
import visualra.ProjectFile;
import visualra.VisualRA;
import visualra.database.DBManager;
import visualra.database.DBManagerException;
import visualra.ra2sql.RAException;
import visualra.ra2sql.RANaturalJoin;
import visualra.ra2sql.RAOperator;
import visualra.ra2sql.RAProjection;
import visualra.ra2sql.RAQuery;
import visualra.ra2sql.RARename;
import visualra.ra2sql.RASelection;
import visualra.ra2sql.RAUnion;

public class Ascoltatori {
    private static final boolean EDIT_MODE = true;
    private static final boolean INSERT_MODE = false;
    private static final boolean UP_DIRECTION = true;
    private static final boolean DOWN_DIRECTION = false;
    private static final boolean LINK_LEFT = true;
    private static final boolean LINK_RIGHT = false;
    private GUI gui;
    private AscoltaFinestra ascoltaFinestra;
    private AscoltaExit ascoltaExit;
    private AscoltaNuovo ascoltaNuovo;
    private AscoltaApri ascoltaApri;
    private AscoltaModifica ascoltaModifica;
    private AscoltaHelp ascoltaHelp;
    private AscoltaTutorial ascoltaTutorial;
    private AscoltaDeleteQuery ascoltaDeleteQuery;
    private AscoltaSelezioneAlbero ascoltaSelezioneAlbero;
    private AscoltaSalvaConNome ascoltaSalvaConNome;
    private AscoltaSalva ascoltaSalva;
    private AscoltaTabelle ascoltaTabelle;
    private AscoltaSelezione ascoltaSelezione;
    private AscoltaProiezione ascoltaProiezione;
    private AscoltaRidenominazione ascoltaRidenominazione;
    private AscoltaSet ascoltaSet;
    private AscoltaJoin ascoltaJoin;
    private AscoltaSelezioneLog ascoltaSelezioneLog;
    private AscoltaQueryWindow ascoltaQueryWindow;
    private AscoltaComboLingua ascoltaComboLingua;
    private AscoltaItaliano ascoltaItaliano;
    private AscoltaInglese ascoltaInglese;
    private AscoltaAboutVisualra ascoltaAboutVisualra;
    private AscoltaCancellaAreaTesto ascoltaCancellaAreaTesto;
    private AscoltaInviaQuerySql ascoltaInviaQuerySql;
    private AscoltaEditorSQL ascoltaEditorSQL;
    private AscoltaInizializza ascoltaInizializza;
    private AscoltaSaveAsTable ascoltaSaveAsTable;
    OpNode selectedNode;

    public Ascoltatori(GUI g) {
        this.gui = g;
        this.ascoltaExit = new AscoltaExit();
        this.ascoltaFinestra = new AscoltaFinestra();
        this.ascoltaNuovo = new AscoltaNuovo();
        this.ascoltaApri = new AscoltaApri();
        this.ascoltaModifica = new AscoltaModifica();
        this.ascoltaHelp = new AscoltaHelp();
        this.ascoltaTutorial = new AscoltaTutorial();
        this.ascoltaDeleteQuery = new AscoltaDeleteQuery();
        this.ascoltaSelezioneAlbero = new AscoltaSelezioneAlbero();
        this.ascoltaSalva = new AscoltaSalva();
        this.ascoltaSalvaConNome = new AscoltaSalvaConNome();
        this.ascoltaTabelle = new AscoltaTabelle();
        this.ascoltaSelezione = new AscoltaSelezione();
        this.ascoltaProiezione = new AscoltaProiezione();
        this.ascoltaRidenominazione = new AscoltaRidenominazione();
        this.ascoltaSet = new AscoltaSet();
        this.ascoltaJoin = new AscoltaJoin();
        this.ascoltaSelezioneLog = new AscoltaSelezioneLog();
        this.ascoltaQueryWindow = new AscoltaQueryWindow();
        this.ascoltaComboLingua = new AscoltaComboLingua();
        this.ascoltaItaliano = new AscoltaItaliano();
        this.ascoltaInglese = new AscoltaInglese();
        this.ascoltaAboutVisualra = new AscoltaAboutVisualra();
        this.ascoltaCancellaAreaTesto = new AscoltaCancellaAreaTesto();
        this.ascoltaInviaQuerySql = new AscoltaInviaQuerySql();
        this.ascoltaEditorSQL = new AscoltaEditorSQL();
        this.ascoltaInizializza = new AscoltaInizializza();
        this.ascoltaSaveAsTable = new AscoltaSaveAsTable();
    }

    public void openStartingProject(String filename) {
        try {
            File file = new File(filename);
            ProjectFile projectFile = ProjectFile.load(file.getAbsolutePath());
            File checkedDBFile = new File(projectFile.getDBFileName());
            if (!checkedDBFile.exists()) {
                if (!(checkedDBFile = new File(checkedDBFile.getName())).exists()) {
                    throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_db_file_mancante"), true));
                }
                int n = JOptionPane.showConfirmDialog(new JFrame(), String.valueOf(Language.getInstance().getString("DB_cambiato_di_posizione_aggiornare_?")) + Language.getInstance().getString("Scegliendo_SI_il_progetto_viene_aggiorn_al_salvataggio"), Language.getInstance().getString("Attenzione"), 0, 3);
                if (n == 1 || n == -1) {
                    return;
                }
            }
            this.gui.dialogWindow.setTextVRA("");
            this.gui.logWindow.setTextVRA("");
            projectFile.setDBFileName(checkedDBFile.getAbsolutePath());
            DBManager.connect(projectFile.getDBDriver(), new File(projectFile.getDBFileName()), projectFile.getDBUrl(), projectFile.getDBTemptabPrefix());
            Project.setProjectFile(projectFile);
            this.gui.salvafile.setEnabled(true);
            this.gui.saveProject.setEnabled(true);
            this.gui.saveAsProject.setEnabled(true);
            this.gui.modificaNodo.setEnabled(true);
            this.gui.deleteQuery.setEnabled(true);
            this.gui.opUnario.setEnabled(true);
            this.gui.opBinario.setEnabled(true);
            this.gui.modificaOp.setEnabled(true);
            this.gui.eliminaOp.setEnabled(true);
            this.gui.saveAsTable.setEnabled(true);
            this.gui.queryWindow.setText("");
            this.gui.tabelleNodi.setModel(new DefaultTableModel(10, 6));
            this.gui.dialogWindow.setTextVRA(LogManager.prepareMsg(Language.getInstance().getString("Il_programma_\u00e8_connesso_al_Database..."), false));
            this.gui.logWindow.setTextVRA(LogManager.prepareMsg(Language.getInstance().getString("Il_programma_\u00e8_connesso_al_Database..."), false));
            this.gui.setTitle(String.valueOf(Language.getInstance().getString("versione")) + " - " + Project.getTitle());
            this.gui.tabellaDB.removeAll();
            TreeSet dbTables = DBManager.getTables();
            Iterator itr = dbTables.iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                this.gui.tabellaDB.addTab(name, null);
                this.gui.tabellaDB.setComponentAt(0, this.gui.panTabelleDB);
            }
            if (Project.isLoaded()) {
                this.gui.semaforo.setVerde();
                RAQuery.executeQuery();
            }
        }
        catch (DBManagerException dbmex) {
            if (dbmex.isRACaused()) {
                this.gui.semaforo.setRosso();
            }
            this.gui.dialogWindow.append(dbmex.getMessage());
            this.gui.logWindow.append(dbmex.getMessage());
        }
        catch (RAException raex) {
            this.gui.semaforo.setRosso();
            this.gui.dialogWindow.append(raex.getMessage());
        }
        this.gui.albero.setModel(Project.getTree());
        this.gui.albero.repaint();
        this.expand((OpNode)Project.getTree().getRoot());
    }

    private void showNodeTab(OpNode node) {
        CachedResultSetTableModel nodeTableModel = node.getOp().getCRS();
        if (nodeTableModel != null) {
            this.gui.tabelleNodi.setModel(nodeTableModel);
            this.gui.labContaRigheTab.setText("<html><b><font color=blue>" + nodeTableModel.getRowCount() + "</font></b>");
        }
    }

    private void insertUnaryNode(int opType) {
        block44: {
            try {
                if (DBManager.connected()) {
                    boolean direction;
                    if (!Project.isLoaded()) {
                        String tab = (String)DBManager.getTables().first();
                        RAOperator opNew = null;
                        switch (opType) {
                            case 0: {
                                String[] cond1 = new String[]{};
                                opNew = new RASelection(cond1, tab);
                                break;
                            }
                            case 1: {
                                String[] fieldsPrj = new String[]{""};
                                opNew = new RAProjection(fieldsPrj, tab);
                                break;
                            }
                            case 2: {
                                String[] fieldsRen = new String[]{};
                                opNew = new RARename(fieldsRen, tab);
                            }
                        }
                        OpNode root = new OpNode(null, opNew);
                        DefaultTreeModel newTreeModel = new DefaultTreeModel(root);
                        Project.setTree(newTreeModel);
                        this.gui.albero.setModel(newTreeModel);
                        this.gui.albero.setSelectionPath(new TreePath(root));
                        this.editSelectedNode();
                        if (((OpNode)Project.getTree().getRoot()).getOp() != null) {
                            Project.setLoaded(true);
                            this.gui.salvafile.setEnabled(true);
                            this.gui.saveProject.setEnabled(true);
                            this.gui.saveAsProject.setEnabled(true);
                            this.gui.modificaNodo.setEnabled(true);
                            this.gui.deleteQuery.setEnabled(true);
                            try {
                                OpNode newRoot = (OpNode)Project.getTree().getRoot();
                                this.gui.semaforo.setVerde();
                                RAQuery.executeQueryFromNode(newRoot);
                                this.showNodeTab(newRoot);
                                this.gui.queryWindow.setText(RAQuery.getRAQueryFromNode(newRoot));
                            }
                            catch (DBManagerException dbmex) {
                                if (dbmex.isRACaused()) {
                                    this.gui.semaforo.setRosso();
                                }
                                this.gui.dialogWindow.append(dbmex.getMessage());
                            }
                            catch (RAException raex) {
                                this.gui.semaforo.setRosso();
                                this.gui.dialogWindow.append(raex.getMessage());
                            }
                        } else {
                            Project.clearTree();
                            this.gui.albero.setModel(Project.getTree());
                        }
                        break block44;
                    }
                    this.selectedNode = (OpNode)this.gui.albero.getLastSelectedPathComponent();
                    if (this.selectedNode == null) {
                        return;
                    }
                    OpNode parent = (OpNode)this.selectedNode.getParent();
                    OpNode[] childs = null;
                    int selectedNodePosition = -1;
                    if (parent != null) {
                        selectedNodePosition = parent.getIndex(this.selectedNode);
                    }
                    OpNode newNode = new OpNode(null, null);
                    if (this.selectedNode.getChildCount() == 2 && this.selectedNode.getOp().getArgSize() == 2 || this.selectedNode.getChildCount() == 1 && this.selectedNode.getOp().getArgSize() == 1) {
                        direction = true;
                    } else {
                        JFrame frame = new JFrame();
                        Object[] options = new Object[]{Language.getInstance().getString("Nuovo_nodo_sopra"), Language.getInstance().getString("Nuovo_nodo_sotto")};
                        int answer = JOptionPane.showOptionDialog(frame, Language.getInstance().getString("Scegliere_posizione_per_aggiungere_nuovo_nodo"), Language.getInstance().getString("Scelta_posizione"), -1, 3, null, options, options[0]);
                        direction = answer == 0;
                        if (answer == -1) {
                            return;
                        }
                    }
                    switch (opType) {
                        case 0: {
                            new SelectionOperatorDialog(this.selectedNode, newNode, false, direction, Project.isLoaded(), this.gui);
                            break;
                        }
                        case 1: {
                            new ProjectionOperatorDialog(this.selectedNode, newNode, false, direction, Project.isLoaded(), this.gui);
                            break;
                        }
                        case 2: {
                            new RenameOperatorDialog(this.selectedNode, newNode, false, direction, Project.isLoaded(), this.gui);
                        }
                    }
                    if (newNode.getOp() == null) {
                        return;
                    }
                    if (direction) {
                        if (parent != null) {
                            parent.remove(this.selectedNode);
                            parent.insert(newNode, selectedNodePosition);
                            newNode.add(this.selectedNode);
                        } else {
                            Project.getTree().setRoot(newNode);
                            newNode.add(this.selectedNode);
                        }
                    } else {
                        String[] newParentTables = new String[2];
                        if (this.selectedNode.getOp().isLastOp()) {
                            if (this.selectedNode.getOp().getArgSize() == 1) {
                                newParentTables[0] = null;
                                newParentTables[1] = null;
                                this.selectedNode.insert(newNode, 0);
                                this.selectedNode.getOp().setTables(newParentTables);
                            } else {
                                JFrame frame = new JFrame();
                                Object[] options = new Object[]{Language.getInstance().getString("sinistra"), Language.getInstance().getString("destra")};
                                int answer = JOptionPane.showOptionDialog(frame, Language.getInstance().getString("Scegliere_posizione_destra_sinistra_sotto"), Language.getInstance().getString("Scelta_posizione"), -1, 3, null, options, options[0]);
                                if (answer == -1) {
                                    return;
                                }
                                if (answer == 0) {
                                    newParentTables[0] = null;
                                    newParentTables[1] = this.selectedNode.getOp().getTables()[1];
                                    this.selectedNode.insert(newNode, 0);
                                    this.selectedNode.getOp().setTables(newParentTables);
                                } else {
                                    newParentTables[0] = this.selectedNode.getOp().getTables()[0];
                                    newParentTables[1] = null;
                                    this.selectedNode.insert(newNode, 0);
                                    this.selectedNode.getOp().setTables(newParentTables);
                                }
                            }
                        } else if (this.selectedNode.getOp().isLastOpLeft()) {
                            newParentTables[0] = null;
                            newParentTables[1] = null;
                            OpNode otherChildNode = (OpNode)this.selectedNode.getChildAt(0);
                            this.selectedNode.insert(newNode, 0);
                            this.selectedNode.add(otherChildNode);
                            this.selectedNode.getOp().setTables(newParentTables);
                        } else {
                            newParentTables[0] = null;
                            newParentTables[1] = null;
                            this.selectedNode.add(newNode);
                            this.selectedNode.getOp().setTables(newParentTables);
                        }
                    }
                    this.selectedNode.setLabel("<html>" + this.selectedNode.getOp().toString());
                    Project.getTree().reload(this.selectedNode);
                    Project.getTree().reload(newNode);
                    this.expand((OpNode)Project.getTree().getRoot());
                    try {
                        this.gui.semaforo.setVerde();
                        RAQuery.executeQueryFromNode((OpNode)Project.getTree().getRoot());
                        this.showNodeTab(newNode);
                        this.gui.queryWindow.setText(RAQuery.getRAQueryFromNode(newNode));
                    }
                    catch (DBManagerException dbmex) {
                        if (dbmex.isRACaused()) {
                            this.gui.semaforo.setRosso();
                        }
                        this.gui.dialogWindow.append(dbmex.getMessage());
                    }
                    catch (RAException raex) {
                        this.gui.semaforo.setRosso();
                        this.gui.dialogWindow.append(raex.getMessage());
                    }
                    this.gui.albero.repaint();
                    break block44;
                }
                JOptionPane.showMessageDialog(null, Language.getInstance().getString("Programma_non_connesso_a_nessun_DataBase"), Language.getInstance().getString("Errore_Connessione"), 0);
                return;
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    this.gui.semaforo.setRosso();
                }
                this.gui.dialogWindow.append(dbmex.getMessage());
            }
        }
    }

    private void insertBinaryNode(int opType) {
        block44: {
            try {
                if (DBManager.connected()) {
                    boolean direction;
                    if (!Project.isLoaded()) {
                        TreeSet tables = DBManager.getTables();
                        String tabLeft = (String)tables.first();
                        String tabRight = (String)tables.first();
                        RAOperator opNew = null;
                        switch (opType) {
                            case 3: {
                                opNew = new RAUnion(tabLeft, tabRight);
                                break;
                            }
                            case 6: {
                                opNew = new RANaturalJoin(tabLeft, tabRight);
                            }
                        }
                        OpNode root = new OpNode(null, opNew);
                        DefaultTreeModel newTreeModel = new DefaultTreeModel(root);
                        Project.setTree(newTreeModel);
                        this.gui.albero.setModel(newTreeModel);
                        this.gui.albero.setSelectionPath(new TreePath(root));
                        this.editSelectedNode();
                        if (((OpNode)Project.getTree().getRoot()).getOp() != null) {
                            Project.setLoaded(true);
                            this.gui.salvafile.setEnabled(true);
                            this.gui.saveProject.setEnabled(true);
                            this.gui.saveAsProject.setEnabled(true);
                            this.gui.modificaNodo.setEnabled(true);
                            this.gui.deleteQuery.setEnabled(true);
                            try {
                                OpNode newRoot = (OpNode)Project.getTree().getRoot();
                                this.gui.semaforo.setVerde();
                                RAQuery.executeQueryFromNode(newRoot);
                                this.showNodeTab(newRoot);
                                this.gui.queryWindow.setText(RAQuery.getRAQueryFromNode(newRoot));
                            }
                            catch (DBManagerException dbmex) {
                                if (dbmex.isRACaused()) {
                                    this.gui.semaforo.setRosso();
                                }
                                this.gui.dialogWindow.append(dbmex.getMessage());
                            }
                            catch (RAException raex) {
                                this.gui.semaforo.setRosso();
                                this.gui.dialogWindow.append(raex.getMessage());
                            }
                        } else {
                            Project.clearTree();
                            this.gui.albero.setModel(Project.getTree());
                        }
                        break block44;
                    }
                    this.selectedNode = (OpNode)this.gui.albero.getLastSelectedPathComponent();
                    if (this.selectedNode == null) {
                        return;
                    }
                    OpNode parent = (OpNode)this.selectedNode.getParent();
                    OpNode[] childs = null;
                    int selectedNodePosition = -1;
                    if (parent != null) {
                        selectedNodePosition = parent.getIndex(this.selectedNode);
                    }
                    OpNode newNode = new OpNode(null, null);
                    if (this.selectedNode.getChildCount() == 2 && this.selectedNode.getOp().getArgSize() == 2 || this.selectedNode.getChildCount() == 1 && this.selectedNode.getOp().getArgSize() == 1) {
                        direction = true;
                    } else {
                        JFrame frame = new JFrame();
                        Object[] options = new Object[]{Language.getInstance().getString("Nuovo_nodo_sopra"), Language.getInstance().getString("Nuovo_nodo_sotto")};
                        int answer = JOptionPane.showOptionDialog(frame, Language.getInstance().getString("Scegliere_posizione_per_aggiungere_nuovo_nodo"), Language.getInstance().getString("Scelta_posizione"), -1, 3, null, options, options[0]);
                        direction = answer == 0;
                        if (answer == -1) {
                            return;
                        }
                    }
                    boolean selectedNodeLinkPosition = true;
                    if (direction) {
                        JFrame frame = new JFrame();
                        Object[] options = new Object[]{Language.getInstance().getString("sinistra"), Language.getInstance().getString("destra")};
                        int answer = JOptionPane.showOptionDialog(frame, Language.getInstance().getString("Scegliere_posizione_destra_sinistra_sopra"), Language.getInstance().getString("Scelta_posizione"), -1, 3, null, options, options[0]);
                        if (answer == -1) {
                            return;
                        }
                        selectedNodeLinkPosition = answer == 0;
                    }
                    switch (opType) {
                        case 3: {
                            new SetOperatorDialog(this.selectedNode, newNode, false, direction, selectedNodeLinkPosition, Project.isLoaded(), this.gui);
                            break;
                        }
                        case 6: {
                            new JoinOperatorDialog(this.selectedNode, newNode, false, direction, selectedNodeLinkPosition, Project.isLoaded(), this.gui);
                        }
                    }
                    if (newNode.getOp() == null) {
                        return;
                    }
                    if (direction) {
                        if (parent != null) {
                            parent.remove(this.selectedNode);
                            parent.insert(newNode, selectedNodePosition);
                            newNode.add(this.selectedNode);
                        } else {
                            Project.getTree().setRoot(newNode);
                            newNode.add(this.selectedNode);
                        }
                    } else {
                        String[] newParentTables = new String[2];
                        if (this.selectedNode.getOp().isLastOp()) {
                            if (this.selectedNode.getOp().getArgSize() == 1) {
                                newParentTables[0] = null;
                                newParentTables[1] = null;
                                this.selectedNode.insert(newNode, 0);
                                this.selectedNode.getOp().setTables(newParentTables);
                            } else {
                                JFrame frame = new JFrame();
                                Object[] options = new Object[]{Language.getInstance().getString("sinistra"), Language.getInstance().getString("destra")};
                                int answer = JOptionPane.showOptionDialog(frame, Language.getInstance().getString("Scegliere_posizione_destra_sinistra_sotto"), Language.getInstance().getString("Scelta_posizione"), -1, 3, null, options, options[0]);
                                if (answer == -1) {
                                    return;
                                }
                                if (answer == 0) {
                                    newParentTables[0] = null;
                                    newParentTables[1] = this.selectedNode.getOp().getTables()[1];
                                    this.selectedNode.insert(newNode, 0);
                                    this.selectedNode.getOp().setTables(newParentTables);
                                } else {
                                    newParentTables[0] = this.selectedNode.getOp().getTables()[0];
                                    newParentTables[1] = null;
                                    this.selectedNode.insert(newNode, 0);
                                    this.selectedNode.getOp().setTables(newParentTables);
                                }
                            }
                        } else if (this.selectedNode.getOp().isLastOpLeft()) {
                            newParentTables[0] = null;
                            newParentTables[1] = null;
                            OpNode otherChildNode = (OpNode)this.selectedNode.getChildAt(0);
                            this.selectedNode.insert(newNode, 0);
                            this.selectedNode.add(otherChildNode);
                            this.selectedNode.getOp().setTables(newParentTables);
                        } else {
                            newParentTables[0] = null;
                            newParentTables[1] = null;
                            this.selectedNode.add(newNode);
                            this.selectedNode.getOp().setTables(newParentTables);
                        }
                    }
                    this.selectedNode.setLabel("<html>" + this.selectedNode.getOp().toString());
                    Project.getTree().reload(this.selectedNode);
                    Project.getTree().reload(newNode);
                    this.expand((OpNode)Project.getTree().getRoot());
                    try {
                        this.gui.semaforo.setVerde();
                        RAQuery.executeQueryFromNode((OpNode)Project.getTree().getRoot());
                        this.showNodeTab(newNode);
                        this.gui.queryWindow.setText(RAQuery.getRAQueryFromNode(newNode));
                    }
                    catch (DBManagerException dbmex) {
                        if (dbmex.isRACaused()) {
                            this.gui.semaforo.setRosso();
                        }
                        this.gui.dialogWindow.append(dbmex.getMessage());
                    }
                    catch (RAException raex) {
                        this.gui.semaforo.setRosso();
                        this.gui.dialogWindow.append(raex.getMessage());
                    }
                    this.gui.albero.repaint();
                    break block44;
                }
                JOptionPane.showMessageDialog(null, Language.getInstance().getString("Programma_non_connesso_a_nessun_DataBase"), Language.getInstance().getString("Errore_Connessione"), 0);
                return;
            }
            catch (DBManagerException dbmex) {
                if (dbmex.isRACaused()) {
                    this.gui.semaforo.setRosso();
                }
                this.gui.dialogWindow.append(dbmex.getMessage());
            }
        }
    }

    private void editSelectedNode() {
        this.selectedNode = (OpNode)this.gui.albero.getLastSelectedPathComponent();
        if (this.selectedNode == null) {
            return;
        }
        OpNode parent = (OpNode)this.selectedNode.getParent();
        OpNode[] childs = null;
        if (this.selectedNode.getChildCount() == 1) {
            childs = new OpNode[]{(OpNode)this.selectedNode.getChildAt(0)};
        } else if (this.selectedNode.getChildCount() == 2) {
            childs = new OpNode[]{(OpNode)this.selectedNode.getChildAt(0), (OpNode)this.selectedNode.getChildAt(1)};
        }
        int opType = this.selectedNode.getOp().getType();
        int selectedNodePosition = -1;
        if (parent != null) {
            selectedNodePosition = parent.getIndex(this.selectedNode);
        }
        OpNode newNode = new OpNode(null, null);
        switch (opType) {
            case 0: {
                new SelectionOperatorDialog(this.selectedNode, newNode, true, false, Project.isLoaded(), this.gui);
                break;
            }
            case 1: {
                new ProjectionOperatorDialog(this.selectedNode, newNode, true, false, Project.isLoaded(), this.gui);
                break;
            }
            case 2: {
                new RenameOperatorDialog(this.selectedNode, newNode, true, false, Project.isLoaded(), this.gui);
                break;
            }
            case 7: {
                new JoinOperatorDialog(this.selectedNode, newNode, true, false, true, Project.isLoaded(), this.gui);
                break;
            }
            case 10: {
                new JoinOperatorDialog(this.selectedNode, newNode, true, false, true, Project.isLoaded(), this.gui);
                break;
            }
            case 8: {
                new JoinOperatorDialog(this.selectedNode, newNode, true, false, true, Project.isLoaded(), this.gui);
                break;
            }
            case 9: {
                new JoinOperatorDialog(this.selectedNode, newNode, true, false, true, Project.isLoaded(), this.gui);
                break;
            }
            case 6: {
                new JoinOperatorDialog(this.selectedNode, newNode, true, false, true, Project.isLoaded(), this.gui);
                break;
            }
            case 3: {
                new SetOperatorDialog(this.selectedNode, newNode, true, false, true, Project.isLoaded(), this.gui);
                break;
            }
            case 4: {
                new SetOperatorDialog(this.selectedNode, newNode, true, false, true, Project.isLoaded(), this.gui);
                break;
            }
            case 5: {
                new SetOperatorDialog(this.selectedNode, newNode, true, false, true, Project.isLoaded(), this.gui);
            }
        }
        if (parent != null) {
            parent.remove(this.selectedNode);
            this.selectedNode = newNode;
            parent.insert(this.selectedNode, selectedNodePosition);
        } else {
            this.selectedNode = newNode;
            Project.getTree().setRoot(this.selectedNode);
        }
        if (childs != null) {
            int i = 0;
            while (i < childs.length) {
                this.selectedNode.add(childs[i]);
                ++i;
            }
        }
        Project.getTree().reload(this.selectedNode);
        this.gui.albero.setSelectionPath(new TreePath(this.selectedNode));
        try {
            if (Project.isLoaded()) {
                this.gui.semaforo.setVerde();
                RAQuery.executeQueryFromNode((OpNode)Project.getTree().getRoot());
            }
        }
        catch (DBManagerException dbmex) {
            if (dbmex.isRACaused()) {
                this.gui.semaforo.setRosso();
            }
            this.gui.dialogWindow.append(dbmex.getMessage());
        }
        catch (RAException raex) {
            this.gui.semaforo.setRosso();
            this.gui.dialogWindow.append(raex.getMessage());
        }
        this.gui.albero.repaint();
    }

    private void expand(OpNode node) {
        if (!node.isLeaf()) {
            int i = 0;
            while (i < node.getChildCount()) {
                this.expand((OpNode)node.getChildAt(i));
                ++i;
            }
        } else {
            this.gui.albero.scrollPathToVisible(new TreePath(node.getPath()));
        }
    }

    public AscoltaEditorSQL getAscoltaEditorSQL() {
        return this.ascoltaEditorSQL;
    }

    public AscoltaCancellaAreaTesto getAscoltaCancellaAreaTesto() {
        return this.ascoltaCancellaAreaTesto;
    }

    public AscoltaInviaQuerySql getAscoltaInviaQuerySql() {
        return this.ascoltaInviaQuerySql;
    }

    public AscoltaInizializza getAscoltaInizializza() {
        return this.ascoltaInizializza;
    }

    public AscoltaFinestra getAscoltaFinestra() {
        return this.ascoltaFinestra;
    }

    public AscoltaExit getAscoltaExit() {
        return this.ascoltaExit;
    }

    public AscoltaNuovo getAscoltaNuovo() {
        return this.ascoltaNuovo;
    }

    public AscoltaApri getAscoltaApri() {
        return this.ascoltaApri;
    }

    public AscoltaModifica getAscoltaModifica() {
        return this.ascoltaModifica;
    }

    public AscoltaHelp getAscoltaHelp() {
        return this.ascoltaHelp;
    }

    public AscoltaTutorial getAscoltaTutorial() {
        return this.ascoltaTutorial;
    }

    public AscoltaDeleteQuery getAscoltaDeleteQuery() {
        return this.ascoltaDeleteQuery;
    }

    public AscoltaSelezioneAlbero getAscoltaSelezioneAlbero() {
        return this.ascoltaSelezioneAlbero;
    }

    public AscoltaSalva getAscoltaSalva() {
        return this.ascoltaSalva;
    }

    public AscoltaSalvaConNome getAscoltaSalvaConNome() {
        return this.ascoltaSalvaConNome;
    }

    public AscoltaTabelle getAscoltaTabelle() {
        return this.ascoltaTabelle;
    }

    public AscoltaSelezione getAscoltaSelezione() {
        return this.ascoltaSelezione;
    }

    public AscoltaProiezione getAscoltaProiezione() {
        return this.ascoltaProiezione;
    }

    public AscoltaRidenominazione getAscoltaRidenominazione() {
        return this.ascoltaRidenominazione;
    }

    public AscoltaSet getAscoltaSet() {
        return this.ascoltaSet;
    }

    public AscoltaJoin getAscoltaJoin() {
        return this.ascoltaJoin;
    }

    public AscoltaSelezioneLog getAscoltaSelezioneLog() {
        return this.ascoltaSelezioneLog;
    }

    public AscoltaQueryWindow getAscoltaQueryWindow() {
        return this.ascoltaQueryWindow;
    }

    public AscoltaComboLingua getAscoltaComboLingua() {
        return this.ascoltaComboLingua;
    }

    public AscoltaItaliano getAscoltaItaliano() {
        return this.ascoltaItaliano;
    }

    public AscoltaInglese getAscoltaInglese() {
        return this.ascoltaInglese;
    }

    public AscoltaAboutVisualra getAscoltaAboutVisualra() {
        return this.ascoltaAboutVisualra;
    }

    public AscoltaSaveAsTable getAscoltaSaveAsTable() {
        return this.ascoltaSaveAsTable;
    }

    private void cambiaLingua() {
        try {
            Properties pr = new Properties();
            FileOutputStream out = new FileOutputStream("Preferences");
            ((Hashtable)pr).put("lingua", this.gui.linguaDefault);
            pr.store(out, null);
            out.close();
        }
        catch (FileNotFoundException fnfex) {
            System.out.println(fnfex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        JFrame frame = new JFrame();
        JOptionPane.showMessageDialog(frame, "Le modifiche avranno effetto solo al prossimo avvio dell'applicazione\nChanges will have effect after the next program's run", "Attenzione/Warning", 2);
    }

    public void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.gui.popUpMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void maybeShowPopup1(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.gui.popUpMenu1.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void maybeShowPopupQuery(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.gui.popUpMenuQuery.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class AscoltaEditorSQL
    implements ActionListener,
    MouseListener {
        AscoltaEditorSQL() {
        }

        public void actionPerformed(ActionEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 3) {
                ((Ascoltatori)Ascoltatori.this).gui.helpItemEditor.setName("help41.html");
                Ascoltatori.this.maybeShowPopup1(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }
    }

    private class AscoltaCancellaAreaTesto
    implements ActionListener {
        AscoltaCancellaAreaTesto() {
        }

        public void actionPerformed(ActionEvent e) {
            ((Ascoltatori)Ascoltatori.this).gui.editorSql.setText("");
            ((Ascoltatori)Ascoltatori.this).gui.tabellaQuery.setModel(new DefaultTableModel(10, 6));
            ((Ascoltatori)Ascoltatori.this).gui.labContaRighe.setText("");
        }
    }

    private class AscoltaInviaQuerySql
    implements ActionListener {
        String querySql;

        AscoltaInviaQuerySql() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (DBManager.connected()) {
                    boolean b;
                    String select = new String();
                    this.querySql = ((Ascoltatori)Ascoltatori.this).gui.editorSql.getText();
                    char[] parola = this.querySql.toCharArray();
                    if (parola.length >= 7) {
                        int i = 0;
                        while (i < 7) {
                            select = String.valueOf(select) + String.valueOf(parola[i]);
                            ++i;
                        }
                    }
                    if (b = select.equalsIgnoreCase("SELECT ")) {
                        this.esegueSelect();
                    } else {
                        this.showError();
                    }
                } else {
                    this.showErrorConnection();
                }
            }
            catch (DBManagerException dbmex) {
                ((Ascoltatori)Ascoltatori.this).gui.logWindow.append(dbmex.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException error) {
                this.showError();
            }
        }

        private void esegueSelect() {
            DBManager db = new DBManager();
            try {
                ResultSet rs = DBManager.executeQuery(this.querySql);
                CachedResultSetTableModel crs = new CachedResultSetTableModel(rs);
                ((Ascoltatori)Ascoltatori.this).gui.tabellaQuery.setModel(crs);
                ((Ascoltatori)Ascoltatori.this).gui.labContaRighe.setText("<html><b><font color=blue>" + crs.getRowCount() + "</font></b>");
            }
            catch (DBManagerException dbmex) {
                ((Ascoltatori)Ascoltatori.this).gui.logWindow.append(dbmex.getMessage());
            }
        }

        private void showErrorConnection() {
            JOptionPane.showMessageDialog(null, Language.getInstance().getString("Programma_non_connesso_a_nessun_DataBase"), Language.getInstance().getString("Errore_Connessione"), 0);
        }

        private void showError() {
            JOptionPane.showMessageDialog(null, Language.getInstance().getString("Occorre_scrivere_una_query"), Language.getInstance().getString("Errore"), 2);
        }
    }

    private class AscoltaInizializza
    implements ActionListener {
        AscoltaInizializza() {
        }

        public void actionPerformed(ActionEvent e) {
            ((Ascoltatori)Ascoltatori.this).gui.editorSql.setText("SELECT (  ) FROM (  )");
        }
    }

    private class AscoltaComboLingua
    implements ActionListener {
        AscoltaComboLingua() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            ((Ascoltatori)Ascoltatori.this).gui.linguaDefault = (String)cb.getSelectedItem();
            Ascoltatori.this.cambiaLingua();
        }
    }

    private class AscoltaItaliano
    implements ActionListener {
        AscoltaItaliano() {
        }

        public void actionPerformed(ActionEvent e) {
            ((Ascoltatori)Ascoltatori.this).gui.linguaDefault = "Italiano";
            Ascoltatori.this.cambiaLingua();
        }
    }

    private class AscoltaInglese
    implements ActionListener {
        AscoltaInglese() {
        }

        public void actionPerformed(ActionEvent e) {
            ((Ascoltatori)Ascoltatori.this).gui.linguaDefault = "Inglese";
            Ascoltatori.this.cambiaLingua();
        }
    }

    private class AscoltaFinestra
    extends WindowAdapter {
        AscoltaFinestra() {
        }

        public void windowClosing(WindowEvent e) {
            JFrame frame;
            int n;
            if (Project.isLoaded() && (n = JOptionPane.showConfirmDialog(frame = new JFrame(), String.valueOf(Language.getInstance().getString("Salvare_modifiche_apportate_al_progetto_corrente_?")) + Language.getInstance().getString("Scegliendo_NO_tutte_modifiche_andranno_perse_!"), Language.getInstance().getString("Attenzione"), 0, 3)) == 0) {
                ProjectFile.save(Project.getProjectFile());
            }
            this.esci();
        }

        private void esci() {
            try {
                DBManager.disconnect();
            }
            catch (DBManagerException er) {
                ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.setTextVRA(Language.getInstance().getString("Errore_nella_disconnessione_dal_database"));
            }
            VisualRA.saveConfigSettings();
            System.exit(0);
        }
    }

    public class AscoltaExit
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (!Project.isLoaded()) {
                JFrame frame = new JFrame();
                int n = JOptionPane.showConfirmDialog(frame, Language.getInstance().getString("Vuoi_Uscire_davvero?"), Language.getInstance().getString("Conferma_uscita"), 2);
                if (n == 0) {
                    this.esci();
                }
            } else {
                JFrame frame = new JFrame();
                int n = JOptionPane.showConfirmDialog(frame, String.valueOf(Language.getInstance().getString("Salvare_modifiche_apportate_al_progetto_corrente_?")) + Language.getInstance().getString("Scegliendo_NO_tutte_modifiche_andranno_perse_!"), Language.getInstance().getString("Attenzione"), 1, 3);
                if (n == 0) {
                    ProjectFile.save(Project.getProjectFile());
                    this.esci();
                } else if (n == 1) {
                    this.esci();
                }
            }
        }

        private void esci() {
            try {
                DBManager.disconnect();
            }
            catch (DBManagerException er) {
                ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.setTextVRA(Language.getInstance().getString("Errore_nella_disconnessione_dal_database"));
            }
            VisualRA.saveConfigSettings();
            System.exit(0);
        }
    }

    private class AscoltaHelp
    implements ActionListener {
        AscoltaHelp() {
        }

        public void actionPerformed(ActionEvent e) {
            ((Ascoltatori)Ascoltatori.this).gui.paginaHelp = ((Component)e.getSource()).getName();
            Ascoltatori.this.gui.showHelp(Ascoltatori.this.gui, null, ((Ascoltatori)Ascoltatori.this).gui.paginaHelp);
        }
    }

    private class AscoltaTutorial
    implements ActionListener {
        AscoltaTutorial() {
        }

        public void actionPerformed(ActionEvent e) {
            Ascoltatori.this.gui.showTutorial(Ascoltatori.this.gui, null);
        }
    }

    private class AscoltaAboutVisualra
    implements ActionListener {
        AscoltaAboutVisualra() {
        }

        public void actionPerformed(ActionEvent e) {
            ImageIcon aboutImage = new ImageIcon("images/about.jpg");
            JOptionPane.showMessageDialog(Ascoltatori.this.gui, String.valueOf(Language.getInstance().getString("versione")) + Language.getInstance().getString("Ultima_Modifica") + Language.getInstance().getString("Realizzato_da") + Language.getInstance().getString("Realizzatori"), Language.getInstance().getString("Info_VisualRA"), 1, aboutImage);
        }
    }

    private class AscoltaDeleteQuery
    implements ActionListener {
        AscoltaDeleteQuery() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent e) {
            JFrame frame;
            if (!Project.isLoaded()) return;
            OpNode selectedNode = (OpNode)((Ascoltatori)Ascoltatori.this).gui.albero.getLastSelectedPathComponent();
            if (selectedNode == null) {
                JOptionPane.showMessageDialog(null, Language.getInstance().getString("Occorre_selezionare_un_nodo_per_eliminarlo"), Language.getInstance().getString("Errore"), 2);
                return;
            }
            OpNode parent = (OpNode)selectedNode.getParent();
            OpNode[] childs = null;
            if (selectedNode.getChildCount() == 1) {
                childs = new OpNode[]{(OpNode)selectedNode.getChildAt(0)};
            } else if (selectedNode.getChildCount() == 2) {
                childs = new OpNode[]{(OpNode)selectedNode.getChildAt(0), (OpNode)selectedNode.getChildAt(1)};
            }
            int selectedNodePosition = -1;
            if (parent != null) {
                selectedNodePosition = parent.getIndex(selectedNode);
            }
            if (selectedNode.getOp().getArgSize() == 1) {
                if (selectedNode.isRoot()) {
                    if (selectedNode.getOp().isLastOp()) {
                        ((Ascoltatori)Ascoltatori.this).gui.queryWindow.setText("");
                        ((Ascoltatori)Ascoltatori.this).gui.tabelleNodi.setModel(new DefaultTableModel(10, 6));
                        ((Ascoltatori)Ascoltatori.this).gui.salvafile.setEnabled(false);
                        ((Ascoltatori)Ascoltatori.this).gui.saveProject.setEnabled(false);
                        ((Ascoltatori)Ascoltatori.this).gui.saveAsProject.setEnabled(false);
                        ((Ascoltatori)Ascoltatori.this).gui.modificaNodo.setEnabled(false);
                        ((Ascoltatori)Ascoltatori.this).gui.deleteQuery.setEnabled(false);
                        Project.clearTree();
                        System.out.println("con 1\n");
                    } else {
                        ((OpNode)selectedNode.getChildAt(0)).setParent(null);
                        Project.getTree().setRoot((OpNode)selectedNode.getChildAt(0));
                    }
                } else if (selectedNode.getOp().isLastOp()) {
                    String[] tablesSelectedNode = selectedNode.getOp().getTables();
                    String[] tablesParent = parent.getOp().getTables();
                    if (parent.getOp().isLastOpLeft()) {
                        tablesParent[1] = tablesSelectedNode[0];
                    } else if (parent.getOp().isLastOpRight()) {
                        tablesParent[0] = tablesSelectedNode[0];
                    } else {
                        tablesParent[selectedNodePosition] = tablesSelectedNode[0];
                    }
                    parent.remove(selectedNode);
                    parent.getOp().setTables(tablesParent);
                    parent.setLabel("<html>" + parent.getOp().toString());
                } else {
                    parent.remove(selectedNode);
                    parent.insert((OpNode)selectedNode.getChildAt(0), selectedNodePosition);
                }
            } else if (selectedNode.isRoot()) {
                if (selectedNode.getOp().isLastOp()) {
                    ((Ascoltatori)Ascoltatori.this).gui.queryWindow.setText("");
                    ((Ascoltatori)Ascoltatori.this).gui.tabelleNodi.setModel(new DefaultTableModel(10, 6));
                    ((Ascoltatori)Ascoltatori.this).gui.salvafile.setEnabled(false);
                    ((Ascoltatori)Ascoltatori.this).gui.saveProject.setEnabled(false);
                    ((Ascoltatori)Ascoltatori.this).gui.saveAsProject.setEnabled(false);
                    ((Ascoltatori)Ascoltatori.this).gui.modificaNodo.setEnabled(false);
                    ((Ascoltatori)Ascoltatori.this).gui.deleteQuery.setEnabled(false);
                    Project.clearTree();
                    System.out.println("con 2\n");
                } else if (selectedNode.getOp().isLastOpLeft()) {
                    ((OpNode)selectedNode.getChildAt(0)).setParent(null);
                    Project.getTree().setRoot((OpNode)selectedNode.getChildAt(0));
                } else if (selectedNode.getOp().isLastOpRight()) {
                    ((OpNode)selectedNode.getChildAt(0)).setParent(null);
                    Project.getTree().setRoot((OpNode)selectedNode.getChildAt(0));
                } else {
                    frame = new JFrame();
                    Object[] options = new Object[]{Language.getInstance().getString("sinistro"), Language.getInstance().getString("destro")};
                    int answer = JOptionPane.showOptionDialog(frame, Language.getInstance().getString("Scegliere_quale_dei_due_figli_del_nodo_rendere_nuova_radice_dell'albero"), Language.getInstance().getString("Scelta_nodo"), -1, 3, null, options, options[0]);
                    if (answer == 0) {
                        ((OpNode)selectedNode.getChildAt(0)).setParent(null);
                        Project.getTree().setRoot((OpNode)selectedNode.getChildAt(0));
                    } else {
                        if (answer != 1) return;
                        ((OpNode)selectedNode.getChildAt(1)).setParent(null);
                        Project.getTree().setRoot((OpNode)selectedNode.getChildAt(1));
                    }
                }
            } else {
                frame = new JFrame();
                Object[] options = new Object[]{Language.getInstance().getString("sinistro"), Language.getInstance().getString("destro")};
                int scelta = JOptionPane.showOptionDialog(frame, Language.getInstance().getString("Scegliere_quale_dei_due_operandi_del_nodo_collegare_al_nodo_genitore"), Language.getInstance().getString("Scelta_nodo/tabella"), -1, 3, null, options, options[0]);
                if (scelta == 0) {
                    if (selectedNode.getOp().isLastOp()) {
                        String[] tablesSelectedNode = selectedNode.getOp().getTables();
                        String[] tablesParent = parent.getOp().getTables();
                        if (parent.getOp().isLastOpLeft()) {
                            tablesParent[1] = tablesSelectedNode[0];
                        } else if (parent.getOp().isLastOpRight()) {
                            tablesParent[0] = tablesSelectedNode[0];
                        } else {
                            tablesParent[selectedNodePosition] = tablesSelectedNode[0];
                        }
                        parent.remove(selectedNode);
                        parent.getOp().setTables(tablesParent);
                        parent.setLabel("<html>" + parent.getOp().toString());
                    } else if (selectedNode.getOp().isLastOpLeft()) {
                        String[] tablesSelectedNode = selectedNode.getOp().getTables();
                        String[] tablesParent = parent.getOp().getTables();
                        if (parent.getOp().isLastOpLeft()) {
                            tablesParent[1] = tablesSelectedNode[0];
                        } else if (parent.getOp().isLastOpRight()) {
                            tablesParent[0] = tablesSelectedNode[0];
                        } else {
                            tablesParent[selectedNodePosition] = tablesSelectedNode[0];
                        }
                        parent.remove(selectedNode);
                        parent.getOp().setTables(tablesParent);
                        parent.setLabel("<html>" + parent.getOp().toString());
                    } else if (selectedNode.getOp().isLastOpRight()) {
                        parent.remove(selectedNode);
                        parent.insert((OpNode)selectedNode.getChildAt(0), selectedNodePosition);
                    } else {
                        parent.remove(selectedNode);
                        parent.insert((OpNode)selectedNode.getChildAt(0), selectedNodePosition);
                    }
                } else {
                    if (scelta != 1) return;
                    if (selectedNode.getOp().isLastOp()) {
                        String[] tablesSelectedNode = selectedNode.getOp().getTables();
                        String[] tablesParent = parent.getOp().getTables();
                        if (parent.getOp().isLastOpLeft()) {
                            tablesParent[1] = tablesSelectedNode[1];
                        } else if (parent.getOp().isLastOpRight()) {
                            tablesParent[0] = tablesSelectedNode[1];
                        } else {
                            tablesParent[selectedNodePosition] = tablesSelectedNode[1];
                        }
                        parent.remove(selectedNode);
                        parent.getOp().setTables(tablesParent);
                        parent.setLabel("<html>" + parent.getOp().toString());
                    } else if (selectedNode.getOp().isLastOpLeft()) {
                        parent.remove(selectedNode);
                        parent.insert((OpNode)selectedNode.getChildAt(0), selectedNodePosition);
                    } else if (selectedNode.getOp().isLastOpRight()) {
                        String[] tablesSelectedNode = selectedNode.getOp().getTables();
                        String[] tablesParent = parent.getOp().getTables();
                        if (parent.getOp().isLastOpLeft()) {
                            tablesParent[1] = tablesSelectedNode[1];
                        } else if (parent.getOp().isLastOpRight()) {
                            tablesParent[0] = tablesSelectedNode[1];
                        } else {
                            tablesParent[selectedNodePosition] = tablesSelectedNode[1];
                        }
                        parent.remove(selectedNode);
                        parent.getOp().setTables(tablesParent);
                        parent.setLabel("<html>" + parent.getOp().toString());
                    } else {
                        parent.remove(selectedNode);
                        parent.insert((OpNode)selectedNode.getChildAt(1), selectedNodePosition);
                    }
                }
            }
            Project.getTree().reload((OpNode)Project.getTree().getRoot());
            ((Ascoltatori)Ascoltatori.this).gui.albero.setModel(Project.getTree());
            Ascoltatori.this.expand((OpNode)Project.getTree().getRoot());
            if (Project.isLoaded()) {
                try {
                    ((Ascoltatori)Ascoltatori.this).gui.semaforo.setVerde();
                    RAQuery.executeQueryFromNode((OpNode)Project.getTree().getRoot());
                    Ascoltatori.this.showNodeTab((OpNode)Project.getTree().getRoot());
                    ((Ascoltatori)Ascoltatori.this).gui.queryWindow.setText(RAQuery.getRAQueryFromNode((OpNode)Project.getTree().getRoot()));
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        ((Ascoltatori)Ascoltatori.this).gui.semaforo.setRosso();
                    }
                    ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.append(dbmex.getMessage());
                }
                catch (RAException raex) {
                    ((Ascoltatori)Ascoltatori.this).gui.semaforo.setRosso();
                    ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.append(raex.getMessage());
                }
            }
            ((Ascoltatori)Ascoltatori.this).gui.albero.repaint();
        }
    }

    private class AscoltaQueryWindow
    implements MouseListener,
    MouseMotionListener {
        AscoltaQueryWindow() {
        }

        public void mouseReleased(MouseEvent me) {
            if (me.getButton() == 3) {
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem1Query.setName("help42.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem2Query.setName("help15.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem3Query.setName("help17.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem4Query.setName("help14.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem5Query.setName("help13.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem6Query.setName("help16.html");
                Ascoltatori.this.maybeShowPopupQuery(me);
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (Project.isLoaded()) {
                String selText = "";
                String queryText = "";
                int selStartPos = ((Ascoltatori)Ascoltatori.this).gui.queryWindow.viewToModel(new Point(me.getX(), me.getY()));
                try {
                    OpNode node = (OpNode)((Ascoltatori)Ascoltatori.this).gui.albero.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    queryText = RAQuery.getPlainRAQueryFromNode(node);
                    selText = ((Ascoltatori)Ascoltatori.this).gui.queryWindow.getText(selStartPos, 1);
                }
                catch (BadLocationException node) {
                    // empty catch block
                }
                if (selText.equals(")")) {
                    int bracketNumber = 1;
                    int currentPos = selStartPos - 1;
                    boolean bracketNotFound = true;
                    while (bracketNotFound) {
                        if (queryText.charAt(currentPos - 1) == ')') {
                            ++bracketNumber;
                        }
                        if (queryText.charAt(currentPos - 1) == '(') {
                            --bracketNumber;
                        }
                        if (bracketNumber == 0) {
                            bracketNotFound = false;
                        }
                        --currentPos;
                    }
                    ((Ascoltatori)Ascoltatori.this).gui.queryWindow.select(currentPos + 1, currentPos + 2);
                    return;
                }
                if (selText.equals("(")) {
                    int bracketNumber = 1;
                    int currentPos = selStartPos + 1;
                    boolean bracketNotFound = true;
                    while (bracketNotFound) {
                        if (queryText.charAt(currentPos - 1) == '(') {
                            ++bracketNumber;
                        } else if (queryText.charAt(currentPos - 1) == ')') {
                            --bracketNumber;
                        }
                        if (bracketNumber == 0) {
                            bracketNotFound = false;
                        }
                        ++currentPos;
                    }
                    ((Ascoltatori)Ascoltatori.this).gui.queryWindow.select(currentPos - 1, currentPos);
                    return;
                }
                if (!selText.equals("")) {
                    ((Ascoltatori)Ascoltatori.this).gui.queryWindow.select(0, 0);
                }
            }
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
            ((Ascoltatori)Ascoltatori.this).gui.queryWindow.select(0, 0);
        }

        public void mousePressed(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
            this.mouseClicked(me);
        }
    }

    private class AscoltaSelezioneAlbero
    implements MouseListener,
    TreeSelectionListener {
        AscoltaSelezioneAlbero() {
        }

        private void showNodeSelection(OpNode node) {
            if (node != null) {
                Ascoltatori.this.showNodeTab(node);
                ((Ascoltatori)Ascoltatori.this).gui.queryWindow.setText(RAQuery.getRAQueryFromNode(node));
            }
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (Project.isLoaded()) {
                this.showNodeSelection((OpNode)((Ascoltatori)Ascoltatori.this).gui.albero.getLastSelectedPathComponent());
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.getButton() == 3) {
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem1.setName("help21.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem2.setName("help22.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem3.setName("help24.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem4.setName("help15.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem5.setName("help17.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem6.setName("help14.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem7.setName("help13.html");
                ((Ascoltatori)Ascoltatori.this).gui.popUpMenuItem8.setName("help16.html");
                Ascoltatori.this.maybeShowPopup(me);
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (Project.isLoaded()) {
                if (((Ascoltatori)Ascoltatori.this).gui.albero.getPathForLocation(me.getX(), me.getY()) == null) {
                    ((Ascoltatori)Ascoltatori.this).gui.albero.clearSelection();
                    ((Ascoltatori)Ascoltatori.this).gui.queryWindow.setText("");
                    ((Ascoltatori)Ascoltatori.this).gui.tabelleNodi.setModel(new DefaultTableModel(1, 1));
                    ((Ascoltatori)Ascoltatori.this).gui.labContaRigheTab.setText("");
                    return;
                }
                OpNode node = (OpNode)((Ascoltatori)Ascoltatori.this).gui.albero.getPathForLocation(me.getX(), me.getY()).getLastPathComponent();
                Ascoltatori.this.expand((OpNode)((Ascoltatori)Ascoltatori.this).gui.albero.getModel().getRoot());
                ((Ascoltatori)Ascoltatori.this).gui.albero.repaint();
                if (me.getClickCount() == 1) {
                    this.showNodeSelection(node);
                } else if (me.getClickCount() == 2) {
                    Ascoltatori.this.editSelectedNode();
                    node = (OpNode)((Ascoltatori)Ascoltatori.this).gui.albero.getLastSelectedPathComponent();
                    this.showNodeSelection(node);
                }
                Ascoltatori.this.expand((OpNode)((Ascoltatori)Ascoltatori.this).gui.albero.getModel().getRoot());
                ((Ascoltatori)Ascoltatori.this).gui.albero.repaint();
            }
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
        }
    }

    private class AscoltaTabelle
    implements ChangeListener {
        AscoltaTabelle() {
        }

        public void stateChanged(ChangeEvent event) {
            if (((Ascoltatori)Ascoltatori.this).gui.tabellaDB.getTabCount() > 0) {
                int selectedTabIndex = ((Ascoltatori)Ascoltatori.this).gui.tabellaDB.getSelectedIndex();
                if (selectedTabIndex < 0) {
                    return;
                }
                String nome = ((Ascoltatori)Ascoltatori.this).gui.tabellaDB.getTitleAt(selectedTabIndex);
                try {
                    ResultSet rset = DBManager.executeQuery("SELECT * FROM " + nome);
                    CachedResultSetTableModel crs = new CachedResultSetTableModel(rset);
                    ((Ascoltatori)Ascoltatori.this).gui.tabella.setModel(crs);
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        ((Ascoltatori)Ascoltatori.this).gui.semaforo.setRosso();
                    }
                    ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.append(dbmex.getMessage());
                    ((Ascoltatori)Ascoltatori.this).gui.logWindow.append(dbmex.getMessage());
                }
            }
        }
    }

    private class FiltroVRA
    extends FileFilter {
        FiltroVRA() {
        }

        public String getDescription() {
            return "File di VisualRA (*.vra)";
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String nome = file.getName();
            String ext = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
            return ext.equals("vra");
        }
    }

    private class AscoltaNuovo
    implements ActionListener {
        AscoltaNuovo() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!Project.isLoaded()) {
                new NewProject(Ascoltatori.this.gui);
            } else {
                JFrame frame = new JFrame();
                int n = JOptionPane.showConfirmDialog(frame, String.valueOf(Language.getInstance().getString("Salvare_modifiche_apportate_al_progetto_corrente_?")) + Language.getInstance().getString("Scegliendo_NO_tutte_modifiche_andranno_perse_!"), Language.getInstance().getString("Attenzione"), 1, 3);
                if (n == 0) {
                    ProjectFile.save(Project.getProjectFile());
                    new NewProject(Ascoltatori.this.gui);
                } else if (n == 1) {
                    new NewProject(Ascoltatori.this.gui);
                }
            }
            Ascoltatori.this.gui.setTitle(String.valueOf(Language.getInstance().getString("versione")) + " - " + Project.getTitle());
            ((Ascoltatori)Ascoltatori.this).gui.albero.setModel(Project.getTree());
            ((Ascoltatori)Ascoltatori.this).gui.albero.repaint();
        }
    }

    private class AscoltaApri
    implements ActionListener {
        AscoltaApri() {
        }

        public void actionPerformed(ActionEvent e) {
            if (Project.isLoaded()) {
                JFrame frame = new JFrame();
                int n = JOptionPane.showConfirmDialog(frame, String.valueOf(Language.getInstance().getString("Salvare_modifiche_apportate_al_progetto_corrente_?")) + Language.getInstance().getString("Scegliendo_NO_tutte_modifiche_andranno_perse_!"), Language.getInstance().getString("Attenzione"), 1, 3);
                if (n == 0) {
                    ProjectFile.save(Project.getProjectFile());
                } else if (n == 2 || n == -1) {
                    return;
                }
            }
            JFileChooser apriFile = new JFileChooser((String)VisualRA.cfgMap.get("LAST_PROJECT_PATH"));
            apriFile.setFileFilter(new FiltroVRA());
            int scelta = apriFile.showOpenDialog(Ascoltatori.this.gui);
            if (scelta == 0) {
                try {
                    File fileName = apriFile.getSelectedFile();
                    ProjectFile projectFile = ProjectFile.load(fileName.getAbsolutePath());
                    File checkedDBFile = new File(projectFile.getDBFileName());
                    if (!checkedDBFile.exists()) {
                        if (!(checkedDBFile = new File(checkedDBFile.getName())).exists()) {
                            throw new DBManagerException(LogManager.prepareMsg(Language.getInstance().getString("Errore_DB_db_file_mancante"), true));
                        }
                        int n = JOptionPane.showConfirmDialog(new JFrame(), String.valueOf(Language.getInstance().getString("DB_cambiato_di_posizione_aggiornare_?")) + Language.getInstance().getString("Scegliendo_SI_il_progetto_viene_aggiorn_al_salvataggio"), Language.getInstance().getString("Attenzione"), 0, 3);
                        if (n == 1 || n == -1) {
                            return;
                        }
                    }
                    ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.setTextVRA("");
                    ((Ascoltatori)Ascoltatori.this).gui.logWindow.setTextVRA("");
                    projectFile.setDBFileName(checkedDBFile.getAbsolutePath());
                    DBManager.connect(projectFile.getDBDriver(), new File(projectFile.getDBFileName()), projectFile.getDBUrl(), projectFile.getDBTemptabPrefix());
                    Project.setProjectFile(projectFile);
                    ((Ascoltatori)Ascoltatori.this).gui.salvafile.setEnabled(true);
                    ((Ascoltatori)Ascoltatori.this).gui.saveProject.setEnabled(true);
                    ((Ascoltatori)Ascoltatori.this).gui.saveAsProject.setEnabled(true);
                    ((Ascoltatori)Ascoltatori.this).gui.modificaNodo.setEnabled(true);
                    ((Ascoltatori)Ascoltatori.this).gui.deleteQuery.setEnabled(true);
                    ((Ascoltatori)Ascoltatori.this).gui.opUnario.setEnabled(true);
                    ((Ascoltatori)Ascoltatori.this).gui.opBinario.setEnabled(true);
                    ((Ascoltatori)Ascoltatori.this).gui.modificaOp.setEnabled(true);
                    ((Ascoltatori)Ascoltatori.this).gui.eliminaOp.setEnabled(true);
                    ((Ascoltatori)Ascoltatori.this).gui.saveAsTable.setEnabled(true);
                    ((Ascoltatori)Ascoltatori.this).gui.queryWindow.setText("");
                    ((Ascoltatori)Ascoltatori.this).gui.tabelleNodi.setModel(new DefaultTableModel(10, 6));
                    ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.setTextVRA(LogManager.prepareMsg(Language.getInstance().getString("Il_programma_\u00e8_connesso_al_Database..."), false));
                    ((Ascoltatori)Ascoltatori.this).gui.logWindow.setTextVRA(LogManager.prepareMsg(Language.getInstance().getString("Il_programma_\u00e8_connesso_al_Database..."), false));
                    Ascoltatori.this.gui.setTitle(String.valueOf(Language.getInstance().getString("versione")) + " - " + Project.getTitle());
                    String fileWithPath = fileName.getAbsolutePath();
                    VisualRA.cfgMap.put("LAST_PROJECT_PATH", fileWithPath.substring(0, fileWithPath.length() - fileName.getName().length() - 1));
                    ((Ascoltatori)Ascoltatori.this).gui.tabellaDB.removeAll();
                    TreeSet dbTables = DBManager.getTables();
                    Iterator itr = dbTables.iterator();
                    while (itr.hasNext()) {
                        String name = (String)itr.next();
                        ((Ascoltatori)Ascoltatori.this).gui.tabellaDB.addTab(name, null);
                        ((Ascoltatori)Ascoltatori.this).gui.tabellaDB.setComponentAt(0, ((Ascoltatori)Ascoltatori.this).gui.panTabelleDB);
                    }
                    if (Project.isLoaded()) {
                        ((Ascoltatori)Ascoltatori.this).gui.semaforo.setVerde();
                        RAQuery.executeQuery();
                    }
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        ((Ascoltatori)Ascoltatori.this).gui.semaforo.setRosso();
                    }
                    ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.append(dbmex.getMessage());
                    ((Ascoltatori)Ascoltatori.this).gui.logWindow.append(dbmex.getMessage());
                }
                catch (RAException raex) {
                    ((Ascoltatori)Ascoltatori.this).gui.semaforo.setRosso();
                    ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.append(raex.getMessage());
                }
                ((Ascoltatori)Ascoltatori.this).gui.albero.setModel(Project.getTree());
                ((Ascoltatori)Ascoltatori.this).gui.albero.repaint();
                Ascoltatori.this.expand((OpNode)Project.getTree().getRoot());
            }
        }
    }

    private class AscoltaSalva
    implements ActionListener {
        AscoltaSalva() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!Project.isLoaded()) {
                JOptionPane.showMessageDialog(Ascoltatori.this.gui, Language.getInstance().getString("Impossibile_salvare_un_progetto_senza_query_definite_!"), Language.getInstance().getString("Impossibile_salvare"), 2);
            } else {
                ProjectFile.save(Project.getProjectFile());
            }
        }
    }

    private class AscoltaSalvaConNome
    implements ActionListener {
        AscoltaSalvaConNome() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!Project.isLoaded()) {
                JOptionPane.showMessageDialog(Ascoltatori.this.gui, Language.getInstance().getString("Impossibile_salvare_un_progetto_senza_query_definite_!"), Language.getInstance().getString("Impossibile_salvare"), 2);
            } else {
                JFileChooser salvaFile = new JFileChooser((String)VisualRA.cfgMap.get("LAST_PROJECT_PATH"));
                String nomeFileWOExt = new File(Project.getFileName()).getName();
                nomeFileWOExt = nomeFileWOExt.substring(0, nomeFileWOExt.length() - 4);
                salvaFile.setSelectedFile(new File(nomeFileWOExt));
                salvaFile.setDialogTitle(Language.getInstance().getString("Salva_con_nome"));
                salvaFile.setFileFilter(new FiltroVRA());
                int scelta = salvaFile.showSaveDialog(Ascoltatori.this.gui);
                if (scelta == 0) {
                    boolean overwrite = false;
                    do {
                        File saveFileWExt;
                        if ((saveFileWExt = new File(String.valueOf(salvaFile.getSelectedFile().getAbsolutePath()) + ".vra")).exists()) {
                            JFrame frame = new JFrame();
                            int n = JOptionPane.showConfirmDialog(frame, String.valueOf(Language.getInstance().getString("Il_file_esiste_gi\u00e0.\n")) + Language.getInstance().getString("Sovrascrivere_il_file_esistente_?\n"), Language.getInstance().getString("Attenzione"), 0, 3);
                            if (n == 0) {
                                overwrite = true;
                                continue;
                            }
                            scelta = salvaFile.showSaveDialog(Ascoltatori.this.gui);
                            if (scelta == 0) continue;
                            return;
                        }
                        overwrite = true;
                    } while (!overwrite);
                    try {
                        String fileWithPath = salvaFile.getSelectedFile().getAbsolutePath();
                        VisualRA.cfgMap.put("LAST_PROJECT_PATH", fileWithPath.substring(0, fileWithPath.length() - salvaFile.getSelectedFile().getName().length() - 1));
                        Project.setFileName(String.valueOf(salvaFile.getSelectedFile().getAbsolutePath()) + ".vra");
                        ProjectFile.save(Project.getProjectFile());
                        Ascoltatori.this.gui.setTitle(String.valueOf(Language.getInstance().getString("versione")) + " - " + Project.getTitle());
                    }
                    catch (Exception x) {
                        System.out.println("errore");
                    }
                }
            }
        }
    }

    private class AscoltaModifica
    implements ActionListener {
        AscoltaModifica() {
        }

        public void actionPerformed(ActionEvent e) {
            if (Project.isLoaded()) {
                OpNode selectedNode = (OpNode)((Ascoltatori)Ascoltatori.this).gui.albero.getLastSelectedPathComponent();
                if (selectedNode == null) {
                    JOptionPane.showMessageDialog(null, Language.getInstance().getString("Occorre_selezionare_un_nodo_per_modificarlo"), Language.getInstance().getString("Errore"), 2);
                    return;
                }
                Ascoltatori.this.editSelectedNode();
                OpNode node = (OpNode)((Ascoltatori)Ascoltatori.this).gui.albero.getLastSelectedPathComponent();
                Ascoltatori.this.showNodeTab(node);
                ((Ascoltatori)Ascoltatori.this).gui.queryWindow.setText(RAQuery.getRAQueryFromNode(node));
            }
        }
    }

    private class AscoltaSelezione
    implements ActionListener {
        AscoltaSelezione() {
        }

        public void actionPerformed(ActionEvent e) {
            Ascoltatori.this.insertUnaryNode(0);
        }
    }

    private class AscoltaProiezione
    implements ActionListener {
        AscoltaProiezione() {
        }

        public void actionPerformed(ActionEvent e) {
            Ascoltatori.this.insertUnaryNode(1);
        }
    }

    private class AscoltaRidenominazione
    implements ActionListener {
        AscoltaRidenominazione() {
        }

        public void actionPerformed(ActionEvent e) {
            Ascoltatori.this.insertUnaryNode(2);
        }
    }

    private class AscoltaSet
    implements ActionListener {
        AscoltaSet() {
        }

        public void actionPerformed(ActionEvent e) {
            Ascoltatori.this.insertBinaryNode(3);
        }
    }

    private class AscoltaJoin
    implements ActionListener {
        AscoltaJoin() {
        }

        public void actionPerformed(ActionEvent e) {
            Ascoltatori.this.insertBinaryNode(6);
        }
    }

    private class AscoltaSelezioneLog
    implements ActionListener {
        AscoltaSelezioneLog() {
        }

        public void actionPerformed(ActionEvent e) {
            if (((Ascoltatori)Ascoltatori.this).gui.semaforo.isRosso()) {
                ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.requestFocus();
                ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.selectAll();
                String s = ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.getSelectedText();
                ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.select(s.lastIndexOf("@"), s.length());
            } else {
                ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.select(0, 0);
            }
        }
    }

    private class AscoltaSaveAsTable
    implements ActionListener {
        AscoltaSaveAsTable() {
        }

        public void actionPerformed(ActionEvent e) {
            if (Project.isLoaded() && !((Ascoltatori)Ascoltatori.this).gui.semaforo.isRosso()) {
                OpNode selectedNode = (OpNode)((Ascoltatori)Ascoltatori.this).gui.albero.getLastSelectedPathComponent();
                if (selectedNode == null) {
                    JOptionPane.showMessageDialog(null, Language.getInstance().getString("Occorre_selezionare_un_nodo_per_salvarlo_come_tabella"), Language.getInstance().getString("Errore"), 2);
                    return;
                }
                try {
                    ResultSet rs = RAQuery.getRSFromNode(selectedNode);
                    new SaveResultTableDialog(Ascoltatori.this.gui, rs);
                }
                catch (DBManagerException dbmex) {
                    if (dbmex.isRACaused()) {
                        ((Ascoltatori)Ascoltatori.this).gui.semaforo.setRosso();
                    }
                    ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.append(dbmex.getMessage());
                }
                catch (RAException raex) {
                    ((Ascoltatori)Ascoltatori.this).gui.semaforo.setRosso();
                    ((Ascoltatori)Ascoltatori.this).gui.dialogWindow.append(raex.getMessage());
                }
            }
        }
    }
}

