package org.basidati.esercitazioneJDBC;

import java.sql.*;

public class Esercizio_1_3 {
	public static void main(String[] arg){
		
    Connection con = null;
    try { // Caricamento del driver
		//Class.forName("COM.ibm.db2.jdbc.net.DB2Driver");
		Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
    }
    catch (ClassNotFoundException exClass) {
    System.err.println("Fallita connessione al database. Driver non " +
    "trovato");
    }  
    
	String url = "jdbc:odbc:EsercSQL";
	//String url = "jdbc:db2://localhost/SQL2";
	String username = "";
	String pwd = "";
    try { // Apertura della connessione
       	con = DriverManager.getConnection(url, username, pwd);
    }
    catch (SQLException exSQL) {
        System.err.println("Fallita connessione al database. La sorgente " +
        	"dati non esiste.");
        System.err.println(exSQL.getErrorCode() + " " + exSQL.getSQLState()+
           exSQL.getMessage() );
    }
       
    try { // Esecuzione dell'interrogazione SQL
    	
		Statement query = con.createStatement();
		String queryString =
            "SELECT Nome, Indirizzo, Citt,  " +
            "       Marca, Tipo, Modello, Costo " +
            "FROM Fornitori AS F, Catalogo AS C, Prodotti AS P " +
            "WHERE C.CodiceFornitore = F.CodiceFornitore    " +
            "  AND C.CodiceProdotto = P.CodiceProdotto     " +
            "ORDER BY Nome, Marca, Tipo, Modello ";
          
		ResultSet result = query.executeQuery(queryString);
    
	    // Elaborazione del risultato
	    boolean newFornitore = true, firstRow = true ;
	    String nomeF, indirizzoF, cittaF, marcaP, tipoP, modelloP; int costoC ;
	    String nomeF_old = "";
	    while (result.next()){
	    	nomeF = result.getString("Nome");
			indirizzoF = result.getString("Indirizzo");
	   		cittaF = result.getString("Citt");
	    	if (nomeF_old.equals(nomeF)) newFornitore = false ;
	    	if (newFornitore)
				System.out.println(nomeF + " " + indirizzoF + " " + cittaF );
	    	marcaP = result.getString("Marca");
			tipoP = result.getString("Tipo") ;
			modelloP = result.getString("Modello") ;
			costoC = result.getInt("Costo") ;  // sia costo un intero
			System.out.println("\t" + marcaP + " " + tipoP + "  " + 
									  modelloP + " " + costoC);
			nomeF_old = nomeF ;
	    	newFornitore = true ;
	    } // chiudo while

	    result.close();
	    query.close();
	    con.close();
  	} // chiudo try
    catch (SQLException exQuery){
	    System.err.println("Errore nell'interrogazione.");
	    System.err.println(exQuery.getErrorCode() + " " + 
	   		exQuery.getSQLState() + "\n" + exQuery.getMessage() );
    }
    
    System.out.println();
	System.out.println("programma terminato.");
    
    } // chiudo main
}
