package org.basidati.esercitazioneJDBC;

import java.sql.*;

public class Esercizio_1_2 {
	
	// Array contenente i record da inserire
	static String[] SQLData = {
      	"('001', 'Ladroni',      'Via Ostense',   'Roma')",
      	"('002', 'Risparmietti', 'Viale Marconi', 'Roma')",
        "('010', 'Teloporto',    'Via Roma',      'Milano')"
	};
      
    public static void main(String[] arg){
    	
      	Connection con = null;
      	try { // Caricamento del driver
	    	Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
      	}
      	catch (ClassNotFoundException exClass) {
			System.err.println("Fallita connessione al database. Driver non " +
				"trovato");
      	}  
      	try { // Apertura della connessione
      		String url = "jdbc:odbc:EsercSQL";
            String username = "";
            String pwd = "";  
            con = DriverManager.getConnection(url, username, pwd);
      	}
      	catch (SQLException exSQL) {
			System.err.println("Fallita connessione al database. La sorgente " +
				"dati non esiste.");
			System.err.println(exSQL.getErrorCode() + " " + exSQL.getSQLState() +  exSQL.getMessage() );
  	  	}
     
     	try { // Esecuzione dell'interrogazione SQL
     		Statement stmt = con.createStatement();
	    	int iRowCount = 0;
            	for (int i = 0; i < SQLData.length; i++) {
            		iRowCount += 
                    stmt.executeUpdate( 
                      	"INSERT INTO Fornitori VALUES " + 
                       	SQLData[i] );
            	}
            System.out.println( iRowCount + 
            	" righe inserite nalla tabella Fornitori.");

            stmt.close();
            con.close();
      	}
	  	catch (SQLException exQuery){
			System.err.println("Errore nell'interrogazione.");
			System.err.println(exQuery.getErrorCode() + " " + 
	  	  		exQuery.getSQLState() + "\n" + exQuery.getMessage() );
	  	}
	  	System.out.println();
	  	System.out.println("programma terminato.");
    
    }   // chiudo main
    
} // end Esercizio_1_2

