package org.basidati.esercitazioneJDBC;

import java.sql.*;

public class Esercizio_1_1 {
	public static void main(String[] arg){
		Connection con = null;
		try { // Caricamento del driver
			Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
      	}
      	catch (ClassNotFoundException exClass) {
			System.err.println("Fallita connessione al database. Driver non " +
				"trovato");
      	}
      	
		String url = "jdbc:odbc:EsercSQL";
		String username = "";
		String pwd = "";
      	try { // Apertura della connessione
        	con = DriverManager.getConnection(url, username, pwd);
      	}
      	catch (SQLException exSQL) {
			System.err.println("Fallita connessione al database. La sorgente " +
				"dati (ODBC) non esiste.");
        	System.err.println(exSQL.getErrorCode() + " " + exSQL.getSQLState() +  exSQL.getMessage() );
      	}
      
      	try { // Esecuzione dell'interrogazione SQL
		    Statement createTable = con.createStatement();
		    createTable.executeUpdate( "CREATE TABLE Fornitori ("  +
                      "CodiceFornitore   VARCHAR (8)  NOT NULL, "  +
                      "Nome              VARCHAR (20) NOT NULL, "  +
                      "Indirizzo         VARCHAR (30)         , "  +
                      "Citt             VARCHAR (20)         , "  +
                      "PRIMARY KEY( CodiceFornitore )			)");

            System.out.println("La tabella Fornitori e' stata creata.");
            createTable.close();
            con.close();
      	}
      	
		catch (SQLException exQuery){
			System.err.println("Errore nell'interrogazione.");
			System.err.println(exQuery.getErrorCode() + " " + 
			  exQuery.getSQLState() + "\n" + exQuery.getMessage() );
		}
		System.out.println();
		System.out.println("programma terminato.");
	} // chiudo main
}